"  ---- Ronald Brill 1995, 1996 ---- "
"  ---- Extended File Dialogs Version 2.1 ---- "


ENFINController subclass: #ExtendedFileDialogSetupController
instanceVariableNames: '
	modus
	setupCancelButt
	setupFilterLabelEntry
	setupFilterLabelList
	setupFilterMappingDroDoLi
	setupFilterValueEntry
	setupFilterValueList
	setupFontFontSelectionIC
	setupNote
	setupOKButt
	setupOptionsReorderCheck
'
classVariableNames: ''
poolDictionaries: '' !


!ExtendedFileDialogSetupController class methods!


initialize
	self createInstanceName: #ExtendedFileDialogSetup.
!"end initialize"


createInstanceName: name
	|controller|
	controller := self name: name.
	controller setStartCursorsAutomaticallyTo: false.
	controller createItems; initializeBindings.
	controller finishInit.
	^ controller.
!"end createInstanceName:"


!"End of ExtendedFileDialogSetupController class methods block"

!ExtendedFileDialogSetupController methods!


createItems
	|cItem temp form controller|
	controller := self.
	form := DialogBox
		name:				controllerName
		title:			#'Extended File Diaolg Setup'
		rect:				{982 131 1331 1159}
		controller:		controller.
	form setGridTo: false.
	form setSnapTo: true.
	form setXGridResTo: 19.
	form setYGridResTo: 19.
	cItem := controller add: #setupNote
		class:			FormNoteBook
		rect:				{0 0 1297 960}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form.
	cItem setMajorTabWidthTo: 330.
	cItem setMajorTabHeightTo: 90.
	cItem setPageButtonWidthTo: 50.
	cItem setPageButtonHeightTo: 50.
	cItem setTabStyleTo: #Square.
	cItem setMajorTabLocationTo: #LeftOrRight.
	cItem setBackPagesLocationTo: #BottomRight.
	cItem setBindingStyleTo: #Spiral.
	cItem setPagesTo: {#'Preview Font' #Filters #Options}.
	cItem := controller add: #setupOKButt
		class:			FormButton
		rect:				{37 919 352 97}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'&OK'.
	cItem := controller add: #setupCancelButt
		class:			FormButton
		rect:				{431 919 352 97}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'&Cancel'.
	form := Page
		name:				#Options
		rect:				{1076 491 821 682}
		controller:		controller.
	form setGridTo: false.
	form setSnapTo: true.
	form setXGridResTo: 19.
	form setYGridResTo: 19.
	cItem := controller add: #setupOptionsReorderCheck
		class:			FormCheckBox
		rect:				{37 56 754 79}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'move last loaded file on top'.
	form setPageStyleTo: {#MajorPage}.
	form := Page
		name:				#Filters
		rect:				{1076 491 821 682}
		controller:		controller.
	form setGridTo: false.
	form setSnapTo: true.
	form setXGridResTo: 19.
	form setYGridResTo: 19.
	cItem := controller add: #setupFilterToBo1
		class:			FormTopicBox
		rect:				{19 525 791 154}
		options:			{#Draw3D}
		form:				form
		text:				' Map *.cls to '.
	cItem setFormatTo: {#Left #Top}.
	cItem := controller add: #setupFilterMappingDroDoLi
		class:			FormDropList
		rect:				{37 581 754 79}
		options:			{#Return #Tab #Backtab}
		form:				form.
	(cItem formItem) setLineCountTo: 0.
	cItem := controller add: #setupFilterToBo
		class:			FormTopicBox
		rect:				{19 37 791 469}
		options:			{#Draw3D}
		form:				form
		text:				' Availabe Filters '.
	cItem setFormatTo: {#Left #Top}.
	cItem := controller add: #setupFilterLabelEntry
		class:			FormString
		rect:				{49 105 445 60}
		options:			{#Return #Tab #Up #Down #Backtab}
		form:				form.
	cItem := controller add: #setupFilterValueEntry
		class:			FormString
		rect:				{517 105 266 60}
		options:			{#Return #Tab #Up #Down #Backtab}
		form:				form.
	cItem setMaximumLengthTo: 9.
	cItem := controller add: #setupFilterValueList
		class:			FormSyncList
		rect:				{506 179 285 312}
		options:			{#Return #Tab #Backtab}
		form:				form.
	cItem := controller add: #setupFilterLabelList
		class:			FormSyncList
		rect:				{37 179 465 312}
		options:			{#Return #Tab #Backtab #NoVScroll}
		form:				form.
	form setPageStyleTo: {#MajorPage}.
	temp := {{#setupFilterValueList #setupFilterLabelList}
			#setupFilterMappingDroDoLi #setupFilterLabelEntry
			#setupFilterValueEntry}.
	form addFormItemGroups: temp in: controller.
	form := Page
		name:				#'Preview Font'
		rect:				{1076 491 821 682}
		controller:		controller.
	form setGridTo: false.
	form setSnapTo: true.
	form setXGridResTo: 19.
	form setYGridResTo: 19.
	cItem := controller add: #setupFontFontSelectionIC
		class: ICFontSelection
		position: 18 @ 35
		form:		form.
	form setPageStyleTo: {#MajorPage}.
	temp := {#'setupFontFontSelectionIC.fontFaceDroDoLi'
			#'setupFontFontSelectionIC.fontSizeDroDoLi'
			#'setupFontFontSelectionIC.fontAttributesCheckLi'}.
	form addFormItemGroups: temp in: controller.
	controller synchronizeList: {#setupFilterLabelList #setupFilterValueList}.
	controller setMainFormTo: controllerName.
!"end createItems"


initializeBindings
	|temp|
	temp := IdentityDictionary newEntries: 2.
	temp at: #setupFilterLabelEntry put: (#enterOnFilterEntry).
	temp at: #setupFilterValueEntry put: (#enterOnFilterEntry).
	(formDict at: #Filters) addReturnActions: temp.
	temp := AcceleratorTable new.
	temp at: #AltC put: #setupCancel.
	temp at: #Altc put: #setupCancel.
	temp at: #Alto put: #setupOk.
	temp at: #AltO put: #setupOk.
	temp at: #Delete put: #deleteOnFilterEntry.
	(formDict at: #Filters) acceleratorTableAddAll: temp.
	temp := AcceleratorTable new.
	temp at: #AltC put: #setupCancel.
	temp at: #Altc put: #setupCancel.
	temp at: #AltO put: #setupOk.
	temp at: #Alto put: #setupOk.
	(formDict at: #'Preview Font') acceleratorTableAddAll: temp.
	temp := AcceleratorTable new.
	temp at: #AltC put: #setupCancel.
	temp at: #Altc put: #setupCancel.
	temp at: #AltO put: #setupOk.
	temp at: #Alto put: #setupOk.
	(formDict at: #Options) acceleratorTableAddAll: temp.
	temp := self actionDict.
	temp at: #setupCancelButt put: #setupCancel.
	temp at: #setupOKButt put: #setupOk.
	temp at: #setupFilterLabelList put: #selectFilter.
!"end initializeBindings"


!"End of ExtendedFileDialogSetupController methods block"
