"  ---- Ronald Brill 1995, 1996 ---- "
"  ---- Extended File Dialogs Version 2.1 ---- "


ExtendedFileDialogSetupController SecondaryFile !


! ExtendedFileDialogSetupController methods!


deleteOnFilterEntry
| selection item |
   item := (formDict at: #Filters) focus controllerItem.
   item name == #setupFilterMappingDroDoLi ifTrue: [ ^ self.].

   modus ~~ #change ifTrue: [ ^ self.].

   selection := setupFilterLabelList getSelection.
   setupFilterLabelList put: (setupFilterLabelList getList removeAt: selection).
   setupFilterValueList put: (setupFilterValueList getList removeAt: selection).
   self refreshMappingList.
   setupFilterLabelList display: #New.
   setupFilterLabelEntry setFocus.
!"end deleteOnFilterEntry"


enterOnFilterEntry
| tempLabel tempValue tempSelection |
   "  ---- Plausis ---- "
   setupFilterLabelEntry getValue isEmpty
   ifTrue:
   [  setupFilterLabelEntry setFocus.
      ^ ModalMessageBox
            title: 'Error'
            text: 'Must enter an Label for the Filter!'
            icon: #StopSign
            buttons: {#OK}
            action: nil
            controller: self.
   ].
   setupFilterValueEntry getValue isEmpty
   ifTrue:
   [  setupFilterValueEntry setFocus.
      ^ ModalMessageBox
            title: 'Error'
            text: 'Must enter an Filter!'
            icon: #StopSign
            buttons: {#OK}
            action: nil
            controller: self.
   ].

   tempLabel := setupFilterLabelEntry getValue asSymbol.
   tempValue := setupFilterValueEntry getValue asSymbol.
   modus == #new
   ifTrue:
   [  setupFilterLabelList put: ( setupFilterLabelList getList add: tempLabel).
   	setupFilterValueList put: (setupFilterValueList getList add: tempValue).

      setupFilterLabelList display: #New.
      setupFilterLabelEntry setFocus.
   ].
   modus == #change
   ifTrue:
   [  tempSelection := setupFilterLabelList getSelection.
   	setupFilterLabelList put: (setupFilterLabelList getList at: tempSelection put: tempLabel).
   	setupFilterValueList put: (setupFilterValueList getList at: tempSelection put: tempValue).

      setupFilterLabelEntry setFocus.
   ].
   self refreshMappingList.
!"end enterOnFilterEntry"


openIniForFilter
| setup |
   setup := FileDialogSetup load.
	setupFilterLabelList put: ((Array with: #New) append: setup filterLabels).
	setupFilterValueList put: ((Array with: #'') append: setup filterValues).

   self refreshMappingList.
   setupFilterLabelList display: #New.
	setupFilterMappingDroDoLi display: setup filterMapping.
!"end openIniForFilter"


openIniForOptions
   setupOptionsReorderCheck put: FileDialogSetup load reorderFileList.
!"end openIniForOptions"


openIniForPreviewFont
   setupFontFontSelectionIC putValue: (Font newArray: FileDialogSetup load previewFont).
!"end openIniForPreviewFont"


openInitializationFor: aForm
   super openInitializationFor: aForm.
   aForm name == #Filters
   ifTrue:
   [  self openIniForFilter.
   ].
   aForm name == #'Preview Font'
   ifTrue:
   [  self openIniForPreviewFont.
   ].
   aForm name == #Options
   ifTrue:
   [  self openIniForOptions.
   ].
!"end openInitializationFor:"


refreshMappingList
| tempSelection |
	tempSelection := setupFilterMappingDroDoLi getValue.
   setupFilterMappingDroDoLi put: setupFilterValueList getList cdr.
	setupFilterMappingDroDoLi display: tempSelection.
	setupFilterMappingDroDoLi getSelection == 0
   ifTrue:
   [  setupFilterMappingDroDoLi setSelectionTo: 2.
   ].
!"end refreshMappingList"


selectFilter
| value |
   value := setupFilterLabelList getValue.

   (value == #'<All Files>') | (value == #'Class Files (*.cls)')
   ifTrue:
   [	setupFilterLabelEntry disable.
    	setupFilterValueEntry disable.
      modus := #noEdit.
   ]
   ifFalse:
   [	setupFilterLabelEntry enable.
    	setupFilterValueEntry enable.
      modus := #change.
   ].

   value == #New
   ifTrue:
   [  value := String new.
      modus := #new.
   ].

	setupFilterLabelEntry put: value.
	setupFilterValueEntry put: setupFilterValueList getValue.
!"end selectFilter"


setupCancel
   self close.
!"end setupCancel"


setupOk
| setup filters |
   setup := FileDialogSetup load.
   setup previewFont: setupFontFontSelectionIC getValue asArray.

   setup filterLabels: setupFilterLabelList getList cdr.
   setup filterValues: setupFilterValueList getList cdr.
   setup filterMapping: setupFilterMappingDroDoLi getValue.

   setup reorderFileList: setupOptionsReorderCheck getValue.
   setup save.

   self mainForm parent controller setupChanged.
   self close.
!"end setupOk"


!"End of methods block"
