"  ---- Ronald Brill 1995, 1996 ---- "
"  ---- Extended File Dialogs Version 2.1 ---- "


ENFINController subclass: #ExtendedFileDialogSetupController
instanceVariableNames: '
	modus
	setupCancelButt
	setupFilterLabelEntry
	setupFilterLabelList
	setupFilterMappingDroDoLi
	setupFilterValueEntry
	setupFilterValueList
	setupFontFontSelectionIC
	setupNote
	setupOKButt
	setupOptionsReorderCheck
'
classVariableNames: ''
poolDictionaries: '' !


!ExtendedFileDialogSetupController class methods!


initialize
	self createInstanceName: #ExtendedFileDialogSetup.
!"end initialize"


createInstanceName: name
	|controller|
	controller := self name: name.
	controller setStartCursorsAutomaticallyTo: false.
	controller createItems; initializeBindings.
	controller finishInit.
	^ controller.
!"end createInstanceName:"


!"End of ExtendedFileDialogSetupController class methods block"

!ExtendedFileDialogSetupController methods!


createItems
	|cItem temp form controller|
	controller := self.
	form := DialogBox
		name:				controllerName
		title:			#'Extended File Diaolg Setup'
		rect:				{1401 400 1332 1099}
		controller:		controller.
	form setGridTo: false.
	form setSnapTo: true.
	form setXGridResTo: 19.
	form setYGridResTo: 19.
	cItem := controller add: #setupNote
		class:			FormNoteBook
		rect:				{0 19 1299 911}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form.
	cItem setMajorTabWidthTo: 330.
	cItem setMajorTabHeightTo: 90.
	cItem setPageButtonWidthTo: 50.
	cItem setPageButtonHeightTo: 50.
	cItem setTabStyleTo: #Square.
	cItem setMajorTabLocationTo: #LeftOrRight.
	cItem setBackPagesLocationTo: #BottomRight.
	cItem setBindingStyleTo: #Spiral.
   cItem setStatusTextLocationTo: #Center.
	cItem setPagesTo: {#'Preview Font' #Filters #Options}.
	cItem := controller add: #setupOKButt
		class:			FormButton
		rect:				{39 889 351 99}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'~OK'.
	cItem := controller add: #setupCancelButt
		class:			FormButton
		rect:				{426 889 351 99}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'~Cancel'.
	form := Page
		name:				#Options
		rect:				{1459 710 862 696}
		controller:		controller.
	form setGridTo: false.
	form setSnapTo: true.
	form setXGridResTo: 19.
	form setYGridResTo: 19.
	cItem := controller add: #setupOptionsReorderCheck
		class:			FormCheckBox
		rect:				{58 58 738 80}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'move last loaded file on top'.
	form setPageStyleTo: {#MajorPage}.
	form := Page
		name:				#Filters
		rect:				{1459 710 862 696}
		controller:		controller.
	form setGridTo: false.
	form setSnapTo: true.
	form setXGridResTo: 19.
	form setYGridResTo: 19.
	cItem := controller add: #setupFilterToBo1
		class:			FormTopicBox
		rect:				{19 522 815 155}
		options:			{#Draw3D}
		form:				form
		text:				' Map *.cls to '.
	cItem setFormatTo: {#Left #Top}.
	cItem := controller add: #setupFilterMappingDroDoLi
		class:			FormDropList
		rect:				{39 577 777 86}
		options:			{#Return #Tab #Backtab}
		form:				form.
	(cItem formItem) setLineCountTo: 0.
	cItem := controller add: #setupFilterToBo
		class:			FormTopicBox
		rect:				{19 39 815 467}
		options:			{#Draw3D}
		form:				form
		text:				' Availabe Filters '.
	cItem setFormatTo: {#Left #Top}.
	cItem := controller add: #setupFilterLabelEntry
		class:			FormString
		rect:				{47 105 451 66}
		options:			{#Return #Tab #Up #Down #Backtab}
		form:				form.
	cItem := controller add: #setupFilterValueEntry
		class:			FormString
		rect:				{514 105 296 66}
		options:			{#Return #Tab #Up #Down #Backtab}
		form:				form.
	cItem setMaximumLengthTo: 9.
	cItem := controller add: #setupFilterValueList
		class:			FormSyncList
		rect:				{506 182 310 304}
		options:			{#Return #Tab #Backtab}
		form:				form.
	cItem := controller add: #setupFilterLabelList
		class:			FormSyncList
		rect:				{39 182 464 304}
		options:			{#Return #Tab #Backtab #NoVScroll}
		form:				form.
	form setPageStyleTo: {#MajorPage}.
	temp := {{#setupFilterValueList #setupFilterLabelList}
			#setupFilterMappingDroDoLi #setupFilterLabelEntry
			#setupFilterValueEntry}.
	form addFormItemGroups: temp in: controller.
	form := Page
		name:				#'Preview Font'
		rect:				{1459 710 862 696}
		controller:		controller.
	form setGridTo: false.
	form setSnapTo: true.
	form setXGridResTo: 19.
	form setYGridResTo: 19.
	cItem := controller add: #setupFontFontSelectionIC
		class: ICFontSelection
		position: 20 @ 18
		form:		form.
	form setPageStyleTo: {#MajorPage}.
	temp := {#'setupFontFontSelectionIC.fontFaceDroDoLi'
			#'setupFontFontSelectionIC.fontSizeDroDoLi'
			#'setupFontFontSelectionIC.fontAttributesCheckLi'}.
	form addFormItemGroups: temp in: controller.
	controller synchronizeList: {#setupFilterLabelList #setupFilterValueList}.
	controller setMainFormTo: controllerName.
!"end createItems"


initializeBindings
	|temp|
	temp := IdentityDictionary newEntries: 2.
	temp at: #setupFilterLabelEntry put: (#enterOnFilterEntry).
	temp at: #setupFilterValueEntry put: (#enterOnFilterEntry).
	(formDict at: #Filters) addReturnActions: temp.
	temp := AcceleratorTable new.
	temp at: #AltC put: #setupCancel.
	temp at: #Altc put: #setupCancel.
	temp at: #Alto put: #setupOk.
	temp at: #AltO put: #setupOk.
	temp at: #Delete put: #deleteOnFilterEntry.
	(formDict at: #Filters) acceleratorTableAddAll: temp.
	temp := AcceleratorTable new.
	temp at: #AltC put: #setupCancel.
	temp at: #Altc put: #setupCancel.
	temp at: #AltO put: #setupOk.
	temp at: #Alto put: #setupOk.
	(formDict at: #'Preview Font') acceleratorTableAddAll: temp.
	temp := AcceleratorTable new.
	temp at: #AltC put: #setupCancel.
	temp at: #Altc put: #setupCancel.
	temp at: #AltO put: #setupOk.
	temp at: #Alto put: #setupOk.
	(formDict at: #Options) acceleratorTableAddAll: temp.
	temp := self actionDict.
	temp at: #setupCancelButt put: #setupCancel.
	temp at: #setupOKButt put: #setupOk.
	temp at: #setupFilterLabelList put: #selectFilter.
!"end initializeBindings"


finishInit
| form |
	form := formDict at: #'Preview Font'.
   form setBackgroundTo: #DialogBackgroundColor.
   form setPageStyleTo: {#MajorPage #StatusTextOn}.
   form setStatusTextTo: 'Please select the preview font.'.
	form := formDict at: #Filters.
   form setBackgroundTo: #DialogBackgroundColor.
   form setPageStyleTo: {#MajorPage #StatusTextOn}.
   form setStatusTextTo: 'Create/Edit available filters.'.
	form := formDict at: #Options.
   form setBackgroundTo: #DialogBackgroundColor.
   form setPageStyleTo: {#MajorPage #StatusTextOn}.
   form setStatusTextTo: 'Please select an option.'.
!"end finishInit"


!"End of ExtendedFileDialogSetupController methods block"
