"  ---- Ronald Brill 1995, 1996 ---- "
"  ---- Extended File Dialogs Version 2.1 ---- "


MSOpenDialogController SecondaryFile !


! MSOpenDialogController methods!


mFileSelected
    vFileName put: vFileList getValue first.
    self preview: nil.
!"end mFileSelected"


preview: aFile
| file count text flag |
    (cItemDict at: #vPreview) isNil
    ifTrue:
    [  ^ self.
    ].
    (cItemDict at: #vPreview) getValue
    ifTrue:
    [   self fileOK.
        file := result deepCopy.
        "  ---- result mu zurckgesetzt werden, damit der 'Cancel'-Button funktioniert ---- "
        result := nil.
        "  ---- das System hat nichts gemerkt, weiter gehts ---- "
        file isString
        ifTrue:
        [   file := FileStream file: file onError: [ file := nil. ].
        ].
        (file isKindOf: Message)
        | file isArray
        | file isNil
        ifTrue:
        [   (cItemDict at: #vPreviewMLString) put: String new.
            (cItemDict at: #vAttribChList) setSelectionTo: Array new.
            #(writeEntry accessEntry creationEntry)
            do:
            [   :each |
               (cItemDict at: each + 'Date') put: String new.
               (cItemDict at: each + 'Time') put: String new.
            ].
            ^ self.
        ].
        count := 0.
        text := String new.
        [ file atEnd not & (count < 24) ]
        whileTrue:
        [   count := count + 1.
            text := text + file nextString + CrLf.
        ].
        (cItemDict at: #vPreviewMLString) put: text.

"       ---- Dateiattribute ---- "
        file := file fileName.
        flag := File privateAttributesOf: file.

        flag := #(fattrReadonly fattrHidden fattrSystem fattrArchiv)
                select:
                [   :eachFlag |
                    (flag bitAnd: (FileAccessConstants at: eachFlag)) == (FileAccessConstants at: eachFlag)
                ].
        flag := flag collect: [ :each |  #(fattrReadonly fattrHidden fattrSystem fattrArchiv) indexOf: each ].
        (cItemDict at: #vAttribChList) setSelectionTo: flag.

        #(modify access create)
        with:
        #(writeEntry accessEntry creationEntry)
        do:
        [   :eachFlag :eachEntry |
            flag := File privateAccessTimeOf: file type: eachFlag.
            (cItemDict at: eachEntry + 'Date') put: (flag at: 1) asDate asFullISOString.
            (cItemDict at: eachEntry + 'Time') put: (flag at: 2) asTime asISOString.
        ].
    ].
!"end preview:"


!"End of methods block"
