"  ---- Ronald Brill 1995, 1996 ---- "
"  ---- Extended File Dialogs Version 2.1 ---- "


InterfaceComponent subclass: #ICFontSelection
instanceVariableNames: '
   value
'
classVariableNames: ''
poolDictionaries: '' !


!ICFontSelection class methods!


description
	^ 'FontSelection'
!"end description"


iconFileName
	^ 'iccomp.ico'
!"end iconFileName"


!"End of ICFontSelection class methods block"


!ICFontSelection methods!


createItemsFor: form
	|cItem temp controller|
	controller := self.
	cItem := controller add: #fontFaceText
		class:			FormStatic
		rect:				{39 77 525 77}
		options:			nil
		form:				form
		text:				'Face'.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10}}.
	cItem := controller add: #fontSizeText
		class:			FormStatic
		rect:				{580 77 174 75}
		options:			nil
		form:				form
		text:				'Size'.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10}}.
	cItem := controller add: #previewText
		class:			FormStatic
		rect:				{58 405 680 177}
		options:			nil
		form:				form
		text:				'RBRi grt ELO, FCO, AGA'.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10}}.
	cItem := controller add: #fontToBo
		class:			FormTopicBox
		rect:				{19 21 757 599}
		options:			{#Draw3D}
		form:				form
		text:				' Preview Font '.
	cItem setFormatTo: {#Left #Top}.
	cItem := controller add: #fontFaceDroDoLi
		class:			FormDropList
		rect:				{39 154 522 77}
		options:			{#Return #Tab #Backtab}
		form:				form.
	(cItem formItem) setLineCountTo: 0.
	cItem := controller add: #fontSizeDroDoLi
		class:			FormDropList
		rect:				{580 154 174 77}
		options:			{#Return #Tab #Backtab}
		form:				form.
	(cItem formItem) setLineCountTo: 0.
	cItem := controller add: #previewToBo
		class:			FormTopicBox
		rect:				{39 367 719 235}
		options:			{#Draw3D}
		form:				form
		text:				''.
	cItem setFormatTo: {#Left #Top}.
	cItem := controller add: #fontAttributesCheckLi
		class:			FormCheckList
		rect:				{39 251 719 116}
		options:			{#NoBorder #Return #Tab #Backtab}
		form:				form.
	cItem setInitialValueTo: {#Italic #Bold #Underscore #StrikeOut}.
	cItem setInitialSelectionTo: {}.
	cItem setFormatTo: {#Left #Bottom {#PointSize 10} #WindowStaticTextColor}.

	temp := {#fontFaceDroDoLi #fontSizeDroDoLi #fontAttributesCheckLi}.
	form addFormItemGroups: temp in: controller.

	controller initializeBindings.
	controller finishInit.
!"end createItemsFor:"


getValue
   ^ value.
!"end getValue"


fontAttributesChanged
   self fontPreview.
!"end fontAttributesChanged"


fontFaceChanged
| tempFont tempSizes tempSize |
   tempFont := self at: #fontFaceDroDoLi.
   tempFont isNil ifTrue: [ ^ self ].

"  ---- nach Mglichkeit die alte Gre beibehalten ---- "
   tempSize := (cItemDict at: #fontSizeDroDoLi) getValue.
   tempSizes := (OutputDevice getNamed: #Screen) availableSizesFor: tempFont.
   (cItemDict at: #fontSizeDroDoLi) put: tempSizes sort.
   (tempSizes includes: tempSize)
   ifTrue:
   [  (cItemDict at: #fontSizeDroDoLi) display: tempSize.
   ]
   ifFalse:
   [  (cItemDict at: #fontSizeDroDoLi) setSelectionTo: 1.
   ].
!"end fontFaceChanged"


fontPreview
|tempArray|
   tempArray := Array new: 2.
   tempArray at: 1 put: (Array with: #FontFace with: (self at: #fontFaceDroDoLi)).
   tempArray at: 2 put: (Array with: #PointSize with: (self at: #fontSizeDroDoLi)).
   tempArray := tempArray concat: (self at: #fontAttributesCheckLi).
   value := Font newArray: tempArray.
   tempArray add: #VCenter.
   (cItemDict at: #previewText) put: ((cItemDict at: #previewText) getValue asTextOptions: tempArray).
	self triggerEvent: #changed: with: value.
!"end fontPreview"


fontSizeChanged
   (self at: #fontSizeDroDoLi) ~~ nil
   ifTrue:
   [  self fontPreview.
   ].
!"end fontSizeChanged"


initializeBindings
|temp|
	temp := self actionDict.
	temp at: #fontFaceDroDoLi put: #fontFaceChanged.
	temp at: #fontSizeDroDoLi put: #fontSizeChanged.
	temp at: #fontAttributesCheckLi put: #fontAttributesChanged.
	temp at: #settingsOKButt put: #settingsOk.
	temp at: #settingsCancelButt put: #settingsCancel.
!"end initializeBindings"


open
   super open.
   self put: 'RBRi grt ELO, FCO, AGA' asText.
!"end open"


put: aFontOrText
   aFontOrText isText
   ifTrue:
   [  (cItemDict at: #previewText) put: aFontOrText.
      aFontOrText font == nil
      ifTrue:
      [  aFontOrText setFontFace: #Normal.
         aFontOrText setFontSize: 10.
      ].
      ^ self putValue: aFontOrText font.
   ].
   self putValue: aFontOrText.
!"end put:"


putLabel: aString
   (cItemDict at: #previewText) put: aString.
   self fontPreview.
!"end putLabel:"


putValue: aFont
|tempDevice|
   tempDevice := OutputDevice getNamed: #Screen.
   (cItemDict at: #fontFaceDroDoLi) put: tempDevice availableFontFaces sort.
   (cItemDict at: #fontFaceDroDoLi) display: aFont face.
   (cItemDict at: #fontSizeDroDoLi) display: aFont size.
   (cItemDict at: #fontAttributesCheckLi) display: aFont attributesAsArray.
!"end putValue:"


!"End of ICFontSelection methods block"
