"  ---- Ronald Brill 1995, 1996 ---- "
"  ---- Extended File Dialogs Version 2.1 ---- "


FileDialogController SecondaryFile!


!FileDialogController class methods!


!"End of FileDialogController class methods block"


!FileDialogController methods!


createItems
	|cItem temp form controller|
	controller := self.
	form := DialogBox
		name:				#FileSelector
		title:			#RBRi
		rect:				{11 75 2371 1422}
		controller:		controller.
	form setGridTo: false.
	form setSnapTo: true.
	form setXGridResTo: 19.
	form setYGridResTo: 19.
	temp := IdentityDictionary newEntries: 1.
	temp at: #vFileName put: (#openFile).
	form setReturnActionsTo: temp.
	form setInitialFocusTo: #vFileName.
	form setBackgroundSourceTo: #DialogBackgroundColor.
	cItem := controller add: #vSetupMenu
		class:			FormSubMenu
		position:		0
		options:			nil
		form:				form
		text:				'previewMenu'.
	cItem setInitialLabelsTo: {'&Setup...' '-' 'About'}.
	cItem setInitialValueTo: {#mSetup nil #mShowAbout}.
	cItem := controller add: #cFilenameLabel
		class:			FormStatic
		rect:				{38 19 791 79}
		options:			{#Mnemonic}
		form:				form
		text:				'File &Name:'.
	cItem setFormatTo: {#Left #Bottom {#PointSize 10}}.
	cItem := controller add: #TypeofFile
		class:			FormStatic
		rect:				{38 206 566 79}
		options:			{#Mnemonic}
		form:				form
		text:				'&Type of File:'.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10}}.
	cItem := controller add: #cDriveLabel
		class:			FormStatic
		rect:				{638 206 191 71}
		options:			{#Mnemonic}
		form:				form
		text:				'Dri&ves:'.
	cItem setFormatTo: {#Left #Bottom {#PointSize 10}}.
	cItem := controller add: #vFileName
		class:			FormString
		rect:				{49 105 773 60}
		options:			{#Return #Insert #Tab #Backtab}
		form:				form.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10}}.
	cItem := controller add: #vFileTypes
		class:			FormDropList
		rect:				{38 281 566 79}
		options:			{#Return #Tab #Backtab}
		form:				form.
	(cItem formItem) setLineCountTo: 0.
	cItem := controller add: #vDriveList
		class:			FormDropList
		rect:				{638 281 191 79}
		options:			{#Return #Tab #Backtab}
		form:				form.
	(cItem formItem) setLineCountTo: 0.
	cItem := controller add: #vFileList
		class:			FormList
		rect:				{38 394 566 776}
		options:			{#HScroll #Return #Tab #Backtab}
		form:				form.
	cItem := controller add: #vDirList
		class:			FormTreeView
		rect:				{641 473 656 694}
		options:			{#HScroll #'Reduced Tree' #'Show Icon' #'Double Click' #Return #Tab #Backtab}
		form:				form.
	cItem setSplitPositionTo: nil.
	cItem formItem indents: {1}.
	cItem formItem iconOffset: 4.
	cItem formItem widthCompressFactor: 2.
	cItem expandedIconSource: #FSelFolOpen.
	cItem expandedIconType: #SystemBitmap.
	cItem collapsedIconSource: #FSelFolClose.
	cItem collapsedIconType: #SystemBitmap.
	cItem := controller add: #vOk
		class:			FormButton
		rect:				{38 1200 191 98}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'&Open'.
	cItem := controller add: #vCancel
		class:			FormButton
		rect:				{244 1200 210 98}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'&Cancel'.
	cItem setActionDescriptionTo: #Close.
	cItem := controller add: #vHelp
		class:			FormButton
		rect:				{469 1200 210 98}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'&Help'.
	cItem := controller add: #vCurrentDir
		class:			FormStatic
		rect:				{638 394 656 79}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10}}.
	cItem := controller add: #vRememberToBo
		class:			FormTopicBox
		rect:				{1332 19 979 1279}
		options:			{#Draw3D}
		form:				form
		text:				'Remember'.
	cItem setFormatTo: {#Left #Top}.
	cItem := controller add: #vRememberLiBo
		class:			FormList
		rect:				{1368 75 904 1204}
		options:			{#HScroll #Return #Tab #Backtab}
		form:				form.
	cItem := controller add: #vRememberMenu
		class:			FormSubMenu
		position:		0
		options:			nil
		form:				form
		text:				'rememberMenu'.
	cItem setInitialLabelsTo: {'&Append current directory' 'De&lete selected directory' '-' '&Mark selected as default' '&Remove default' '-' '&Sort list' '-' 'Show full path'}.
	cItem setInitialValueTo: {#mRememberAdd #mRememberDelete nil #mSetDefault #mDeleteDefault nil #mRememberSort nil #mToggleFullPath}.
	cItem := controller add: #vPreview
		class:			FormCheckBox
		rect:				{1032 1200 266 98}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'&Preview'.
	cItem := controller add: #vPreviewMLString
		class:			FormMlEntryField
		rect:				{1369 79 900 881}
		options:			{#HScroll}
		form:				form.
	cItem setFormatTo: {#Top #Left {#FontFace #'System VIO'} {#PointSize 5}}.
	cItem := controller add: #vAttribChList
		class:			FormCheckList
		rect:				{1369 963 604 146}
		options:			{#NoBorder #NoEdit #NoSelect #Return #Tab #Backtab}
		form:				form.
	cItem setInitialValueTo: {#Readonly #Hidden #System #Archiv}.
	cItem setInitialSelectionTo: {}.
	cItem := controller add: #writeText
		class:			FormStatic
		rect:				{1369 1107 210 60}
		options:			nil
		form:				form
		text:				'Write:'.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10} #DarkBlue}.
	cItem := controller add: #accessText
		class:			FormStatic
		rect:				{1369 1163 210 60}
		options:			nil
		form:				form
		text:				'Access:'.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10} #DarkBlue}.
	cItem := controller add: #creationText
		class:			FormStatic
		rect:				{1369 1219 210 60}
		options:			nil
		form:				form
		text:				'Creation:'.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10} #DarkBlue}.
	cItem := controller add: #writeEntryDate
		class:			FormStatic
		rect:				{1613 1107 323 60}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.
	cItem := controller add: #accessEntryDate
		class:			FormStatic
		rect:				{1613 1163 323 60}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.
	cItem := controller add: #creationEntryDate
		class:			FormStatic
		rect:				{1613 1219 323 56}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.
	cItem := controller add: #writeEntryTime
		class:			FormStatic
		rect:				{1950 1107 323 56}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.
	cItem := controller add: #accessEntryTime
		class:			FormStatic
		rect:				{1950 1163 323 56}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.
	cItem := controller add: #creationEntryTime
		class:			FormStatic
		rect:				{1950 1223 323 56}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.


	temp := AcceleratorTable new.
	temp at: #Escape put: #close.
	temp at: #Alto put: #openFile.
	temp at: #Altc put: #close.
	temp at: #Alti put: #mExpandFileName.
	temp at: #Altn put: #setFocusName.
	temp at: #Altd put: #setFocusDir.
	temp at: #Altt put: #setFocusTypes.
	temp at: #Altv put: #setFocusDrives.
	temp at: #Ctrli put: #mExpandFileName.
	temp at: #Alta put: #mRememberAdd.
	temp at: #AltA put: #mRememberAdd.
	temp at: #Altl put: #mRememberDelete.
	temp at: #AltL put: #mRememberDelete.
	temp at: #Alts put: #mRememberSort.
	temp at: #AltS put: #mRememberSort.
	temp at: #Altp put: #mPreview.
	temp at: #AltP put: #mPreview.
	form setAcceleratorTableTo: temp.

	temp := { #vFileName #vFileList #vDirList #vFileTypes #vDriveList {#vOk #vCancel #vHelp}}.
	form setFormItemGroupsTo: temp.

	temp := controller actionDict.
	temp at: #vDriveList put: #mDriveSelected.
	temp at: #vFileList put: #mFileSelected.
	temp at: #vHelp put: #mHelp.
	temp at: #vFileTypes put: #mFileTypeSelected.
	temp at: #vOk put: #openFile.
	temp at: #vFileName put: #mFileNameChanged.
	temp at: #vRememberMenu put: #mRememberMenu.
	temp at: #vSetupMenu put: #mSetupMenu.
	temp at: #vPreview put: #mTogglePreview.

	temp := controller editDict.
	temp at: #vFileList put: #openFileDblClicked.
	temp at: #vDirList put: #mDirectorySelected.
	temp at: #vRememberLiBo put: #mRememberSelected.
	self on: #wmCharPressed: for: vDriveList action: (Action receiver: self
			send: #selectDriveChar:).
    self on: #changed: for: vDriveList
             action: (Action receiver: self send: #preview:).
    self on: #changed: for: vDirList
             action: (Action receiver: self send: #preview:).

   (cItemDict at: #vRememberLiBo) setPopupTo: (cItemDict at: #vRememberMenu).
   form setPopupTo: (cItemDict at: #vSetupMenu).

	controller setMainFormTo: #FileSelector.
	controller finishInit.
!"end createItems"


!"End of FileDialogController methods block"
