"  ---- Ronald Brill 1995, 1996 ---- "
"  ---- Extended File Dialogs Version 2.1 ---- "


Object subclass: #FileDialogSetup

instanceVariableNames: '
   defaultDirectory
   directoryList
   directoryListExtend
   directoryListLabels
   fileList
   fileLoadMenu
   fileReloadMenu
   filterLabels
   filterValues
   filterMapping
   fullPath
   previewFont
   setup
   reorderFileList

'

classVariableNames: '
   theOneInstance
'

poolDictionaries: ''
!


!FileDialogSetup class methods !


fileName
   ^ 'enf_loc.ini'
!"end fileName"


initialize
   self load.
!"end initialize"


load
   theOneInstance ~~ nil
   ifTrue:
   [  ^ theOneInstance.
   ].
   theOneInstance := super new.
   ('ExtendedFileDialog: restore settings from' ++ (Setup locate: self fileName)) out.
   theOneInstance varAt: #setup put: (Setup file: self fileName part: #Remember).
   theOneInstance initialize.
   ^ theOneInstance.
!"end load"


!"End of class methods block"


!FileDialogSetup methods !


addFile: aFileName
| temp length labels |
   fileList == nil ifTrue: [ ^ self ].

   (WPENFIN controllerItemDict at: #menuDesktop) enableAt: 4.
   (WPENFIN controllerItemDict at: #menuDesktop) enableAt: 5.
   temp := fileList indexOf: aFileName.
   reorderFileList
   ifTrue:
   [  temp > 0 ifTrue: [ fileList removeAt: temp. ].
      fileList size > 9 ifTrue: [ fileList removeAt: 10. ].
      fileList := (Array with: aFileName) concat: fileList.
   ]
   ifFalse:
   [  temp > 0 ifTrue: [ ^ self ].
      fileList size > 10 ifTrue: [ fileList removeAt: 1. ].
      fileList := fileList add: aFileName.
   ].
   labels := fileList collect:   [  :each|
                                    length := each size + 4 max: 12.
                                    [  each := ((FileNameString newString: each asString) abbreviate: length) asText.
                                       length := length -1.
                                    ]
                                    doUntil:
                                    [  each getTextExtent x < 1000 ].
                                       each := each asString.
                                    ].

   fileLoadMenu putValues: fileList.
   fileReloadMenu putValues: fileList.
   fileLoadMenu putLabels: labels.
   fileReloadMenu putLabels: labels.
!"end addFile:"


createDirectoryListLabels
| pos length |
   directoryListLabels := directoryList
      collect:
      [  :each|
         fullPath
         ifFalse:
         [  length := each size + 4 max: 12.
            [  each := ((FileNameString newString: each asString) abbreviate: length) asText.
               length := length -1.
            ]
            doUntil:
            [  each getTextExtent x < directoryListExtend ].
         ].
         each asText.
      ].
   pos := directoryList indexOf: defaultDirectory.
   pos > 0
   ifTrue:
   [  directoryListLabels at: pos put: ((directoryListLabels at: pos) asTextOptions: {#Bold}).
   ].
!"end createDirectoryListLabels"


createMenus
| desktopMenu stream result |
   Application ~~ WPENFIN ifTrue: [ ^ self ].

   desktopMenu := (WPENFIN controllerItemDict at: #menuDesktop).
"  ---- load menu ---- "
   fileLoadMenu
         := WPENFIN  add:        #rbrisLoadMenu
                     class:      FormSubMenu
                     position:   0
                     options:    nil
                     form:       WPENFIN mainForm
                     text:       '~Load file'.
   fileLoadMenu setInitialValueTo: { #'No file'}.
   fileLoadMenu initialize.
   fileLoadMenu formItem open.
   desktopMenu insertSubMenu: fileLoadMenu at: 4.
   desktopMenu disableAt: 4.

   WPENFIN actionDict at: #rbrisLoadMenu put:
         [  stream := FileStream file: (WPENFIN controllerItemDict at: #rbrisLoadMenu) getValue.
            result := stream asClassMethodsInit: false.
            result isClass ifFalse: [ ^ self. ].
            ('load:' ++ stream fileName) out.
            (result class methodDictionary includesKey: #initialize)
            ifTrue:
            [  result initialize.
               result class methodDictionary removeAt: #initialize.
            ].
            self addFile: stream fileName.
         ].


"  ---- reload menu ---- "
   fileReloadMenu
         := WPENFIN  add:        #rbrisReloadMenu
                     class:      FormSubMenu
                     position:   0
                     options:    nil
                     form:       WPENFIN mainForm
                     text:       '~Reload file'.
   fileReloadMenu setInitialValueTo: { #'No file'}.
   fileReloadMenu initialize.
   fileReloadMenu formItem open.
   desktopMenu insertSubMenu: fileReloadMenu at: 5.
   desktopMenu disableAt: 5.

   WPENFIN actionDict at: #rbrisReloadMenu put:
         [  stream := FileStream file: (WPENFIN controllerItemDict at: #rbrisReloadMenu) getValue.
            ('reload:' ++ stream fileName) out.
            stream reloadClass.
            self addFile: stream fileName.
         ].
   fileList := Array new.
!"end createMenus"


defaultDirectory
   ^ defaultDirectory.
!"end defaultDirectory"


defaultDirectory: aString
   defaultDirectory := aString deepCopy.
   setup at: #DefaultDir put: defaultDirectory.
   self createDirectoryListLabels.
!"end defaultDirectory:"


directoryList
   ^ directoryList.
!"end directoryList"


directoryList: aArray
   directoryList := aArray deepCopy.
   setup at: #Dirs put: directoryList.
!"end directoryList:"


directoryListExtend: extend
   directoryListExtend := extend - 64.
!"end directoryListExtend:"


directoryListLabels
   directoryListLabels == nil
   ifTrue:
   [  self createDirectoryListLabels.
   ].
   ^ directoryListLabels.
!"end directoryListLabels"


fileList
   ^ fileList.
!"end fileList"


filterLabels
   ^ filterLabels.
!"end filterLabels"


filterValues
   ^ filterValues.
!"end filterValues"


filterLabels: aArray
   filterLabels := aArray deepCopy.
   setup at: #FilterLabels put: filterLabels.
!"end filterLabels:"

filterValues: aArray
   filterValues := aArray deepCopy.
   setup at: #FilterValues put: filterValues.
!"end filterValues:"


filterMapping
   ^ filterMapping.
!"end filterMapping"


filterMapping: aString
   filterMapping := aString deepCopy.
   setup at: #FilterMapping put: filterMapping.
!"end filterMapping:"


fullPath
   ^ fullPath.
!"end fullPath"


fullPath: aBoolean
   fullPath := aBoolean.
   self createDirectoryListLabels.
!"end fullPath:"


initialize
   defaultDirectory := (setup values at: #DefaultDir) deepCopy.
   defaultDirectory isString
   ifFalse:
   [  defaultDirectory := String new.
   ].
   defaultDirectory isEmpty
   ifFalse:
   [  LoadClassDirectory := defaultDirectory deepCopy.
   ].

   directoryList := (setup values at: #Dirs) deepCopy.
   directoryList isArray
   ifFalse:
   [  directoryList := Array new.
   ].

   fullPath := false.

   " ---- Filter ---- "
   filterLabels := (setup values at: #FilterLabels) deepCopy.
   filterLabels isArray
   ifFalse:
   [  filterLabels := {#'<All Files>' #'Class Files (*.cls)'}.
   ].
   filterValues := (setup values at: #FilterValues) deepCopy.
   filterValues isArray
   ifFalse:
   [  filterValues := {#'*.*' #'*.cls'}.
   ].
   filterMapping := (setup values at: #FilterMapping) deepCopy.
   filterMapping isString
   ifFalse:
   [  filterMapping := '*.cls'.
   ].

   " ---- PreviewFont ---- "
   previewFont := setup values at: #PreviewFont.
   previewFont isArray
   ifTrue:
   [  previewFont := {#Top #Left} deepCopy concat: previewFont.
   ]
   ifFalse:
   [  previewFont := {#Top #Left {#FontFace #'System VIO'} {#PointSize 5}}.
   ].

   " ---- Options ---- "
   reorderFileList := setup values at: #ReorderFileList.
   reorderFileList isBoolean
   ifFalse:
   [  reorderFileList := true.
   ].
!"end initialize"


permanentDefaultDirectory: aString
   self defaultDirectory: aString;
        save.
!"end permanentDefaultDirectory:"


permanentDirectoryList: aArray
   self directoryList: aArray;
        save.
!"end permanentDirectoryList:"


permanentDirectoryListAdd: aDirectory
   (directoryList includes: aDirectory) ifTrue: [ ^ self.].
   self permanentDirectoryList: (directoryList add: aDirectory).
   self createDirectoryListLabels.
!"end permanentDirectoryListAdd:"


permanentDirectoryMoveFrom: fromIndex to: toIndex
| tempValue |
   tempValue := directoryList at: fromIndex.
   fromIndex > toIndex
   ifTrue:
   [  directoryList removeAt: fromIndex.
      directoryList at: toIndex insert: tempValue.
   ]
   ifFalse:
   [  directoryList at: toIndex insert: tempValue.
      directoryList removeAt: fromIndex.
   ].
   self save.
   self createDirectoryListLabels.
!"end permanentDirectoryMoveFrom:to:"


permanentDirectoryListRemoveAt: aSmallInt
   (directoryList at: aSmallInt) = defaultDirectory
   ifTrue:
   [  self defaultDirectory: ''.
   ].
   self permanentDirectoryList: (directoryList removeAt: aSmallInt).
   self createDirectoryListLabels.
!"end permanentDirectoryListRemoveAt:"


permanentSortDirectoryList
   self permanentDirectoryList: directoryList sort.
   self createDirectoryListLabels.
!"end permanentSortDirectoryList"


previewFont
   ^ previewFont.
!"end previewFont"


previewFont: aArray
   previewFont := aArray.
   setup at: #PreviewFont put: previewFont.
!"end previewFont:"


save
   ^ setup save.
!"end save"

reorderFileList
   ^ reorderFileList.
!"end reorderFileList"


reorderFileList: aBoolean
   reorderFileList := aBoolean.
   setup at: #ReorderFileList put: reorderFileList.
!"end reorderFileList"


!"End of method block"
