"  ---- Ronald Brill 1995, 1996 ---- "
"  ---- Extended File Dialogs Version 2.1 ---- "


FileDialogController SecondaryFile!


!FileDialogController class methods!


!"End of FileDialogController class methods block"


!FileDialogController methods!


doMoveSelectionFor: aSymbol from: fromIndex to: toIndex
"  ---- Danke ELO ---- "
   aSymbol = #vRememberLiBo
   ifTrue:
   [  " ---- ENFIN Fehler vermeiden ---- "
      fromIndex > (cItemDict at: #vRememberLiBo) getList size
      ifTrue:
      [  fromIndex := (cItemDict at: #vRememberLiBo) getList size.
      ].
      FileDialogSetup load permanentDirectoryMoveFrom: fromIndex to: toIndex.
      self refreshRememberList.
   ].
!"end doMoveSelectionFor:from:to:"


initFileTypeList
| setup |
   setup := FileDialogSetup load.
   vFileTypes putValues: setup filterValues;
         putLabels: setup filterLabels.
   wildcard asString = '*.cls'
   ifTrue:
   [  wildcard := setup filterMapping asString
   ].
   vFileTypes setSelectionTo: wildcard.
!"end initFileTypeList"


mDeleteDefault
   FileDialogSetup load permanentDefaultDirectory: String new.
   self refreshRememberList.
!"end mDeleteDefault"


mFileSelected
    vFileName put: vFileList getValue.
    self preview: nil.
!"end mFileSelected"


mPreview
   (cItemDict at: #vPreview) put: (cItemDict at: #vPreview) getValue not.
!"end mPreview"


mRememberAdd
| currentDir |
   currentDir := (FileNameString newDriveName: drive dirName: directory baseName: nil) asString.
   FileDialogSetup load permanentDirectoryListAdd: currentDir.
   self refreshRememberList.
!"end mRememberAdd"


mRememberDelete
| selection |
   selection := (cItemDict at: #vRememberLiBo) getSelection.
   selection == 0 ifTrue: [ ^ self ].
   FileDialogSetup load permanentDirectoryListRemoveAt: selection.
   self refreshRememberList.
!"end mRememberDelete"


mRememberMenu
   (cItemDict at: #vRememberMenu) getValue sendTo: self args: nil.
!"end mRememberMenu"


mRememberSelected
| value |
   value := (cItemDict at: #vRememberLiBo) getValue deepCopy.
   value == nil ifTrue: [ ^ self ].
   value := FileNameString newString: (value add: DirSeparator).

   self walkTo: value.
!"end mRememberSelected"


mRememberSort
   FileDialogSetup load permanentSortDirectoryList.
   self refreshRememberList.
!"end mRememberSort"


mSetDefault
| value |
   value := (cItemDict at: #vRememberLiBo) getValue deepCopy.
   value == nil ifTrue: [ ^ self ].
   FileDialogSetup load permanentDefaultDirectory: value.
   self refreshRememberList.
!"end mSetDefault"


mSetupMenu
   (cItemDict at: #vSetupMenu) getValue sendTo: self args: nil.
!"end mSetupMenu"


mSetup
   ExtendedFileDialogSetup isNil
   ifTrue:
   [  ExtendedFileDialogSetupController createInstanceName: #ExtendedFileDialogSetup.
   ].
   ExtendedFileDialogSetup open.
   ExtendedFileDialogSetup mainForm setParentTo: self mainForm.
!"end mSettings"


mShowAbout
| tempText |
   tempText := 'Extended File Dialogs' + CrLf + 'Version 2.0'
               + CrLf + CrLf + 'RBRi 1995'.
   ModalMessageBox   title:      'About'
                     text:       tempText
                     icon:       #Info
                     buttons:    {#OK}
                     action:     nil
                     controller: self.
!"end mShowAbout"


mToggleFullPath
| item setup |
   item := cItemDict at: #vRememberMenu.
   setup := FileDialogSetup load.
   setup fullPath: setup fullPath not.
   setup fullPath
   ifTrue:
   [  item setInitialLabelsTo: (item getLabels at: 9 put: 'Show reduced path').
   ]
   ifFalse:
   [  item setInitialLabelsTo: (item getLabels at: 9 put: 'Show full path').
   ].
   item initialize.
   self refreshRememberList.
!"end mToggleFullPath"


mTogglePreview
| dirList |
    dirList := #(vPreviewMLString vAttribChList creationText writeText accessText
                 writeEntryDate accessEntryDate creationEntryDate
                 writeEntryTime accessEntryTime creationEntryTime
                ).
    (cItemDict at: #vPreview) getValue
    ifTrue:
    [   (cItemDict at: #vRememberLiBo) hide.
        dirList do: [ :each| (cItemDict at: each) show. ].
    ]
    ifFalse:
    [   dirList do: [ :each| (cItemDict at: each) hide. ].
        (cItemDict at: #vRememberLiBo) show.
    ].
    self preview: nil.
!"end mTogglePreview"


openInitialization
| setup dir |
"  ---- changed by RBRi ---- "
   setup := FileDialogSetup load.
   originalDirectory := FileStream defaultDirectory.
   originalDrive := FileStream defaultDrive.
   drive == nil
   ifTrue:
   [  dir := setup defaultDirectory.
      dir isBlank
      ifTrue:
      [  drive := originalDrive.
         directory := originalDirectory.
      ]
      ifFalse:
      [  dir last == DirSeparator ifFalse: [ dir := dir + DirSeparator. ].
         dir := FileNameString newString: dir.
         drive := dir driveName.
         directory := dir dirName.
         directory first == DirSeparator ifTrue: [ directory := directory cdr. ].
      ].
   ].
"  ---- end RBRi ---- "
   self ifUnderEditorControl: [ ^ self.].
   self changeDriveTo: drive.
   self changeDirectoryTo: DirSeparator asString + directory.
   FileNameString supportsDrives
   ifFalse:
   [  vDriveList hide.
      (cItemDict at: #cDriveLabel) hide.
   ]
   ifTrue:
   [  self init: #DriveList.
   ].
   self init: #FileTypeList;
         init: #DirName;
         init: #DirList;
         init: #FileList.
   vOk highlightOn.
   fileName == nil
   ifTrue:
   [  fileName := wildcard.
   ].
   vFileName put: fileName.
   help == nil
   ifTrue:
   [  vHelp hide.
   ]
   ifFalse:
   [  vHelp show.
   ].

"  ---- added by RBRi ---- "
   setup directoryListExtend: (cItemDict at: #vRememberLiBo) formItem rect width.
   self mTogglePreview.
   self refreshRememberList.
   (cItemDict at: #vPreviewMLString) setFormatTo: setup previewFont.
"  ---- end RBRi ---- "
!"end openInitialization"


preview: fileName
| file count text flag |
    (cItemDict at: #vPreview) == nil ifTrue: [ ^ self. ].

    (cItemDict at: #vPreview) getValue
    ifTrue:
    [   file := self fileOK.
        "  ---- result mu zurckgesetzt werden, damit der 'Cancel'-Button funktioniert ---- "
        result := nil.
        "  ---- das System hat nichts gemerkt, weiter gehts ---- "
        file isString
        ifTrue:
        [   file := FileStream file: file onError: [ file := nil. ].
        ].
        (file isKindOf: Message)
        | file isNil
        ifTrue:
        [   (cItemDict at: #vPreviewMLString) put: String new.
            (cItemDict at: #vAttribChList) setSelectionTo: Array new.
            #(writeEntry accessEntry creationEntry)
            do:
            [   :each |
               (cItemDict at: each + 'Date') put: String new.
               (cItemDict at: each + 'Time') put: String new.
            ].
            ^ self.
        ].
        count := 0.
        text := String new.
        [ file atEnd not & (count < 24) ]
        whileTrue:
        [   count := count + 1.
            text := text + file nextString + CrLf.
        ].
        (cItemDict at: #vPreviewMLString) put: text.

"       ---- Dateiattribute ---- "
        file := file fileName.
        flag := File privateAttributesOf: file.

        flag := #(fattrReadonly fattrHidden fattrSystem fattrArchiv)
                select:
                [   :eachFlag |
                    (flag bitAnd: (FileAccessConstants at: eachFlag)) == (FileAccessConstants at: eachFlag)
                ].
        flag := flag collect: [ :each |  #(fattrReadonly fattrHidden fattrSystem fattrArchiv) indexOf: each ].
        (cItemDict at: #vAttribChList) setSelectionTo: flag.

        #(modify access create)
        with:
        #(writeEntry accessEntry creationEntry)
        do:
        [   :eachFlag :eachEntry |
            flag := File privateAccessTimeOf: file type: eachFlag.
            (cItemDict at: eachEntry + 'Date') put: (flag at: 1) asDate asFullISOString.
            (cItemDict at: eachEntry + 'Time') put: (flag at: 2) asTime asISOString.
        ].
    ].
!"end preview:"


refreshRememberList
| item setup |
   item := cItemDict at: #vRememberLiBo.
   setup := FileDialogSetup load.
   item putLabels: setup directoryListLabels.
   item putValues: setup directoryList.
!"end showInRememberList:"


setupChanged
| setup |
   setup := FileDialogSetup load.
   (cItemDict at: #vPreviewMLString) setFormatTo: setup previewFont.
   wildcard := setup filterMapping asString.
   self init: #FileTypeList.
   self mFileTypeSelected.
!"end setupChanged"


walkTo: aFileNameString
    self changeDriveTo: aFileNameString driveName.
    self changeDirectoryTo: aFileNameString dirName.
    FileNameString supportsDrives
    ifFalse:
    [   vDriveList hide.
        (cItemDict at: #cDriveLabel) hide.
    ]
    ifTrue:
    [   self init: #DriveList.
    ].
    self init: #DirName;
         init: #DirList;
         init: #FileList.
!"end walkTo:"


!"End of FileDialogController methods block"
