"  ---- Ronald Brill 1995, 1996 ---- "
"  ---- Extended File Dialogs Version 2.1 ---- "


FileDialogController SecondaryFile!


!FileDialogController class methods!


!"End of FileDialogController class methods block"


!FileDialogController methods!


createItems
	|cItem temp form controller|
	controller := self.
	form := DialogBox
		name:				#FileSelector
		title:			#RBRi
		rect:				{14 174 2769 1416}
		controller:		controller.
	form setGridTo: false.
	form setSnapTo: true.
	form setXGridResTo: 19.
	form setYGridResTo: 19.
	temp := IdentityDictionary newEntries: 1.
	temp at: #vFileName put: (#openFile).
	form setReturnActionsTo: temp.
	form setInitialFocusTo: #vFileName.
	form setBackgroundSourceTo: #DialogBackgroundColor.
	cItem := controller add: #vSetupMenu
		class:			FormSubMenu
		position:		0
		options:			nil
		form:				form
		text:				'previewMenu'.
	cItem setInitialLabelsTo: {'~Setup...' '-' 'About'}.
	cItem setInitialValueTo: {#mSetup nil #mShowAbout}.
	cItem := controller add: #cFilenameLabel
		class:			FormStatic
		rect:				{39 19 661 77}
		options:			{#Mnemonic}
		form:				form
		text:				'File ~Name:'.
	cItem setFormatTo: {#Left #Bottom {#PointSize 10}}.
	cItem := controller add: #TypeofFile
		class:			FormStatic
		rect:				{39 213 661 72}
		options:			{#Mnemonic}
		form:				form
		text:				'~Type of File:'.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10}}.
	cItem := controller add: #cDriveLabel
		class:			FormStatic
		rect:				{735 213 196 72}
		options:			{#Mnemonic}
		form:				form
		text:				'Dri~ve:'.
	cItem setFormatTo: {#Left #Bottom {#PointSize 10}}.
	cItem := controller add: #vFileName
		class:			FormString
		rect:				{47 108 898 64}
		options:			{#Return #Insert #Tab #Backtab}
		form:				form.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10}}.
	cItem := controller add: #vFileTypes
		class:			FormDropList
		rect:				{39 290 661 80}
		options:			{#Return #Tab #Backtab}
		form:				form.
	(cItem formItem) setLineCountTo: 0.
	cItem := controller add: #vDriveList
		class:			FormDropList
		rect:				{735 290 216 80}
		options:			{#Return #Tab #Backtab}
		form:				form.
	(cItem formItem) setLineCountTo: 0.
	cItem := controller add: #vFileList
		class:			FormList
		rect:				{39 406 661 776}
		options:			{#HScroll #Return #Tab #Backtab}
		form:				form.
	cItem := controller add: #vDirList
		class:			FormTreeView
		rect:				{735 486 796 696}
		options:			{#HScroll #'Reduced Tree' #'Show Icon' #'Double Click' #Return #Tab #Backtab}
		form:				form.
	cItem setSplitPositionTo: nil.
	cItem formItem indents: {1}.
	cItem formItem iconOffset: 4.
	cItem formItem widthCompressFactor: 2.
	cItem expandedIconSource: #FSelFolOpen.
	cItem expandedIconType: #SystemBitmap.
	cItem collapsedIconSource: #FSelFolClose.
	cItem collapsedIconType: #SystemBitmap.
	cItem := controller add: #vOk
		class:			FormButton
		rect:				{39 1218 196 80}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'~Open'.
	cItem := controller add: #vCancel
		class:			FormButton
		rect:				{271 1218 196 80}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'~Cancel'.
	cItem setActionDescriptionTo: #Close.
	cItem := controller add: #vHelp
		class:			FormButton
		rect:				{503 1218 196 80}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'~Help'.
	cItem := controller add: #vCurrentDir
		class:			FormStatic
		rect:				{735 406 796 77}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10}}.
	cItem := controller add: #vRememberToBo
		class:			FormTopicBox
		rect:				{1567 19 1144 1278}
		options:			{#Draw3D}
		form:				form
		text:				'Remember'.
	cItem setFormatTo: {#Left #Top}.
	cItem := controller add: #vRememberLiBo
		class:			FormList
		rect:				{1587 75 1103 1204}
		options:			{#HScroll #Return #Tab #Backtab}
		form:				form.
	cItem := controller add: #vRememberMenu
		class:			FormSubMenu
		position:		0
		options:			nil
		form:				form
		text:				'rememberMenu'.
	cItem setInitialLabelsTo: {'~Append current directory' 'De~lete selected directory' '-' '~Mark selected as default' '~Remove default' '-' '~Sort list' '-' 'Show full path'}.
	cItem setInitialValueTo: {#mRememberAdd #mRememberDelete nil #mSetDefault #mDeleteDefault nil #mRememberSort nil #mToggleFullPath}.
	cItem := controller add: #vPreview
		class:			FormCheckBox
		rect:				{1277 1218 252 80}
		options:			{#Return #Tab #Up #Down #Backtab #Left #Right}
		form:				form
		text:				'~Preview'.
	cItem := controller add: #vPreviewMLString
		class:			FormMlEntryField
		rect:				{1587 80 1106 936}
		options:			{#HScroll}
		form:				form.
	cItem setFormatTo: {#Top #Left {#FontFace #'System VIO'} {#PointSize 5}}.
	cItem := controller add: #vAttribChList
		class:			FormCheckList
		rect:				{1587 1046 312 232}
		options:			{#NoBorder #NoEdit #NoSelect #Return #Tab #Backtab}
		form:				form.
	cItem setInitialValueTo: {#Readonly #Hidden #System #Archiv}.
	cItem setInitialSelectionTo: {}.
	cItem := controller add: #writeText
		class:			FormStatic
		rect:				{1915 1044 213 80}
		options:			nil
		form:				form
		text:				'Write:'.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10} #DarkBlue}.
	cItem := controller add: #accessText
		class:			FormStatic
		rect:				{1912 1121 216 80}
		options:			nil
		form:				form
		text:				'Access:'.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10} #DarkBlue}.
	cItem := controller add: #creationText
		class:			FormStatic
		rect:				{1912 1198 216 80}
		options:			nil
		form:				form
		text:				'Creation:'.
	cItem setFormatTo: {#Left #VCenter {#PointSize 10} #DarkBlue}.
	cItem := controller add: #writeEntryDate
		class:			FormStatic
		rect:				{2137 1052 260 66}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.
	cItem := controller add: #accessEntryDate
		class:			FormStatic
		rect:				{2137 1129 260 66}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.
	cItem := controller add: #creationEntryDate
		class:			FormStatic
		rect:				{2137 1207 260 66}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.
	cItem := controller add: #writeEntryTime
		class:			FormStatic
		rect:				{2427 1052 257 66}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.
	cItem := controller add: #accessEntryTime
		class:			FormStatic
		rect:				{2427 1129 257 66}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.
	cItem := controller add: #creationEntryTime
		class:			FormStatic
		rect:				{2427 1207 257 66}
		options:			nil
		form:				form
		text:				''.
	cItem setFormatTo: {#Right #VCenter {#PointSize 10} #Black}.


	temp := AcceleratorTable new.
	temp at: #Escape put: #close.
	temp at: #Alto put: #openFile.
	temp at: #Altc put: #close.
	temp at: #Alti put: #mExpandFileName.
	temp at: #Altn put: #setFocusName.
	temp at: #Altd put: #setFocusDir.
	temp at: #Altt put: #setFocusTypes.
	temp at: #Altv put: #setFocusDrives.
	temp at: #Ctrli put: #mExpandFileName.
	temp at: #Alta put: #mRememberAdd.
	temp at: #AltA put: #mRememberAdd.
	temp at: #Altl put: #mRememberDelete.
	temp at: #AltL put: #mRememberDelete.
	temp at: #Alts put: #mRememberSort.
	temp at: #AltS put: #mRememberSort.
	temp at: #Altp put: #mPreview.
	temp at: #AltP put: #mPreview.
	form setAcceleratorTableTo: temp.

	temp := { #vFileName #vFileList #vDirList #vFileTypes #vDriveList {#vOk #vCancel #vHelp}}.
	form setFormItemGroupsTo: temp.

	temp := controller actionDict.
	temp at: #vDriveList put: #mDriveSelected.
	temp at: #vFileList put: #mFileSelected.
	temp at: #vHelp put: #mHelp.
	temp at: #vFileTypes put: #mFileTypeSelected.
	temp at: #vOk put: #openFile.
	temp at: #vFileName put: #mFileNameChanged.
	temp at: #vRememberMenu put: #mRememberMenu.
	temp at: #vSetupMenu put: #mSetupMenu.
	temp at: #vPreview put: #mTogglePreview.

	temp := controller editDict.
	temp at: #vFileList put: #openFileDblClicked.
	temp at: #vDirList put: #mDirectorySelected.
	temp at: #vRememberLiBo put: #mRememberSelected.
	self on: #wmCharPressed: for: vDriveList action: (Action receiver: self
			send: #selectDriveChar:).
    self on: #changed: for: vDriveList
             action: (Action receiver: self send: #preview:).
    self on: #changed: for: vDirList
             action: (Action receiver: self send: #preview:).

   (cItemDict at: #vRememberLiBo) setPopupTo: (cItemDict at: #vRememberMenu).
   form setPopupTo: (cItemDict at: #vSetupMenu).

	controller setMainFormTo: #FileSelector.
	controller finishInit.
!"end createItems"


!"End of FileDialogController methods block"
