/* DELAY by M. Kimes -- Public Domain -- MSC 6.0a code -- BINDable */
/* Translated from old DOS TC 2.0 code...don't shoot me...         */

#define INCL_DOS
#define INCL_KBD

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include <conio.h>
#include <string.h>

typedef unsigned bit;
typedef unsigned int word;

#define ESC 27

int    _fastcall my_sleep(time_t secs);
void   FAR       key_thread(void);
time_t _fastcall sec_diff (struct tm *t1,struct tm *t2);

unsigned long timeSEM = 0L;
char          isos2;




void cdecl main (int argc,char **argv) {

   struct tm my_time,*mt;
   time_t    t;
   char      elevel=254,e[34],*p;
   int       x,dummyID;
   static    char keystk[2048];


   DosGetMachineMode(&isos2);

   if (argc < 2) {
       fputs("\n\x1b[2J\x1b[30;47m\r DELAY.EXE -- Miscellaneous batch time/date routines -- no (c) by M. Kimes \n",stdout);
GiveHelp:
       fputs("\n\x1b[0m\rNo Delay requested...(DELAY #secs <HMSDEOYWIPK> [args])\n"
             "\nLetter                   ERRORLEVEL"
             "\n======                   ========================="
             "\nH                        Hours"
             "\nM                        Minutes"
             "\nS                        Seconds"
             "\nD                        Day-of-month"
             "\nE                        Day-of-year (remember 255 errorlevel limit)"
             "\nO                        Month"
             "\nY                        2-digit Year"
             "\nW                        Day-of-week"
             "\nI <hh:mm:ss> <hh:mm:ss>  0 if in hours, 1 if out"
             "\nP <hh:mm>                0 when time occurs"
             "\nK <keys> <secs>          key position or 0 on timeout\n"
             "\n If ESCape aborts any delays, 255 is returned.\n",stdout);
        exit(0);
   }
   else {
       if(!isdigit(*argv[1])) {
           fputs("\nPossible foul up in first argument ",stdout);
           fputs(argv[1],stdout);
           fputc('\n',stdout);
       }
       if (!atoi(argv[1])) goto ELEVEL;
       if(isos2) {
         DosCreateThread(key_thread,&dummyID,keystk + 2048);
       }
       fputs("\nPausing ",stdout);
       fputs(argv[1],stdout);
       fputs(" second(s)...",stdout);
       if(my_sleep((time_t)atol(argv[1]))) {
          elevel = 255;
          goto OuttaHere;
       }
   }

ELEVEL:

   t = time(NULL);
   memcpy(&my_time,localtime(&t),sizeof(struct tm));
   if((argc < 3 ) || (argc > 2 && toupper(*argv[2]) != 'K'))
     fputs("\nDropping ",stdout);

   if (argc > 2) {
        if(*argv[2] == '/' || *argv[2] == '-')
          memmove(&argv[2][1],argv[2],strlen(argv[2]));

RESWITCH:

        *argv[2] = (char)toupper(*argv[2]);
        switch((int)*argv[2]) {
        case 'P': {

                 struct tm mytime;
                 time_t    totaltime;

                 if(argc < 4) {
                    fputs("**Error**\n"
                          "Example:  DELAY 0 P 12:00 (waits until 12:00)\n",stdout);
                    goto GiveHelp;
                 }
                 if(isos2) {
                    DosCreateThread(key_thread,&dummyID,keystk + 2048);
                 }
                 fputs("(waiting until ",stdout);
                 fputs(argv[3],stdout);
                 fputs(" [",stdout);
                 p = strtok(argv[3],":");
                 mytime.tm_hour = (char)atoi(p);
                 mytime.tm_min = (char)atoi(strtok(0,":"));
                 t = time(NULL);
                 mt = localtime(&t);
                 totaltime = sec_diff(mt,&mytime);
                 fputs(ltoa(totaltime,e,10),stdout);
                 fputs(" secs] or ESC...",stdout);
                 if(my_sleep(totaltime)) {
                    fputs(" [ESC]",stdout);
                    elevel = 255;
                 }
                 else elevel = 0;
                }
                break;

        case 'K': {

                char spin[] = "\\|/-",*sp = spin;

                if(argc < 4) {
                    fputs("**Error**\n"
                          "Example:  DELAY 0 K ABCD 30 (waits 30 secs for A, B, C or D)\n"
                          "          DELAY 0 K AB 0    (waits forever for A or B)\n",stdout);
                    goto GiveHelp;
                    break;
                }
                t = atol(argv[4]) * 10L;
                elevel = 0;
                strupr(argv[3]);
                fputc(*sp,stdout);
                fputc('\b',stdout);
                do {
                    if(!kbhit()) {
                        fputc(*sp,stdout);
                        fputc('\b',stdout);
                        sp++;
                        if(!*sp) sp = spin;
                        DosSleep(100L);
                        if(kbhit() && t == 1L) t++;
                    }
                    else {
                        x = getch();
                        if(x == ESC) {
                            elevel = 255;
                            break;
                        }
                        if(strchr(argv[3],toupper(x))) {
                            fputc(toupper(x),stdout);
                            elevel = (char)(((int)strchr(argv[3],toupper(x)) -
                                             (int)argv[2]) + 1);
                            break;
                        }
                        else {
                            fputc(*sp,stdout);
                            fputc('\b',stdout);
                            sp++;
                            if(!*sp) sp = spin;
                            DosSleep(100L);
                        }
                    }
                    if(!t) continue;    /* endless loop if secs = 0 */
                } while(--t);
                fputs(" \b",stdout);
                break;
              }

    case 'I': {

                struct ftime {
                  bit sec:  5;
                  bit min:  6;
                  bit hour: 5;
                };
                union tf {
                  struct ftime ft;
                  word x;
                } fdt;
                word x1;
                word x2;

                if(argc < 4) {
                  fputs("**Error**\n"
                        "Example:  DELAY 0 I 12:00:00 13:00:00 (returns 0 if between\n"
                        "12:00:00 and 13:00:00, otherwise returns 1\n",stdout);
                  goto GiveHelp;
                  break;
                }
                p=strtok(argv[3],":");
                fdt.ft.hour=(unsigned)atoi(p);
                fdt.ft.min=(unsigned)atoi(strtok(0,":"));
                fdt.ft.sec=(unsigned)atoi(strtok(0," "));
                x1=fdt.x;
                p=strtok(argv[4],":");
                fdt.ft.hour=(unsigned)atoi(p);
                fdt.ft.min=(unsigned)atoi(strtok(0,":"));
                fdt.ft.sec=(unsigned)atoi(strtok(0," "));
                x2=fdt.x;
                fdt.ft.hour=(word)my_time.tm_hour;
                fdt.ft.min=(word)my_time.tm_min;
                fdt.ft.sec=(word)my_time.tm_sec;
                if (fdt.x<x1 || fdt.x>x2) elevel=1;
                else elevel=0;
                if(elevel) fputs("Out-of-hours",stdout);
                else fputs("In-hours",stdout);
      }
      break;

    case 'H':
      elevel = (char)my_time.tm_hour;
      fputs("Hours",stdout);
      break;

    case 'M':
      elevel = (char)my_time.tm_min;
      fputs("Minutes",stdout);
      break;

    case 'S':
      elevel = (char)my_time.tm_sec;
      fputs("Seconds",stdout);
      break;

    case 'D':
      elevel = (char)my_time.tm_mday;
      fputs("Day-of-month",stdout);
      break;

    case 'E':
      elevel = (char)my_time.tm_yday;
      fputs("Day-of-year",stdout);
      break;

    case 'O':
      elevel = (char)my_time.tm_mon;
      fputs("Month",stdout);
      break;

    case 'Y':
      elevel=(char)(my_time.tm_year%100);
      fputs("Year",stdout);
      break;

    case 'W': {
      t=time(NULL);
      p=(char *)ctime(&t);
      p[3]=0;
      if (!strcmp(p,"Sun")) elevel=1;
      if (!strcmp(p,"Mon")) elevel=2;
      if (!strcmp(p,"Tue")) elevel=3;
      if (!strcmp(p,"Wed")) elevel=4;
      if (!strcmp(p,"Thu")) elevel=5;
      if (!strcmp(p,"Fri")) elevel=6;
      if (!strcmp(p,"Sat")) elevel=7;
          fputs("Day-of-week",stdout);
          break;
      }

    default:
        fputs("\rUnrecognized command \'",stdout);
        fputc(*argv[2],stdout);
        fputs("\'\n",stdout);
        goto GiveHelp;
  }
 }
 else {
    elevel = (char)my_time.tm_sec;
    fputs("Seconds",stdout);
 }

OuttaHere:

   if((argc < 3 ) || (argc > 2 && toupper(*argv[2]) != 'K')) {
       fputs(" ERRORLEVEL: ",stdout);
       fputs(itoa(elevel,e,10),stdout);
       fputs("\n",stdout);
   }

   exit (elevel);
}




int _fastcall my_sleep (time_t secs) {

    if(!isos2) {
      do {
          DosSleep(1000L);
          if(kbhit()) {
              if(getch() == ESC) return ESC;
          }
          if(!secs) break;
      } while(secs--);
      return 0;
    }
    else {
      if(!DosSemSetWait(&timeSEM,(long)secs * 1000L)) return ESC;
      return 0;
    }
}



void FAR key_thread (void) {

    KBDKEYINFO      kbi;
    KBDINFO         ki;


    ki.cb = sizeof(KBDINFO);
    KbdGetStatus(&ki,0);
    ki.fsMask |= KEYBOARD_BINARY_MODE;
    ki.fsMask &= (~KEYBOARD_ASCII_MODE);
    KbdSetStatus(&ki,0);
    for(;;) {
      if (KbdCharIn (&kbi, 0, 0))
        continue;
      if(kbi.chChar == ESC) DosSemClear(&timeSEM);
    }
}



time_t _fastcall sec_diff (struct tm *t1,struct tm *t2) {

    time_t diff;


    if(t2->tm_hour < t1->tm_hour ||
       (t2->tm_hour == t1->tm_hour && t2->tm_min < t1->tm_min)) {
      diff = (time_t)(23 - t1->tm_hour);
      diff += (time_t)t2->tm_hour;
    }
    else {
      diff = (time_t)(t2->tm_hour - t1->tm_hour);
    }

    diff *= (time_t)60L;

    if(t2->tm_min < t1->tm_min) {
      diff += (time_t)(60 - t1->tm_min);
      diff += (time_t)t2->tm_min;
    }
    else {
      diff += (time_t)(t2->tm_min - t1->tm_min);
    }

    diff *= (time_t)60L;

    return diff;
}
