/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _BUBBLEPD_HH
#define _BUBBLEPD_HH

#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include "bubblepd.h"

#pragma SOMAsDefault(on)
#include <som.hh>
#include <somcls.hh>
#pragma SOMNoMangling(on)
#include <WPLNCHPD.hh>

#define BLDLEVEL_VENDOR		"(c) Chris Wohlgemuth (christopher.wohlgemuth@bch.siemens.de)"
#define BLDLEVEL_VERSION		"V1.03 (13.11.98)"
#define BLDLEVEL_INFO		"BubblePad -Bubblehelp for the launchpad"

class M_WPLnchCW:public M_WPLaunchPad
{
#pragma SOMClassName(*,"M_WPLnchCW")
#pragma SOMClassVersion(*,1,2)
#pragma SOMCallstyle(oidl)
public:
	virtual PSZ  wpclsQueryTitle();
		
#pragma SOMReleaseOrder()
};

class WPLnchCW:public WPLaunchPad
{
#pragma SOMClassName(*,"WPLnchCW")
#pragma SOMMetaClass(*,"M_WPLnchCW")
#pragma SOMClassVersion(*,1,2)
#pragma SOMCallstyle(oidl)
private:
public:
	ULONG noDrawers;
  ULONG  delayValue;    //delay for bubble
  ULONG  bubbleEnabled;
	ULONG  smallSizeEnabled;//For sizereducing of Launchpad
	ULONG  icondistance;// Distance of Launchpadicons from the border 
	ULONG ulOpenDrawers;//bit n  indicates open drawer #n
	ULONG ulReOpen;
	BOOL bShutdown;
	BOOL bLock;
	BOOL bWindowList;
	BOOL bSearch;
	RGB  background;
	RGB  foreground;
	char   fontName[FONTNAMELENGTH];
	virtual ULONG wpQueryHideDrawers(){return noDrawers;};
	virtual void wpSetHideDrawers(ULONG ulHide){noDrawers=ulHide;};
	virtual void wpRefreshDrawer(ULONG ulDrawer);
	virtual void wpSetDrawerHWND(ULONG ulDrawer,HWND hwnd);
	virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
	virtual BOOL wpAddLaunchPadPage2(HWND hwndNotebook);
	virtual BOOL wpRestoreState(ULONG ulReserved);
	virtual BOOL wpSaveState();
	virtual HWND wpOpen(HWND hwndCnr,ULONG ulView,ULONG ulParam);
	virtual BOOL wpSetup(PSZ pSetupString);
	virtual PACTIONS wpQueryActionButtons(PULONG pulNumActions);
	virtual ULONG AddBubblehelpPage(HWND hwndNotebook);
	virtual ULONG AddColorchangePage(HWND hwndNotebook);
	virtual ULONG AddOptionPage(HWND hwndNotebook);
	virtual ULONG AddActionButtonPage(HWND hwndNotebook);
#pragma SOMReleaseOrder(\
AddBubblehelpPage(HWND hwndNotebook),\
AddColorchangePage(HWND hwndNotebook),\
AddOptionPage(HWND hwndNotebook),\
wpQueryHideDrawers(),\
wpSetHideDrawers(ULONG ulHide),\
AddActionButtonPage(HWND hwndNotebook))
};

#endif


















