/*
 * LPReplace - Utility to replace the WPLaunchPad-class
 * with WPLnchCW.
 *
 * (c) 1998 Chris Wohlgemuth
 *
 * christopher.wohlgemuth@bch.siemens.de
 *
 * V1.00 13.11.1998
 *
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define INCL_WINWORKPLACE
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>

void usage(char *argv[])
{
	printf("\n%s - Replaces WPLaunchPad with new class 'WPLnchCW'\n",argv[0]);
	printf("WPLnchCW must already be registered or the replacement fails.\n\n");
	printf("Usage:\n\n %s 1 - replace WPLaunchPad\n",argv[0]);
	printf(" %s 0 - unreplace WPLaunchPad\n\n",argv[0]);
}

int main(int argc, char *argv[])
{
	APIRET rc;

	if(argc<2)
	{
		usage(argv);
		exit(10);
	}
	if(*argv[1]=='1') {
		if(WinReplaceObjectClass("WPLaunchPad","WPLnchCW",TRUE)){
			printf("WPLaunchPad succesful replaced.\n");
			printf("You have to restart your WPS to see the effect.\n");
			DosBeep(1000,100);
			exit(0);
		}
		printf("Can't replace WPLaunchPad!\n");
		DosBeep(100,300);
		exit(20);
	}
	if(*argv[1]=='0') {
		if(WinReplaceObjectClass("WPLaunchPad","WPLnchCW",FALSE)) {
			printf("WPLaunchPad unreplaced.\n");
			printf("You have to restart your WPS to see the effect.\n");
			DosBeep(1000,100);
			exit(0);
		}
		printf("Can't unreplace WPLaunchPad!\n");
		DosBeep(100,300);
		exit(20);	
	}
	usage(argv);
	exit(20);
}
