#ifndef __assort_h
#define __assort_h

class deckT;
class files;
class pcbT;

#define EMESSAGES 0
#define E61Callback 1
#define E35Callback 2

typedef struct recordBuffer {
	unsigned int recordLength;
	const char *recordAddress;
} recordBuffer;


extern "C" {
	typedef int (*pCallbackFunction)(void *userHandle, const void *, const void *);

	extern deckT *makeDeck();

	extern int registerCallbackFunction(deckT *, unsigned int routineNumber, pCallbackFunction routineAddress, void *userHandle);

	extern int assortpar(deckT *, const char *);
	extern int assortsor(deckT *, const char *, const char *);
	extern int killDeck(deckT *);

	extern int makePcb(pcbT **, const deckT *, files *);
	extern int killPcb(pcbT *);

	extern int sProc(pcbT *);
	extern int sPull(pcbT *, char **, unsigned long *);
	extern int sPush(pcbT *, const char *, unsigned long);

}

#endif
