/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header   : TSTTIME.INC
**  Author   : Valerio Tavazzi (TAVAZZI at ROMEPPC)
**  Reviewer : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 14 Jul 1992
**  Updated  : 21 Sep 1993
**  Version  : 3.22
**  Content  : Called by TMEFMTMsgProc in WM_INITDLG case statement
**
*/
 {
   char pszRealDate [znlLONGBUFFER] ; // Date as returned by znlGetDateTime
   char pszRealTime [znlLONGBUFFER] ; // Time as returned by znlGetDateTime
   char pszTimein   [znlLONGBUFFER] ; // Time in internal format
   char pszTempTime [znlLONGBUFFER] ; // Formatted time string to be converted in internal
   char pszTime     [znlLONGBUFFER] ; // Formatted time string
   char pszTime12   [znlLONGBUFFER] ; // Time in 12h format
   char pszTime24   [znlLONGBUFFER] ; // Time in 24h format

  /*
  **  Get actual date and time
  */
   if (!znlGetDateTime(pszRealDate, pszRealTime)) return(FALSE) ;

  /*
  **  Get formatted time to be converted in internal format     
  */
   if (!znlMakeCtryTime(&Country, pszRealTime, pszTempTime)) return(FALSE) ;                                                                

  /*
  **  Get internal time for test purposes 
  */
   if(!znlMakeInnerTime(&Country, pszTempTime, pszTimein)) return(FALSE) ;                                                           

  /*
  **  Get pointer to the TMEFMT structure
  */
   Tmefmt = (TMEFMTStruct *)WinQueryWindowULong(hWndClient, OFFSET_TMEFMT) ;

   Tmefmt->TmeFmtFormat = (int)Country.CtryInfo.fsTimeFmt ;
   strcpy(Tmefmt->TmeFmtSeparator , Country.CtryInfo.szTimeSeparator) ;

   if(!znlMakeCtryTime(&Country, pszTimein, pszTime)) break ;

  /*
  **  Time might be 24h (\x01) or 12h (\x00) format
  */
   if(Country.CtryInfo.fsTimeFmt == '\x01')  
   {
     cwCheckDlgItem(hWndDlg, TMEFMT24HRDB, TRUE) ;
     cwCheckDlgItem(hWndDlg, TMEFMT12HRDB, FALSE) ;

     Country.CtryInfo.fsTimeFmt = '\x00' ;

     if (! znlMakeCtryTime   (&Country, pszTimein, pszTime12))   break ;
     if (! WinSetDlgItemText (hWndDlg, TMEFMT24HSTX, pszTime))   break ;
     if (! WinSetDlgItemText (hWndDlg, TMEFMT12HSTX, pszTime12)) break ;

     Country.CtryInfo.fsTimeFmt = '\x01' ;
   }
   else
   {
     cwCheckDlgItem(hWndDlg, TMEFMT24HRDB, FALSE) ;
     cwCheckDlgItem(hWndDlg, TMEFMT12HRDB, TRUE) ;

     Country.CtryInfo.fsTimeFmt = '\x01' ;

     if (! znlMakeCtryTime   (&Country, pszTimein, pszTime24))   break ;
     if (! WinSetDlgItemText (hWndDlg, TMEFMT12HSTX, pszTime))   break ;
     if (! WinSetDlgItemText (hWndDlg, TMEFMT24HSTX, pszTime24)) break ;

     Country.CtryInfo.fsTimeFmt = '\x00' ;
   }

  /*
  **  Initialize entry field control: TmeFmtSeparator
  */
   WinSendDlgItemMsg(hWndDlg, TMEFMTSEPFLD, EM_SETTEXTLIMIT, MPFROMSHORT(2), 0L) ;
   if (Tmefmt->TmeFmtSeparator[0])
     WinSetDlgItemText(hWndDlg, TMEFMTSEPFLD, Tmefmt->TmeFmtSeparator) ;
 }
