/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header   : TSTDATE.INC
**  Author   : Valerio Tavazzi (TAVAZZI at ROMEPPC)
**  Reviewer : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 15 Jul 1992
**  Updated  : 21 Sep 1993
**  Version  : 3.22
**  Content  : Called by DTEFMTMsgProc in WM_INITDLG case statement
**
*/
 {
   char pszRealTime [znlLONGBUFFER] ; // Time as returned by znlGetDateTime
   char pszRealDate [znlLONGBUFFER] ; // Date as returned by znlGetDateTime
   char pszTempDate [znlLONGBUFFER] ; // Formatted Date string to be converted to internal
   char pszDatein   [znlLONGBUFFER] ; // Date in internal format
   char pszDate     [znlLONGBUFFER] ; // Formatted date string
   char pszDateMDY  [znlLONGBUFFER] ; // Date in MMDDYY format
   char pszDateDMY  [znlLONGBUFFER] ; // Date in DDMMYY format
   char pszDateYMD  [znlLONGBUFFER] ; // Date in YYMMDD format

  /*
  **  Get actual date and time 
  */
   if(!znlGetDateTime(pszRealDate, pszRealTime)) return(FALSE) ;

  /*
  **  Get formatted date to be converted in internal format     
  */
   if(!znlMakeCtryDate(&Country, pszRealDate, pszTempDate)) return(FALSE) ;                                                             
                                                                                  
  /*
  **  Get internal date for test purposes  
  */
   if(!znlMakeInnerDate(&Country, pszTempDate, pszDatein)) return(FALSE) ;                                                           
                                      
   Dtefmt = (DTEFMTStruct *)WinQueryWindowULong(hWndClient, OFFSET_DTEFMT) ;

   Dtefmt->DteFmtFormat = Country.CtryInfo.fsDateFmt ;
   strcpy(Dtefmt->DteFmtSeparator , Country.CtryInfo.szDateSeparator) ;

  /*
  **  Create output string pszDate containing the formatted date           
  */
   if(!znlMakeCtryDate(&Country, pszDatein, pszDate)) break ;                                                                     

   switch (Country.CtryInfo.fsDateFmt)
   {
     case 0 :   // Format MMDDYY
     {
      /*
      **  Set radio buttons       
      */
       cwCheckDlgItem(hWndDlg, DTEFMTMDYRDB, TRUE) ;                          
       cwCheckDlgItem(hWndDlg, DTEFMTDMYRDB, FALSE) ;
       cwCheckDlgItem(hWndDlg, DTEFMTYMDRDB, FALSE) ;

      /*
      **  Assign 1 to the field so that the date will be in the format DMY 
      */
       Country.CtryInfo.fsDateFmt = 1 ;                                 

       if (! znlMakeCtryDate(&Country,pszDatein,pszDateDMY)) break ;

      /*
      **  Assign 2 to the field so that the date will be in the format YMD 
      */
       Country.CtryInfo.fsDateFmt = 2 ;                                   

       if (! znlMakeCtryDate(&Country,pszDatein,pszDateYMD)) break ;

      /*
      **  Write static texts
      */
       if (! WinSetDlgItemText(hWndDlg,DTEFMTMDYSTX,pszDate))    break ;
       if (! WinSetDlgItemText(hWndDlg,DTEFMTDMYSTX,pszDateDMY)) break ;
       if (! WinSetDlgItemText(hWndDlg,DTEFMTYMDSTX,pszDateYMD)) break ;

       Country.CtryInfo.fsDateFmt = 0 ;
     }
     break ;

     case 1 :   // Format DDMMYY
     {
      /*
      **  Set radio buttons       
      */
       cwCheckDlgItem(hWndDlg, DTEFMTMDYRDB, FALSE) ;
       cwCheckDlgItem(hWndDlg, DTEFMTDMYRDB, TRUE) ;
       cwCheckDlgItem(hWndDlg, DTEFMTYMDRDB, FALSE) ;

      /*
      **  Assign 0 to the field so that the date will be in the format MDY 
      */
       Country.CtryInfo.fsDateFmt = 0 ;

       if (! znlMakeCtryDate(&Country,pszDatein,pszDateMDY)) break ;

      /*
      **  Assign 2 to the field so that the date will be in the format YMD 
      */
       Country.CtryInfo.fsDateFmt = 2 ;

       if (! znlMakeCtryDate(&Country,pszDatein,pszDateYMD)) break ;

      /*
      **  Write static texts
      */
       if (! WinSetDlgItemText(hWndDlg,DTEFMTMDYSTX,pszDateMDY)) break ;
       if (! WinSetDlgItemText(hWndDlg,DTEFMTDMYSTX,pszDate))    break ;
       if (! WinSetDlgItemText(hWndDlg,DTEFMTYMDSTX,pszDateYMD)) break ;

       Country.CtryInfo.fsDateFmt = 1 ;
     }
     break ;

     case 2 :   // Format YYMMDD
     {
      /*
      **  Set radio buttons       
      */
       cwCheckDlgItem(hWndDlg, DTEFMTMDYRDB, FALSE) ;
       cwCheckDlgItem(hWndDlg, DTEFMTDMYRDB, FALSE) ;
       cwCheckDlgItem(hWndDlg, DTEFMTYMDRDB, TRUE) ;

      /*
      **  Assign 0 to the field so that the date will be in the format MDY 
      */
       Country.CtryInfo.fsDateFmt = 0 ;

       if (! znlMakeCtryDate(&Country,pszDatein,pszDateMDY)) break ;

      /*
      **  Assign 1 to the field so that the date will be in the format DMY 
      */
       Country.CtryInfo.fsDateFmt = 1 ;

       if (! znlMakeCtryDate(&Country,pszDatein,pszDateDMY)) break ;

      /*
      **  Write static texts
      */
       if (! WinSetDlgItemText(hWndDlg,DTEFMTMDYSTX,pszDateMDY)) break ;
       if (! WinSetDlgItemText(hWndDlg,DTEFMTDMYSTX,pszDateDMY)) break ;
       if (! WinSetDlgItemText(hWndDlg,DTEFMTYMDSTX,pszDate))    break ;

       Country.CtryInfo.fsDateFmt = 2 ;
     }
     break ;
   }

  /*
  **  Initialize entry field control: DteFmtSeparator
  */
   WinSendDlgItemMsg(hWndDlg, DTEFMTSEPFLD, EM_SETTEXTLIMIT, MPFROMSHORT(2), 0L) ;
   if (Dtefmt->DteFmtSeparator[0])
     WinSetDlgItemText(hWndDlg, DTEFMTSEPFLD, Dtefmt->DteFmtSeparator) ;
 }
