/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
** Header   : TSTCUR.INC
** Author   : Valerio Tavazzi (TAVAZZI at ROMEPPC)
** Reviewer : Dario de Judicibus (DEJUDICI at ROMEPPC)
** Created  : 16 Jul 1992
** Updated  : 21 Sep 1993
** Version  : 3.22
** Content  : Called by CURFMTMsgProc in WM_INITDLG case statement
**
*/
 {
   char pszCurSample [znlLONGBUFFER] , // Formatted currency string
        pszCurin     [znlLONGBUFFER] , // Currency string in inner format
        pszTempCur   [znlLONGBUFFER] ; // Temporary currency string

  /*
  **  Format the currency string for country  
  */
   if (! znlMakeCtryPrice(&Country, tstCURSAMPLE, pszTempCur)) return(FALSE) ;                                                              

  /*
  **  Get currency string in inner format     
  */
   if(!znlMakeInnerPrice(&Country, pszTempCur, pszCurin)) return(FALSE) ;                                                           

   Curfmt = (CURFMTStruct *)WinQueryWindowULong(hWndClient, OFFSET_CURFMT) ;

   Curfmt->CurFmtLeadZeros = Country.LeadZero ;
   Curfmt->CurFmtDecDigits = Country.CtryInfo.cDecimalPlace ;
   strcpy(Curfmt->CurFmtSymbol , Country.CtryInfo.szCurrency) ;

  /*
  **  Create output string pszCurSample containing the formatted currency string
  */
   if (! znlMakeCtryPrice(&Country, pszCurin, pszCurSample)) break ;

   switch (Country.CtryInfo.fsCurrencyFmt)
   {
     case 0 :   // Prefix, no Interspace
     {
       Curfmt->CurFmtInterSpace = 0 ; // There's no intervening character

      /*
      **  Set radio buttons 
      */
       cwCheckDlgItem(hWndDlg, CURFMTPFXRDB, TRUE) ;                        
       cwCheckDlgItem(hWndDlg, CURFMTSFXRDB, FALSE) ;
     }
     break ;

     case 1 :   // Suffix, no Interspace
     {
       Curfmt->CurFmtInterSpace = 0 ; // There's no intervening character

      /*
      **  Set radio buttons 
      */
       cwCheckDlgItem(hWndDlg, CURFMTPFXRDB, FALSE) ;   
       cwCheckDlgItem(hWndDlg, CURFMTSFXRDB, TRUE) ;
     }
     break ;

     case 2 :   // Prefix, Interspace
     {
       Curfmt->CurFmtInterSpace = 1 ; // There is intervening character

      /*
      **  Set radio buttons 
      */
       cwCheckDlgItem(hWndDlg, CURFMTPFXRDB, TRUE) ;  
       cwCheckDlgItem(hWndDlg, CURFMTSFXRDB, FALSE) ;
     }
     break ;

     case 3 :   // Suffix, Interspace
     {
       Curfmt->CurFmtInterSpace = 1 ; // There is intervening character

      /*
      **  Set radio buttons 
      */
       cwCheckDlgItem(hWndDlg, CURFMTPFXRDB, FALSE) ;   // set radio buttons
       cwCheckDlgItem(hWndDlg, CURFMTSFXRDB, TRUE) ;
     }
     break ;
   }

  /*
  **  Initialize entry field control: CurFmtSymbol
  */
   WinSendDlgItemMsg(hWndDlg, CURFMTSYMFLD, EM_SETTEXTLIMIT, MPFROMSHORT(8), 0L) ;
   if (Curfmt->CurFmtSymbol[0])
     WinSetDlgItemText(hWndDlg, CURFMTSYMFLD, Curfmt->CurFmtSymbol) ;

  /*
  **  Initialize check box control: CurFmtInterSpace
  */
   WinSendDlgItemMsg(hWndDlg, CURFMTISPCHK, BM_SETCHECK,
            MPFROMSHORT(Curfmt->CurFmtInterSpace), 0L) ;

  /*
  **  Initialize check box control: CurFmtLeadZeros
  */
   WinSendDlgItemMsg(hWndDlg, CURFMTLZRCHK, BM_SETCHECK,
            MPFROMSHORT(Curfmt->CurFmtLeadZeros), 0L) ;

  /*
  **  Initialize entry field control: CurFmtDecDigits
  */
   {
     CHAR szWorkBuf[50] ; // local scratch memory

     if(Curfmt->CurFmtDecDigits != 0)
     {
       _itoa(Curfmt->CurFmtDecDigits, szWorkBuf, 10) ;
       WinSetDlgItemText(hWndDlg, CURFMTDGTFLD, szWorkBuf) ;
     }
   }

  /*
  **  Initialize entry field control: CurFmtSample
  */
   WinSendDlgItemMsg(hWndDlg, CURFMTSMPFLD, EM_SETTEXTLIMIT, MPFROMSHORT(16), 0L) ;
   if (pszCurSample[0])
     WinSetDlgItemText(hWndDlg, CURFMTSMPFLD, pszCurSample) ;
 }
