/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header   : CTYINF.H
**  Author   : Valerio Tavazzi (TAVAZZI at ROMEPPC)
**  Reviewer : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 13 Jul 1992 
**  Reviewed : 21 Sep 1993
**  Version  : 3.22
**  Content  : Header file for the sample program for ZNLFUNCS.DLL functions
*/
 #define INCL_PM
 #define INCL_DOSNLS

 #include <os2.h>
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <ctype.h>
 #include <process.h>

 #include <ctyinf.rch>

 #define WM_FAILEDVALIDATE (WM_USER+0)

/*
**  Variables to support example code
*/
 EXTERN ULONG hittest ;
 EXTERN BOOL  tf ;

 EXTERN HWND hAWnd ;
 EXTERN HWND hPtr ;
 EXTERN HWND hMenu ;

 EXTERN POINTL point ;
 EXTERN PSWP   swp ;
 EXTERN PQMSG  pQmsg ;
 EXTERN POWNERITEM poi ;

 EXTERN USHORT keycode ;
 EXTERN USHORT charcode ;
 EXTERN ULONG  ControlID ;
 EXTERN USHORT HelpCmd ;
 EXTERN USHORT CmdSource ;
 EXTERN USHORT SysCmd ;
 EXTERN USHORT FirstValue ;
 EXTERN USHORT LastValue ;

 EXTERN LONG   MenuID ;
 EXTERN SHORT  previous_width ;
 EXTERN SHORT  previous_height ;
 EXTERN SHORT  current_width ;
 EXTERN SHORT  current_height ;

/*
**  These structures are used to add the program name to the task list
*/
 EXTERN HSWITCH hSwitch ;
 EXTERN SWCNTRL Swctl   ;

 EXTERN CHAR szAppName[znlLONGBUFFER] ; // Class name of application                    

 EXTERN HAB  hAB        ; // Handle to the Anchor Block
 EXTERN HMQ  hMQ        ; // Handle to the Message Queue
 EXTERN HWND hWndFrame  ; // Handle to the Window Frame
 EXTERN HWND hWndClient ; // Handle to the Client Window

 typedef _Packed struct
 {
   char   NtlInfCountry[znlLONGBUFFER] ;
   char   NtlInfMeasurements[znlLONGBUFFER] ;
   char   NtlInfListSeparator[znlSHORTBUFFER] ;
 } 
 NTLINFStruct ;

 #define OFFSET_NTLINF 0

 typedef _Packed struct
 {
   int    DteFmtFormat ;
   char   DteFmtSeparator[znlSHORTBUFFER] ;
 } 
 DTEFMTStruct ;

 #define OFFSET_DTEFMT 1*sizeof(char *)

 typedef _Packed struct
 {
   int    TmeFmtFormat ;
   char   TmeFmtSeparator[znlSHORTBUFFER] ;
 } 
 TMEFMTStruct ;

 #define OFFSET_TMEFMT 2*sizeof(char *)

 typedef _Packed struct
 {
   char   NumFmtDec ;
   char   NumFmtThs ;
   char   NumFmtSample[znlLONGBUFFER] ;
 } 
 NUMFMTStruct ;

 #define OFFSET_NUMFMT 3*sizeof(char *)

 typedef _Packed struct
 {
   int    CurFmtPosition ;
   char   CurFmtSymbol[znlSHORTBUFFER] ;
   int    CurFmtInterSpace ;
   int    CurFmtLeadZeros ;
   unsigned int    CurFmtDecDigits ;
   char   CurFmtSample[znlLONGBUFFER] ;
 } 
 CURFMTStruct ;

 #define OFFSET_CURFMT 4*sizeof(char *)

/*
**  Function prototypes
*/
 INT cwCheckDlgItem     (HWND, INT, INT) ;
 INT cwCenter           ( HWND, HWND ) ;
 INT cwSetInitDlgStatus ( HWND ) ;
 INT cwFreeDlgMemory    ( HWND ) ;
 INT cwRegisterClass    ( VOID ) ;

 HWND cwCreateWindow ( HWND, ULONG, PCH, PCH, ULONG, INT, INT, INT, INT, \
                       PHWND, ULONG, USHORT ) ;

 MRESULT EXPENTRY UDDateWndProc ( HWND, ULONG, MPARAM, MPARAM ) ;
 MRESULT EXPENTRY UDEditWndProc ( HWND, ULONG, MPARAM, MPARAM ) ;

 #pragma linkage (WndProc, system)
 MRESULT EXPENTRY WndProc       ( HWND, ULONG, MPARAM, MPARAM ) ;         
 #pragma linkage (NTLINFMsgProc, system)
 MRESULT EXPENTRY NTLINFMsgProc ( HWND, ULONG, MPARAM, MPARAM ) ;         
 #pragma linkage (DTEFMTMsgProc, system)
 MRESULT EXPENTRY DTEFMTMsgProc ( HWND, ULONG, MPARAM, MPARAM ) ;         
 #pragma linkage (TMEFMTMsgProc, system)
 MRESULT EXPENTRY TMEFMTMsgProc ( HWND, ULONG, MPARAM, MPARAM ) ;         
 #pragma linkage (NUMFMTMsgProc, system)
 MRESULT EXPENTRY NUMFMTMsgProc ( HWND, ULONG, MPARAM, MPARAM ) ;         
 #pragma linkage (CURFMTMsgProc, system)
 MRESULT EXPENTRY CURFMTMsgProc ( HWND, ULONG, MPARAM, MPARAM ) ;         

