/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header  : TSTTYPE.INC
**  Author  : Alessandro Cavallini (CAVALLI at ROMEPPC)
**            Pino Venturella (VENTUREL at ROMEPPC)
**  Created : 06 Jul 1992
**  Updated : 31 Aug 1993
**  Version : 3.12
**  Content : Called by TSTFUNMsgProc in WM_CONTROL and TSTFUNTYPDDL case
**            statement. Display the different notation in the corresponding
**            list box
**
*/
{
  GLBL   gbl ;
  FIELD  typfld ;         // Variable for type field
  FIELD  ntnfld ;         // Variable for notation field
  FIELD  smpfld ;         // Variable for sample field
  char   szWorkBuf[33] ;
  USHORT funcID ;

  Tstfun = (TSTFUNStruct *)WinQueryWindowULong(hWndClient, OFFSET_TSTFUN) ;

 /*
 **  Reset radio button value
 */
  cwCheckDlgItem(hWndDlg, TSTFUNFALRDB, FALSE) ;
  cwCheckDlgItem(hWndDlg, TSTFUNTRURDB, FALSE) ;

 /*
 **  Get TYPE and NOTATION values
 */
  WinQueryDlgItemText(hWndDlg, TSTFUNTYPDDL, sizeof(szWorkBuf), szWorkBuf) ;
  strcpy(Tstfun->TstFunType, szWorkBuf) ;

  WinQueryDlgItemText(hWndDlg, TSTFUNNOTDDL, sizeof(szWorkBuf), szWorkBuf) ;
  strcpy(Tstfun->TstFunNotation, szWorkBuf) ;

 /*
 **  Get TYPE and NOTATION ids
 */
  gbl.data = &(hAB) ;

  typfld.dim = 32 ;
  typfld.psz = (PSZ)Tstfun->TstFunType ;

  ntnfld.dim = 32 ;
  ntnfld.psz = (PSZ)Tstfun->TstFunNotation ;

  funcID = tstGetFunctionID (&gbl, &typfld, &ntnfld) ;

 /*
 **  Set SAMPLE accordingly
 */
  smpfld.dim = 32 ;
  smpfld.psz = (PSZ)Tstfun->TstFunSample ;

  tstDisplSample (funcID, &smpfld) ;

  WinSetDlgItemText (hWndDlg, TSTFUNSMPFLD, Tstfun->TstFunSample) ;
}
