/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header   : CHKFUN.H
**  Authors  : Alessandro Cavallini (CAVALLI at ROMEPPC)
**             Pino Venturella (VENTUREL at ROMEPPC)
**  Reviewer : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 08 Jul 1992
**  Updated  : 31 Aug 1993
**  Version  : 3.12
**  Content  : Macro, variables and struct definitions for Test program.
**
*/
 #define INCL_PM
 #include <os2.h>
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <ctype.h>
 #include <process.h>

 #include <chkfun.rch>

 #define WM_FAILEDVALIDATE (WM_USER+0)

/*
**  These structures are used to add the program name to the task list
*/
 EXTERN HSWITCH hSwitch ;
 EXTERN SWCNTRL Swctl ;

 EXTERN CHAR szAppName[20]; // Class name of application

 EXTERN HAB  hAB        ; // Handle to the Anchor Block
 EXTERN HMQ  hMQ        ; // Handle to the Message Queue
 EXTERN HWND hWndFrame  ; // Handle to the Window Frame
 EXTERN HWND hWndClient ; // Handle to the Client Window

 typedef _Packed struct
 {
   char   TstFunTypeTbl[16][32] ;
   char   TstFunType[33] ;
   char   TstFunNotationTbl[16][32] ;
   char   TstFunNotation[33] ;
   char   TstFunInput[33] ;
   int    TstFunResult ;
   char   TstFunSample[33] ;
 }
 TSTFUNStruct ;

 #define OFFSET_TSTFUN 0

/*
**  Function prototypes
*/
 LONG cwCheckDlgItem     ( HWND, LONG, LONG ) ;
 INT  cwCenter           ( HWND, HWND ) ;
 INT  cwSetInitDlgStatus ( HWND ) ;
 INT  cwFreeDlgMemory    ( HWND ) ;
 INT  cwRegisterClass    ( VOID ) ;

 HWND cwCreateWindow ( HWND, ULONG, PCH, PCH, ULONG, INT, INT, INT, INT, \
                       PHWND, ULONG, USHORT ) ;

 MRESULT EXPENTRY UDDateWndProc ( HWND, ULONG, MPARAM, MPARAM ) ;
 MRESULT EXPENTRY UDEditWndProc ( HWND, ULONG, MPARAM, MPARAM ) ;

 #pragma linkage (WndProc, system)
 MRESULT EXPENTRY WndProc       ( HWND, ULONG, MPARAM, MPARAM ) ;
 #pragma linkage (TSTFUNMsgProc, system)
 MRESULT EXPENTRY TSTFUNMsgProc ( HWND, ULONG, MPARAM, MPARAM ) ;

