/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** \----------------------------------------------------------------------/
**
**  Header   : ZHPDEFS.H
**  Author   : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 24 Sep 1992
**  Updated  : 27 Aug 1993
**  Version  : 2.12
**  Content  : Host <-> PC Conversion Services
**
*/
 #ifndef zhpDEFINITIONS
 #define zhpDEFINITIONS 0

/*
**  Global Values
*/
 #define  zhpZPREFIX  "ZHP"
 #define  zhpDLLNAME  "FMZHPFUN" // The name of THIS library

/*
**  Constants used for date and time conversions
*/
 #define  zhpLOMASK  ((BYTE)0x0F)   // Get low nibble
 #define  zhpHIMASK  ((BYTE)0xF0)   // Get high nibble
 #define  zhpCHMASK  ((BYTE)0x30)   // Base for ASCII digits
 #define  zhpTERMINATOR   '\0'      // String terminator
 #define  zhpSPACE        ' '       // Blank space

/*
**  Constants used for floating point number conversions
*/
 #define zhpHI   1   // index of hi order byte/word/long
 #define zhpLO   0   // index of lo order byte/word/long

 #define zhpS370FSGN     0x80000000   // "S370 float" sign mask
 #define zhpS370FEXP     0x7F000000   // "S370 float" exponent mask
 #define zhpS370FFRC     0x00FFFFFF   // "S370 float" fraction mask

 #define zhpIEEEFSGN     0x80000000   // "IEEE float" sign mask
 #define zhpIEEEFEXP     0x7F800000   // "IEEE float" exponent mask
 #define zhpIEEEFFRC     0x007FFFFF   // "IEEE float" fraction mask

 #define zhpBITSMASK     0x7FFFFFFF   // Bit mask

/*
**  Largest representable numbers, IEEE format
*/
 #define zhpFMAXIEEE     0x7F7FFFFF
 #define zhpDMAXIEEEHI   0x7FEFFFFF
 #define zhpDMAXIEEELO   0xFFFFFFFF

/*
**  Largest representable numbers, 370 format
*/
 #define zhpFMAXS370      0x7FFFFFFF
 #define zhpDMAXS370HI    0x7FFFFFFF
 #define zhpDMAXS370LO    0xFFFFFFFF

 #endif
