/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header   : PCHOST.C
**  Author   : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 26 Oct 1992
**  Updated  : 27 Aug 1993
**  Version  : 2.12
**  Content  : Sample program for FMZHPFUN.DLL services
**
*/
 #define EXTERN
 #include <pchost.h>
 #include <zzzlogo.h>

/* ------------------------------------------------------------------------ */

/*
**  Presentation Manager Program Main Body
**
**  The following routine is the Presentation Manager program Main Body.
**  The Main Body of a PM program is concerned with associating the
**  application with the Presentation Manager system, creating its
**  message queue, registering and displaying its main window, servicing
**  its message queue during the time that the application is active,
**  and disassociating the application from PM when the user is finished
**  with the application. The remaining parts of this source module that
**  are concerned with the Presentation Manager are the application's
**  window procedures (main window procedure, child window procedures,
**  and dialog window procedures) that process the messages associated
**  with the application's various windows.
**
*/
 int main(int argc, char *argv[])
 {
   QMSG qmsg ; // MSG structure to store your messages
   PID  pid  ; // Process identifier for adding name to switch list
   TID  tid  ; // Thread identifier

   static CHAR szTitle[29] ;

   argc = argc ; // Suppress compiler warning - can remove if argc and argv
   argv = argv ; // are referenced by user-supplied code.

  /*
  **  The WinInitialize routine initializes the Presentation Manager
  **  facilities for use by this application and returns a handle to the
  **  anchor block assigned to the application by PM.
  */
   if ((hAB = WinInitialize(0)) == 0) return(FALSE) ;

  /*
  **  The WinCreateMsgQueue call creates a message queue for this application
  */
   if ((hMQ = WinCreateMsgQueue(hAB, 0)) == 0) return(FALSE) ;

  /*
  **  The following function registers the classes of all application windows
  */
   if (!cwRegisterClass()) return(FALSE) ;

  /*
  **  The CreateWindow function creates a frame window for this application's
  **  top window, and set the window's size and location as appropriate.
  */
   WinLoadString(hAB, 0, IDS_TITLE, 29, szTitle) ;
   hWndFrame = cwCreateWindow((HWND)HWND_DESKTOP,
                              FCF_TITLEBAR     |
                              FCF_SYSMENU      |
                              FCF_DLGBORDER    |
                              FCF_MENU         |
                              FCF_ACCELTABLE   |
                              FCF_SHELLPOSITION,
                              szAppName,
                              szTitle,
                              ID_PCHOST,
                              72, 116,
                              160, 35,
                              &hWndClient,
                              0L, SWP_SHOW) ;

   if (hWndFrame == 0) return(FALSE) ;

  /*
  **  The following inline routine fills out the application's switch control
  **  structure with the appropriate information to add the application's
  **  name to the OS/2 Task Manager List, a list of the jobs currently
  **  running on the computer.
  */
   WinQueryWindowProcess(hWndFrame, &pid, &tid) ;

   Swctl.hwnd = hWndFrame ;                         // Frame window handle
   Swctl.idProcess = pid ;                          // Process identifier
   Swctl.uchVisibility = SWL_VISIBLE ;              // visibility
   Swctl.fbJump = SWL_JUMPABLE ;                    // Jump indicator
   strcpy(Swctl.szSwtitle, szTitle) ;               // Frame window title
   hSwitch = WinAddSwitchEntry(&Swctl) ;

  /*
  **  The following is the message loop for the application.
  */
   while (WinGetMsg(hAB, (PQMSG)&qmsg, 0, 0, 0))
   {
     WinDispatchMsg(hAB,(PQMSG)&qmsg) ;
   }

  /*
  **  Perform clean up before exiting application.
  **  The following routine destroys the application's frame window (which
  **  also destroys its child windows), destroys its message queue, and
  **  disassociates the application from the Presentation Manager system.
  */
   WinDestroyWindow(hWndFrame) ; // Destroy the frame window
   WinDestroyMsgQueue(hMQ) ;     // Destroy this application's message queue
   WinTerminate(hAB) ;           // Terminate this application's use of the
                                 // Presentation Manager resources
   return (0) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Main Window Procedure
**
**  This procedure provides service routines for the general PM events
**  (messages) that PM sends to the window, as well as the user
**  initiated events (messages) that are generated when the user selects
**  the action bar and pulldown menu controls or the corresponding
**  keyboard accelerators.
**
**  The SWITCH statement shown below distributes the window messages to
**  the respective message service routines, which are set apart by the
**  CASE statements. The window procedures must provide an appropriate
**  service routine for its end user initiated messages, as well as the
**  general PM messages (like the WM_CLOSE message). If a message is
**  sent to this procedure for which there is no programmed CASE clause
**  (i.e., no service routine), the message is defaulted to the
**  WinDefWindowProc function, where it is disposed of by PM.
**
*/
 MRESULT EXPENTRY WndProc
 (
   HWND   hWnd    ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   HPS   hPS     ;   // Handle for the Presentation Space
   RECTL rClient ;   // Handle to rectangle formed by client area

   switch(message)
   {
    /*
    **  The PM messages for action bar and pulldown menu items are
    **  processed in this routine.
    */
     case WM_COMMAND :
     {
       switch (SHORT1FROMMP(mp1))
       {
         case IDM_C_H_DATES :
         {
          /*
          **  The code below makes a call to the dialog box named "PCHDAT".
          **  Variable rc will receive the return code sent when the dialog
          **  box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)PCHDATMsgProc,
                           0,
                           IDLG_PCHDAT,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_H_TIMES:
         {
          /*
          **  The code below makes a call to the dialog box named "PCHTME".
          **  Variable rc will receive the return code sent when the dialog
          **  box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)PCHTMEMsgProc,
                           0,
                           IDLG_PCHTME,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_H_SHORTINTEGERS :
         {
          /*
          **  The code below makes a call to the dialog box named "PCHSHR".
          **  Variable rc will receive the return code sent when the dialog
          **  box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)PCHSHRMsgProc,
                           0,
                           IDLG_PCHSHR,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_H_LONGINTEGERS :
         {
          /*
          **  The code below makes a call to the dialog box named "PCHLNG".
          **  Variable rc will receive the return code sent when the dialog
          **  box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)PCHLNGMsgProc,
                           0,
                           IDLG_PCHLNG,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_H_SINGLEFLOAT :
         {
          /*
          **  The code below makes a call to the dialog box named "PCHSPF".
          **  Variable rc will receive the return code sent when the dialog
          **  box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)PCHSPFMsgProc,
                           0,
                           IDLG_PCHSPF,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_H_DOUBLEFLOAT :
         {
          /*
          **  The code below makes a call to the dialog box named "PCHDPF".
          **  Variable rc will receive the return code sent when the dialog
          **  box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)PCHDPFMsgProc,
                           0,
                           IDLG_PCHDPF,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_P_DATES :
         {
          /*
          **  The code below makes a call to the dialog box named "HPCDAT".
          **  Variable rc will receive the return code sent when the dialog
          **  box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)HPCDATMsgProc,
                           0,
                           IDLG_HPCDAT,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_P_TIMES:
         {
          /*
          ** The code below makes a call to the dialog box named "HPCTME".
          ** Variable rc will receive the return code sent when the dialog
          ** box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)HPCTMEMsgProc,
                           0,
                           IDLG_HPCTME,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_P_SHORTINTEGERS :
         {
          /*
          ** The code below makes a call to the dialog box named "HPCSHR".
          ** Variable rc will receive the return code sent when the dialog
          ** box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)HPCSHRMsgProc,
                           0,
                           IDLG_HPCSHR,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_P_LONGINTEGERS :
         {
          /*
          ** The code below makes a call to the dialog box named "HPCLNG".
          ** Variable rc will receive the return code sent when the dialog
          ** box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)HPCLNGMsgProc,
                           0,
                           IDLG_HPCLNG,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_P_SINGLEFLOAT :
         {
          /*
          ** The code below makes a call to the dialog box named "HPCSPF".
          ** Variable rc will receive the return code sent when the dialog
          ** box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)HPCSPFMsgProc,
                           0,
                           IDLG_HPCSPF,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_P_DOUBLEFLOAT :
         {
          /*
          ** The code below makes a call to the dialog box named "HPCDPF".
          ** Variable rc will receive the return code sent when the dialog
          ** box is closed.
          */
           ULONG rc ;

           rc = WinDlgBox( HWND_DESKTOP,
                           hWnd,
                           (PFNWP)HPCDPFMsgProc,
                           0,
                           IDLG_HPCDPF,
                           (PVOID)&hWnd) ;
         }
         break ;

         case IDM_C_ABOUT :
         {
           #include "TSTABOUT.INC"
         }
         break ;

         case IDM_C_EXIT :
         {
           #include "TSTEXITW.INC"
         }
         break ;

         default :
         {
           break ;
         }
       }    // End of switch
     }    // End of WM_COMMAND
     break ;

     case WM_CREATE :
     {
      /*
      ** The WM_CREATE message is sent to a window when an application
      ** requests that the window be created.  The window procedure
      ** for the new window receives this message after the window is
      ** created, but before the window becomes visible.
      **
      */
       cwSetInitDlgStatus(hWnd) ;
     }
     break ;

     case WM_MOUSEMOVE :
     {
       return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
     }
     break ;

     case WM_SIZE :
     {
     }
     break ;

     case WM_PAINT:    // Code for the window's client area
     {
      /*
      **  Obtain a handle to a cache presentation space
      */
       hPS = WinBeginPaint(hWnd, 0, 0) ;

      /*
      **  Determine the size of the client area
      */
       WinQueryWindowRect(hWnd, &rClient) ;

      /*
      **  Fill the background with the default background color
      */
       WinFillRect(hPS, &rClient, CLR_BACKGROUND) ;

      /*
      **  Return presentation space to state before WinBeginPaint
      */
       WinEndPaint(hPS) ;
     }
     break ;

     case WM_CLOSE :
     {
       #include "TSTCLOSE.INC"

       if(hWnd != hWndClient) break ;
       cwFreeDlgMemory(hWnd) ;
       return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
     }
     break ;

     case WM_TRANSLATEACCEL:
     {
       return(WinDefWindowProc(hWndClient, message, mp1, mp2)) ;
     }
     break ;

     default :
     {
      /*
      **  For any message for which you don't specifically provide a
      **  service routine, you should return the message to PM using
      **  the WinDefWindowProc function.
      */
       return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
     }
     break ;
   } // End of switch message

   return(0L) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY PCHDATMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND   hWndParent ;
   PCHDATStruct *Pchdat     ;

   switch(message)
   {
     case WM_INITDLG:
     {
       Pchdat = (PCHDATStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHDAT) ;

       hWndParent = *((HWND *)mp2) ;
       (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;

      /*
      **  Initialize entry field control: PchDatPcDate
      */
       WinSendDlgItemMsg(hWndDlg, PCHDATVALFLD,
                         EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
       Pchdat->PchDatPcDate[0] = 0 ;

      /*
      **  Initialize entry field control: PchDatHostDate
      */
       WinSendDlgItemMsg(hWndDlg, PCHDATHVLFLD,
                         EM_SETTEXTLIMIT, MPFROMLONG(8), 0L)  ;
       if(Pchdat->PchDatHostDate[0])
         WinSetDlgItemText(hWndDlg, PCHDATHVLFLD, Pchdat->PchDatHostDate)  ;

      /*
      **  Set focus on input field and return TRUE
      */
       tstSetFocus(PCHDATVALFLD) ;
       tstReturnMR(1) ;
      }
      break  ;

    case WM_CONTROL:
    {
      switch(SHORT1FROMMP(mp1))
      {
        case PCHDATVALFLD: // Entry field variable: "PchDatPcDate"
        {
          switch(SHORT2FROMMP(mp1)) // switch on Notification Code
          {
            case EN_SETFOCUS:  // Entry field is receiving the focus
                 break ;

            case EN_KILLFOCUS: // Entry field is losing the focus
                 break ;

            default: // Default other messages
                 return(WinDefDlgProc(hWndDlg, message, mp1, mp2))  ;
                 break ;
          }
        }
        break ;

        case PCHDATHVLFLD: // Entry field variable: "PchDatHostDate"
        {
          switch(SHORT2FROMMP(mp1)) // switch on Notification Code
          {
            case EN_SETFOCUS:  // Entry field is receiving the focus
                 break ;

            case EN_KILLFOCUS: // Entry field is losing the focus
                 break ;

             default: // Default other messages
                 return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                 break ;
          }
        }
        break ;
      } // End of switch
    }
    break ; // End of WM_CONTROL

    case WM_COMMAND:
    {
      switch(SHORT1FROMMP(mp1))
      {
        case DID_OK: // Button text: "OK"
        {
          CHAR szWorkBuf[13] ; // local scratch memory

          Pchdat = (PCHDATStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHDAT) ;

         /*
         **  Query the string value in the entry field control and
         **  move the string value to the dialog structure variable
         */
          WinQueryDlgItemText(hWndDlg, PCHDATVALFLD, sizeof(szWorkBuf), szWorkBuf) ;
          strcpy(Pchdat->PchDatPcDate, szWorkBuf) ;

          WinDismissDlg(hWndDlg, TRUE) ;
        }
        break ;

        case PCHDATCVTBUT: // Button text: "~Convert"
        {
          #include "PCHDAT.INC"
        }
        break ;
      }
    }
    break ; // End of WM_COMMAND

    case WM_CLOSE:
         WinDismissDlg(hWndDlg, FALSE) ;
         break ; // End of WM_CLOSE

    case WM_FAILEDVALIDATE:
         return((MRESULT)TRUE) ;
         break ; // End of WM_FAILEDVALIDATE

    default:
         return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
         break ;
   }

   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
** Dialog Window Procedure
**
** This procedure is associated with the dialog box that is included in
** the function name of the procedure. It provides the service routines
** for the events (messages) that occur because the end user operates
** one of the dialog box's buttons, entry fields, or controls.
**
** The SWITCH statement in the function distributes the dialog box
** messages to the respective service routines, which are set apart by
** the CASE clauses. Like any other PM window, the Dialog Window
** procedures must provide an appropriate service routine for their end
** user initiated messages as well as for the general PM messages (like
** the WM_CLOSE message). If a message is sent to this procedure for
** which there is no programmed CASE condition (no service routine),
** the message is defaulted to the WinDefDlgProc function, where it is
** disposed of by PM.
**
*/
 MRESULT EXPENTRY PCHTMEMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   PCHTMEStruct *Pchtme ;

   switch(message)
   {
     case WM_INITDLG:
     {
       Pchtme = (PCHTMEStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHTME) ;

       hWndParent = *((HWND *)mp2)  ;
       (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;

      /*
      ** Initialize entry field control: PchTmePcTime
      */
       WinSendDlgItemMsg(hWndDlg, PCHTMEVALFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
       Pchtme->PchTmePcTime[0] = 0 ;

      /*
      ** Initialize entry field control: PchTmeHostTime
      */
       WinSendDlgItemMsg(hWndDlg, PCHTMEHVLFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
       if(Pchtme->PchTmeHostTime[0])
          WinSetDlgItemText(hWndDlg, PCHTMEHVLFLD, Pchtme->PchTmeHostTime) ;

      /*
      **  Set focus on input field and return TRUE
      */
       tstSetFocus(PCHTMEVALFLD) ;
       tstReturnMR(1) ;
     }
     break ; // End of WM_INITDLG

     case WM_CONTROL:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case PCHTMEVALFLD: // Entry field variable: "PchTmePcTime"
         {
           switch(SHORT2FROMMP(mp1)) // switch on Notification Code
           {
             case EN_SETFOCUS: // Entry field is receiving the focus
                  break ;

             case EN_KILLFOCUS: // Entry field is losing the focus
                  break ;

             default: // Default other messages
                  return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                  break ;
           }
         }
         break ;

         case PCHTMEHVLFLD: // Entry field variable: "PchTmeHostTime"
         {
           switch(SHORT2FROMMP(mp1)) // switch on Notification Code
           {
             case EN_SETFOCUS: // Entry field is receiving the focus
                  break ;

             case EN_KILLFOCUS: // Entry field is losing the focus
                  break ;

             default: // Default other messages
                  return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                  break ;
           }
         }
         break ;
       }
     }
     break ; // End of WM_CONTROL

     case WM_COMMAND:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case DID_OK: // Button text: "OK"
         {
           Pchtme = (PCHTMEStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHTME) ;

          /*
          **  Query the string value in the entry field control and
          **  move the string value to the dialog structure variable
          */
           {
             CHAR szWorkBuf[13] ; // local scratch memory

             WinQueryDlgItemText(hWndDlg, PCHTMEVALFLD, sizeof(szWorkBuf), szWorkBuf) ;
             strcpy(Pchtme->PchTmePcTime, szWorkBuf) ;
           }
           WinDismissDlg(hWndDlg, TRUE) ;
         }
         break ;

         case PCHTMECVTBUT: // Button text: "~Convert"
           #include "PCHTME.INC"
           break ;
       }
     }
     break ; // End of WM_COMMAND

     case WM_CLOSE:
           WinDismissDlg(hWndDlg, FALSE) ;
           break ; // End of WM_CLOSE

      case WM_FAILEDVALIDATE:
           return((MRESULT)TRUE) ;
           break ; // End of WM_FAILEDVALIDATE

      default:
           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           break ;
     }
   return FALSE ;

 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY PCHSHRMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   PCHSHRStruct *Pchshr ;

   switch(message)
     {
      case WM_INITDLG:
           Pchshr = (PCHSHRStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHSHR) ;

           hWndParent = *((HWND *)mp2)  ;
           (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;

          /*
          ** Initialize entry field control: PchShrPcShort
          */
           WinSendDlgItemMsg(hWndDlg, PCHSHRVALFLD, EM_SETTEXTLIMIT, MPFROMLONG(6), 0L) ;
           Pchshr->PchShrPcShort = 0 ;

          /*
          ** Initialize entry field control: PchShrHostShort
          */
           WinSendDlgItemMsg(hWndDlg, PCHSHRHVLFLD, EM_SETTEXTLIMIT, MPFROMLONG(4), 0L) ;
           if(Pchshr->PchShrHostShort[0])
              WinSetDlgItemText(hWndDlg, PCHSHRHVLFLD, Pchshr->PchShrHostShort) ;

          /*
          **  Set focus on input field and return TRUE
          */
           tstSetFocus(PCHSHRVALFLD) ;
           tstReturnMR(1) ;
           break ; // End of WM_INITDLG

      case WM_CONTROL:
           switch(SHORT1FROMMP(mp1))
             {
              case PCHSHRVALFLD: // Entry field variable: "PchShrPcShort"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
              case PCHSHRHVLFLD: // Entry field variable: "PchShrHostShort"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
             }
           break ; // End of WM_CONTROL

      case WM_COMMAND:
           switch(SHORT1FROMMP(mp1))
             {
               case DID_OK: // Button text: "OK"
               {
                 Pchshr = (PCHSHRStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHSHR) ;

                /*
                ** Query the string value in the entry field control and
                ** move the string value to the dialog structure variable
                */
                 {
                   CHAR szWorkBuf[50] ; // local scratch memory
                   WinQueryDlgItemText(hWndDlg, PCHSHRVALFLD, 50, szWorkBuf) ;
                   Pchshr->PchShrPcShort = atoi(szWorkBuf) ;
                 }
                 WinDismissDlg(hWndDlg, TRUE) ;
               }
               break ;

               case PCHSHRCVTBUT: // Button text: "~Convert"
                 #include "PCHSHR.INC"
                 break ;
             }
           break ; // End of WM_COMMAND

      case WM_CLOSE:
           WinDismissDlg(hWndDlg, FALSE) ;
           break ; // End of WM_CLOSE

      case WM_FAILEDVALIDATE:
           return((MRESULT)TRUE) ;
           break ; // End of WM_FAILEDVALIDATE

      default:
           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           break ;
     }
   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY PCHLNGMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   PCHLNGStruct *Pchlng ;

   switch(message)
     {
      case WM_INITDLG:
           Pchlng = (PCHLNGStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHLNG) ;

           hWndParent = *((HWND *)mp2)  ;
           (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;

          /*
          ** Initialize entry field control: PchLngPcLong
          */
           WinSendDlgItemMsg(hWndDlg, PCHLNGVALFLD, EM_SETTEXTLIMIT, MPFROMLONG(11), 0L) ;
           Pchlng->PchLngPcLong = 0 ;

          /*
          ** Initialize entry field control: PchLngHostLong
          */
           WinSendDlgItemMsg(hWndDlg, PCHLNGHVLFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
           if(Pchlng->PchLngHostLong[0])
              WinSetDlgItemText(hWndDlg, PCHLNGHVLFLD, Pchlng->PchLngHostLong) ;

          /*
          **  Set focus on input field and return TRUE
          */
           tstSetFocus(PCHLNGVALFLD) ;
           tstReturnMR(1) ;
           break ; // End of WM_INITDLG

      case WM_CONTROL:
           switch(SHORT1FROMMP(mp1))
             {
              case PCHLNGVALFLD: // Entry field variable: "PchLngPcLong"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
              case PCHLNGHVLFLD: // Entry field variable: "PchLngHostLong"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
             }
           break ; // End of WM_CONTROL

      case WM_COMMAND:
           switch(SHORT1FROMMP(mp1))
             {
               case DID_OK: // Button text: "OK"
                 Pchlng = (PCHLNGStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHLNG) ;

                /*
                **  Query the string value in the entry field control and
                **  move the string value to the dialog structure variable
                */
                 {
                   CHAR szWorkBuf[50] ; // local scratch memory
                   WinQueryDlgItemText(hWndDlg, PCHLNGVALFLD, 50, szWorkBuf) ;
                   Pchlng->PchLngPcLong = atol(szWorkBuf) ;
                 }
                 WinDismissDlg(hWndDlg, TRUE) ;
                 break ;

               case PCHLNGCVTBUT: // Button text: "~Convert"
                   #include "PCHLNG.INC"
                   break ;
             }
           break ; // End of WM_COMMAND

      case WM_CLOSE:
           WinDismissDlg(hWndDlg, FALSE) ;
           break ; // End of WM_CLOSE

      case WM_FAILEDVALIDATE:
           return((MRESULT)TRUE) ;
           break ; // End of WM_FAILEDVALIDATE

      default:
           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           break ;
     }
   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY PCHSPFMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   PCHSPFStruct *Pchspf ;

   switch(message)
     {
      case WM_INITDLG:
           Pchspf = (PCHSPFStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHSPF) ;

           hWndParent = *((HWND *)mp2)  ;
           (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;
          /*
          ** Initialize entry field control: PchSpfPcFloat
          */
           WinSendDlgItemMsg(hWndDlg, PCHSPFVALFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
           Pchspf->PchSpfPcFloat[0] = 0 ;

          /*
          ** Initialize entry field control: PchSpfHostFloat
          */
           WinSendDlgItemMsg(hWndDlg, PCHSPFHVLFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
           if(Pchspf->PchSpfHostFloat[0])
              WinSetDlgItemText(hWndDlg, PCHSPFHVLFLD, Pchspf->PchSpfHostFloat) ;

          /*
          **  Set focus on input field and return TRUE
          */
           tstSetFocus(PCHSPFVALFLD) ;
           tstReturnMR(1) ;
           break ; // End of WM_INITDLG

      case WM_CONTROL:
           switch(SHORT1FROMMP(mp1))
             {
              case PCHSPFVALFLD: // Entry field variable: "PchSpfPcFloat"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
              case PCHSPFHVLFLD: // Entry field variable: "PchSpfHostFloat"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
             }
           break ; // End of WM_CONTROL

      case WM_COMMAND:
           switch(SHORT1FROMMP(mp1))
             {
              case DID_OK: // Button text: "OK"
                 Pchspf = (PCHSPFStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHSPF) ;

                /*
                **  Query the string value in the entry field control and
                **  move the string value to the dialog structure variable
                */
                 {
                   CHAR szWorkBuf[13] ; // local scratch memory

                    WinQueryDlgItemText(hWndDlg, PCHSPFVALFLD, sizeof(szWorkBuf), szWorkBuf) ;
                    strcpy(Pchspf->PchSpfPcFloat, szWorkBuf) ;
                   }
                   WinDismissDlg(hWndDlg, TRUE) ;
                   break ;

              case PCHSPFCVTBUT: // Button text: "~Convert"
                   #include "PCHSPF.INC"
                   break ;
             }
           break ; // End of WM_COMMAND

      case WM_CLOSE:
           WinDismissDlg(hWndDlg, FALSE) ;
           break ; // End of WM_CLOSE

      case WM_FAILEDVALIDATE:
           return((MRESULT)TRUE) ;
           break ; // End of WM_FAILEDVALIDATE

      default:
           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           break ;
     }
   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY PCHDPFMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   PCHDPFStruct *Pchdpf ;

   switch(message)
     {
      case WM_INITDLG:
           Pchdpf = (PCHDPFStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHDPF) ;

           hWndParent = *((HWND *)mp2)  ;
           (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;

          /*
          ** Initialize entry field control: PchDpfPcDouble
          */
           WinSendDlgItemMsg(hWndDlg, PCHDPFVALFLD, EM_SETTEXTLIMIT, MPFROMLONG(16), 0L) ;
           Pchdpf->PchDpfPcDouble[0] = 0 ;

          /*
          ** Initialize entry field control: PchDpfHostDouble
          */
           WinSendDlgItemMsg(hWndDlg, PCHDPFHVLFLD, EM_SETTEXTLIMIT, MPFROMLONG(16), 0L) ;
           if(Pchdpf->PchDpfHostDouble[0])
              WinSetDlgItemText(hWndDlg, PCHDPFHVLFLD, Pchdpf->PchDpfHostDouble) ;

          /*
          **  Set focus on input field and return TRUE
          */
           tstSetFocus(PCHDPFVALFLD) ;
           tstReturnMR(1) ;
           break ; // End of WM_INITDLG

      case WM_CONTROL:
           switch(SHORT1FROMMP(mp1))
             {
              case PCHDPFVALFLD: // Entry field variable: "PchDpfPcDouble"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
              case PCHDPFHVLFLD: // Entry field variable: "PchDpfHostDouble"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
             }
           break ; // End of WM_CONTROL

      case WM_COMMAND:
           switch(SHORT1FROMMP(mp1))
             {
              case DID_OK: // Button text: "OK"
                 Pchdpf = (PCHDPFStruct *)WinQueryWindowULong(hWndClient, OFFSET_PCHDPF) ;

                  /*
                  ** Query the string value in the entry field control and
                  ** move the string value to the dialog structure variable
                  */
                   {
                    CHAR szWorkBuf[21] ; // local scratch memory

                    WinQueryDlgItemText(hWndDlg, PCHDPFVALFLD, sizeof(szWorkBuf), szWorkBuf) ;
                    strcpy(Pchdpf->PchDpfPcDouble, szWorkBuf) ;
                   }
                   WinDismissDlg(hWndDlg, TRUE) ;
                   break ;

              case PCHDPFCVTBUT: // Button text: "~Convert"
                   #include "PCHDPF.INC"
                   break ;
             }
           break ; // End of WM_COMMAND

      case WM_CLOSE:
           WinDismissDlg(hWndDlg, FALSE) ;
           break ; // End of WM_CLOSE

      case WM_FAILEDVALIDATE:
           return((MRESULT)TRUE) ;
           break ; // End of WM_FAILEDVALIDATE

      default:
           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           break ;
     }
   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY HPCDATMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   HPCDATStruct *Hpcdat ;

   switch(message)
     {
      case WM_INITDLG:
           Hpcdat = (HPCDATStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCDAT) ;

           hWndParent = *((HWND *)mp2)  ;
           (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;

          /*
          ** Initialize entry field control: HpcDatPcDate
          */
           WinSendDlgItemMsg(hWndDlg, HPCDATVALFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
           if(Hpcdat->HpcDatPcDate[0])
              WinSetDlgItemText(hWndDlg, HPCDATVALFLD, Hpcdat->HpcDatPcDate) ;

          /*
          ** Initialize entry field control: HpcDatHostDate
          */
           WinSendDlgItemMsg(hWndDlg, HPCDATHVLFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
           Hpcdat->HpcDatHostDate[0] = 0 ;

          /*
          **  Set focus on input field and return TRUE
          */
           tstSetFocus(HPCDATVALFLD) ;
           tstReturnMR(1) ;
           break ; // End of WM_INITDLG

      case WM_CONTROL:
           switch(SHORT1FROMMP(mp1))
             {
              case HPCDATVALFLD: // Entry field variable: "HpcDatPcDate"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
              case HPCDATHVLFLD: // Entry field variable: "HpcDatHostDate"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
             }
           break ; // End of WM_CONTROL

      case WM_COMMAND:
           switch(SHORT1FROMMP(mp1))
             {
              case DID_OK: // Button text: "OK"
                 Hpcdat = (HPCDATStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCDAT) ;

                  /*
                  ** Query the string value in the entry field control and
                  ** move the string value to the dialog structure variable
                  */
                   {
                    CHAR szWorkBuf[13] ; // local scratch memory

                    WinQueryDlgItemText(hWndDlg, HPCDATHVLFLD, sizeof(szWorkBuf), szWorkBuf) ;
                    strcpy(Hpcdat->HpcDatHostDate, szWorkBuf) ;
                   }
                   WinDismissDlg(hWndDlg, TRUE) ;
                   break ;

              case HPCDATCVTBUT: // Button text: "~Convert"
                   #include "HPCDAT.INC"
                   break ;
             }
           break ; // End of WM_COMMAND

      case WM_CLOSE:
           WinDismissDlg(hWndDlg, FALSE) ;
           break ; // End of WM_CLOSE

      case WM_FAILEDVALIDATE:
           return((MRESULT)TRUE) ;
           break ; // End of WM_FAILEDVALIDATE

      default:
           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           break ;
     }
   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY HPCTMEMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   HPCTMEStruct *Hpctme ;

   switch(message)
     {
      case WM_INITDLG:
           Hpctme = (HPCTMEStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCTME) ;

           hWndParent = *((HWND *)mp2)  ;
           (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;

          /*
          ** Initialize entry field control: HpcTmePcTime
          */
           WinSendDlgItemMsg(hWndDlg, HPCTMEVALFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
           if(Hpctme->HpcTmePcTime[0])
              WinSetDlgItemText(hWndDlg, HPCTMEVALFLD, Hpctme->HpcTmePcTime) ;

          /*
          ** Initialize entry field control: HpcTmeHostTime
          */
           WinSendDlgItemMsg(hWndDlg, HPCTMEHVLFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
           Hpctme->HpcTmeHostTime[0] = 0 ;

          /*
          **  Set focus on input field and return TRUE
          */
           tstSetFocus(HPCTMEVALFLD) ;
           tstReturnMR(1) ;
           break ; // End of WM_INITDLG

      case WM_CONTROL:
           switch(SHORT1FROMMP(mp1))
             {
              case HPCTMEVALFLD: // Entry field variable: "HpcTmePcTime"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
              case HPCTMEHVLFLD: // Entry field variable: "HpcTmeHostTime"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
             }
           break ; // End of WM_CONTROL

      case WM_COMMAND:
           switch(SHORT1FROMMP(mp1))
             {
              case DID_OK: // Button text: "OK"
                 Hpctme = (HPCTMEStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCTME) ;

                  /*
                  **  Query the string value in the entry field control and
                  **  move the string value to the dialog structure variable
                  */
                   {
                    CHAR szWorkBuf[13] ; // local scratch memory

                    WinQueryDlgItemText(hWndDlg, HPCTMEHVLFLD, sizeof(szWorkBuf), szWorkBuf) ;
                    strcpy(Hpctme->HpcTmeHostTime, szWorkBuf) ;
                   }
                   WinDismissDlg(hWndDlg, TRUE) ;
                   break ;

              case HPCTMECVTBUT: // Button text: "~Convert"
                   #include "HPCTME.INC"
                   break ;
             }
           break ; // End of WM_COMMAND

      case WM_CLOSE:
           WinDismissDlg(hWndDlg, FALSE) ;
           break ; // End of WM_CLOSE

      case WM_FAILEDVALIDATE:
           return((MRESULT)TRUE) ;
           break ; // End of WM_FAILEDVALIDATE

      default:
           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           break ;
     }
   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY HPCSHRMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   HPCSHRStruct *Hpcshr ;

   switch(message)
     {
      case WM_INITDLG:
           Hpcshr = (HPCSHRStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCSHR) ;

           hWndParent = *((HWND *)mp2)  ;
           (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;

          /*
          ** Initialize entry field control: HpcShrPcShort
          */
           WinSendDlgItemMsg(hWndDlg, HPCSHRVALFLD, EM_SETTEXTLIMIT, MPFROMLONG(6), 0L) ;
           {
            CHAR szWorkBuf[50] ; // local scratch memory

            if(Hpcshr->HpcShrPcShort != 0)
              {
               _itoa(Hpcshr->HpcShrPcShort, szWorkBuf, 10) ;
               WinSetDlgItemText(hWndDlg, HPCSHRVALFLD, szWorkBuf) ;
              }
           }

          /*
          ** Initialize entry field control: HpcShrHostShort
          */
           WinSendDlgItemMsg(hWndDlg, HPCSHRHVLFLD, EM_SETTEXTLIMIT, MPFROMLONG(4), 0L) ;
           Hpcshr->HpcShrHostShort[0] = 0 ;

          /*
          **  Set focus on input field and return TRUE
          */
           tstSetFocus(HPCSHRVALFLD) ;
           tstReturnMR(1) ;
           break ; // End of WM_INITDLG

      case WM_CONTROL:
           switch(SHORT1FROMMP(mp1))
             {
              case HPCSHRVALFLD: // Entry field variable: "HpcShrPcShort"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
              case HPCSHRHVLFLD: // Entry field variable: "HpcShrHostShort"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
             }
           break ; // End of WM_CONTROL

      case WM_COMMAND:
           switch(SHORT1FROMMP(mp1))
             {
              case DID_OK: // Button text: "OK"
                 Hpcshr = (HPCSHRStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCSHR) ;

                  /*
                  **  Query the string value in the entry field control and
                  **  move the string value to the dialog structure variable
                  */
                   {
                    CHAR szWorkBuf[13] ; // local scratch memory

                    WinQueryDlgItemText(hWndDlg, HPCSHRHVLFLD, sizeof(szWorkBuf), szWorkBuf) ;
                    strcpy(Hpcshr->HpcShrHostShort, szWorkBuf) ;
                   }
                   WinDismissDlg(hWndDlg, TRUE) ;
                   break ;

              case HPCSHRCVTBUT: // Button text: "~Convert"
                   #include "HPCSHR.INC"
                   break ;
             }
           break ; // End of WM_COMMAND

      case WM_CLOSE:
           WinDismissDlg(hWndDlg, FALSE) ;
           break ; // End of WM_CLOSE

      case WM_FAILEDVALIDATE:
           return((MRESULT)TRUE) ;
           break ; // End of WM_FAILEDVALIDATE

      default:
           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           break ;
     }
   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY HPCLNGMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   HPCLNGStruct *Hpclng ;

   switch(message)
     {
      case WM_INITDLG:
           Hpclng = (HPCLNGStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCLNG) ;

           hWndParent = *((HWND *)mp2)  ;
           (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;

          /*
          ** Initialize entry field control: HpcLngPcLong
          */
           WinSendDlgItemMsg(hWndDlg, HPCLNGVALFLD, EM_SETTEXTLIMIT, MPFROMLONG(11), 0L) ;
           {
            CHAR szWorkBuf[50] ; // local scratch memory

            if(Hpclng->HpcLngPcLong != 0)
              {
               _ltoa(Hpclng->HpcLngPcLong, szWorkBuf, 10) ;
               WinSetDlgItemText(hWndDlg, HPCLNGVALFLD, szWorkBuf) ;
              }
           }

          /*
          ** Initialize entry field control: HpcLngHostLong
          */
           WinSendDlgItemMsg(hWndDlg, HPCLNGHVLFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
           Hpclng->HpcLngHostLong[0] = 0 ;

          /*
          **  Set focus on input field and return TRUE
          */
           tstSetFocus(HPCLNGVALFLD) ;
           tstReturnMR(1) ;
           break ; // End of WM_INITDLG

      case WM_CONTROL:
           switch(SHORT1FROMMP(mp1))
             {
              case HPCLNGVALFLD: // Entry field variable: "HpcLngPcLong"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
              case HPCLNGHVLFLD: // Entry field variable: "HpcLngHostLong"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
             }
           break ; // End of WM_CONTROL

      case WM_COMMAND:
           switch(SHORT1FROMMP(mp1))
             {
              case DID_OK: // Button text: "OK"
                   Hpclng = (HPCLNGStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCLNG) ;

                  /*
                  **  Query the string value in the entry field control and
                  **  move the string value to the dialog structure variable
                  */
                   {
                    CHAR szWorkBuf[13] ; // local scratch memory

                    WinQueryDlgItemText(hWndDlg, HPCLNGHVLFLD, sizeof(szWorkBuf), szWorkBuf) ;
                    strcpy(Hpclng->HpcLngHostLong, szWorkBuf) ;
                   }
                   WinDismissDlg(hWndDlg, TRUE) ;
                   break ;

              case HPCLNGCVTBUT: // Button text: "~Convert"
                   #include "HPCLNG.INC"
                   break ;
             }
           break ; // End of WM_COMMAND

      case WM_CLOSE:
           WinDismissDlg(hWndDlg, FALSE) ;
           break ; // End of WM_CLOSE

      case WM_FAILEDVALIDATE:
           return((MRESULT)TRUE) ;
           break ; // End of WM_FAILEDVALIDATE

      default:
           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           break ;
     }
   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY HPCSPFMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   HPCSPFStruct *Hpcspf ;

   switch(message)
     {
      case WM_INITDLG:
           Hpcspf = (HPCSPFStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCSPF) ;

           hWndParent = *((HWND *)mp2)  ;
           (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;

          /*
          ** Initialize entry field control: HpcSpfPcFloat
          */
           WinSendDlgItemMsg(hWndDlg,HPCSPFVALFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
           if(Hpcspf->HpcSpfPcFloat[0])
              WinSetDlgItemText(hWndDlg, HPCSPFVALFLD, Hpcspf->HpcSpfPcFloat) ;

          /*
          ** Initialize entry field control: HpcSpfHostFloat
          */
           WinSendDlgItemMsg(hWndDlg, HPCSPFHVLFLD, EM_SETTEXTLIMIT, MPFROMLONG(8), 0L) ;
           Hpcspf->HpcSpfHostFloat[0] = 0 ;

          /*
          **  Set focus on input field and return TRUE
          */
           tstSetFocus(HPCSPFVALFLD) ;
           tstReturnMR(1) ;
           break ; // End of WM_INITDLG

      case WM_CONTROL:
           switch(SHORT1FROMMP(mp1))
             {
              case HPCSPFVALFLD: // Entry field variable: "HpcSpfPcFloat"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
              case HPCSPFHVLFLD: // Entry field variable: "HpcSpfHostFloat"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
             }
           break ; // End of WM_CONTROL

      case WM_COMMAND:
           switch(SHORT1FROMMP(mp1))
             {
              case DID_OK: // Button text: "OK"
                 Hpcspf = (HPCSPFStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCSPF) ;

                  /*
                  **  Query the string value in the entry field control and
                  **  move the string value to the dialog structure variable
                  */
                   {
                    CHAR szWorkBuf[13] ; // local scratch memory

                    WinQueryDlgItemText(hWndDlg, HPCSPFHVLFLD, sizeof(szWorkBuf), szWorkBuf) ;
                    strcpy(Hpcspf->HpcSpfHostFloat, szWorkBuf) ;
                   }
                   WinDismissDlg(hWndDlg, TRUE) ;
                   break ;

              case HPCSPFCVTBUT: // Button text: "~Convert"
                   #include "HPCSPF.INC"
                   break ;
             }
           break ; // End of WM_COMMAND

      case WM_CLOSE:
           WinDismissDlg(hWndDlg, FALSE) ;
           break ; // End of WM_CLOSE

      case WM_FAILEDVALIDATE:
           return((MRESULT)TRUE) ;
           break ; // End of WM_FAILEDVALIDATE

      default:
           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           break ;
     }
   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY HPCDPFMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   HPCDPFStruct *Hpcdpf ;

   switch(message)
     {
      case WM_INITDLG:
           Hpcdpf = (HPCDPFStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCDPF) ;

           hWndParent = *((HWND *)mp2)  ;
           (VOID)cwCenter(hWndDlg, (HWND)hWndParent) ;

          /*
          ** Initialize entry field control: HpcDpfPcDouble
          */
           WinSendDlgItemMsg(hWndDlg, HPCDPFVALFLD, EM_SETTEXTLIMIT, MPFROMLONG(16), 0L) ;
           if(Hpcdpf->HpcDpfPcDouble[0])
              WinSetDlgItemText(hWndDlg, HPCDPFVALFLD, Hpcdpf->HpcDpfPcDouble) ;

          /*
          ** Initialize entry field control: HpcDpfHostDouble
          */
           WinSendDlgItemMsg(hWndDlg, HPCDPFHVLFLD, EM_SETTEXTLIMIT, MPFROMLONG(16), 0L) ;
           Hpcdpf->HpcDpfHostDouble[0] = 0 ;

          /*
          **  Set focus on input field and return TRUE
          */
           tstSetFocus(HPCDPFVALFLD) ;
           tstReturnMR(1) ;
           break ; // End of WM_INITDLG

      case WM_CONTROL:
           switch(SHORT1FROMMP(mp1))
             {
              case HPCDPFVALFLD: // Entry field variable: "HpcDpfPcDouble"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
              case HPCDPFHVLFLD: // Entry field variable: "HpcDpfHostDouble"
                   switch(SHORT2FROMMP(mp1)) // switch on Notification Code
                     {
                      case EN_SETFOCUS:  // Entry field is receiving the focus
                           break ;

                      case EN_KILLFOCUS: // Entry field is losing the focus
                           break ;

                      default: // Default other messages
                           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                           break ;
                     }
                   break ;
             }
           break ; // End of WM_CONTROL

      case WM_COMMAND:
           switch(SHORT1FROMMP(mp1))
             {
              case DID_OK: // Button text: "OK"
                 Hpcdpf = (HPCDPFStruct *)WinQueryWindowULong(hWndClient, OFFSET_HPCDPF) ;

                  /*
                  ** Query the string value in the entry field control and
                  ** move the string value to the dialog structure variable
                  */
                   {
                    CHAR szWorkBuf[21] ; // local scratch memory

                    WinQueryDlgItemText(hWndDlg, HPCDPFHVLFLD, sizeof(szWorkBuf), szWorkBuf) ;
                    strcpy(Hpcdpf->HpcDpfHostDouble, szWorkBuf) ;
                   }
                   WinDismissDlg(hWndDlg, TRUE) ;
                   break ;

              case HPCDPFCVTBUT: // Button text: "~Convert"
                   #include "HPCDPF.INC"
                   break ;
             }
           break ; // End of WM_COMMAND

      case WM_CLOSE:
           WinDismissDlg(hWndDlg, FALSE) ;
           break ; // End of WM_CLOSE

      case WM_FAILEDVALIDATE:
           return((MRESULT)TRUE) ;
           break ; // End of WM_FAILEDVALIDATE

      default:
           return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           break ;
     }
   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  cwRegisterClass Function
**
**  The following function registers all the classes of all the windows
**  associated with this application. The function returns TRUE if it is
**  successful, otherwise it returns FALSE.
*/
 INT cwRegisterClass(VOID)
 {
   INT rc ;

   WinLoadString(hAB, 0, IDS_APP_NAME, 80, szAppName) ; // Program name

   rc = WinRegisterClass(hAB,             // Anchor block handle
                        (PCH)szAppName,   // Name of class being registered
                        (PFNWP)WndProc,   // Window procedure for class
                        CS_SIZEREDRAW ,
                        12*sizeof(char*)) ;
   if (rc == FALSE) return(FALSE) ;

   return(TRUE) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  cwCreateWindow Function
**
**  The following function is used to create a window (the main window,
**  a child window, an icon window, etc.) and set it's initial size and
**  position. It returns the handle to the frame window.
**
*/
 HWND cwCreateWindow
 (
   HWND   hWndParent,  // Handle to the parent of the window to be created
   ULONG  ctldata,     // Frame control flags for the window
   PCH    appname,     // Class name of the window
   PCH    title,       // Title of the window
   ULONG  ResID,       // Resource id value
   INT    x,           // Initial horizontal and vertical location
   INT    y,           //
   INT    cx,          // Initial width and height of the window
   INT    cy,          //
   PHWND  hWndClient,  // Handle to the client area of the window
   ULONG  lfStyle,     // Frame window style
   USHORT uSizeStyle   // User defined size and location flags
 )
 {
   ULONG  rc ;            // Accepts return codes from function calls
   HWND   hWndFrame ;     // Local handle to created window frame
   ULONG  SizeStyle ;     // Local window positioning options
   CHAR   MsgBuffer[80] ; // Buffer for error messages
   HPS    hPS ;           // Handle to a presentation space
   int    xmod, ymod ;    // Modifiers for sizing
   #define DLGXMOD  4     // Dialog units X modulo
   #define DLGYMOD  8     // Dialog units Y modulo
   FONTMETRICS fm ;       // Structure for determing modifiers

  /*
  **  Create the frame window
  */
   hWndFrame = WinCreateStdWindow(hWndParent,  // Parent of window
                                  lfStyle,     // Frame window style
                                  &ctldata,    // Frame flags
                                  appname,     // Class name
                                  title,       // Window title
                                  0L,          // Client window style
                                  0,           // Module for resources
                                  ResID,       // Resource id
                                  (HWND *)hWndClient) ; // Client handle

  /*
  **  If hWndFrame is NULL, an error occured when opening the window,
  **  notify the user and exit this function
  */
   if(hWndFrame == 0)
   {
     WinLoadString(hAB, 0, IDS_ERR_WINDOW_CREATE, 80, MsgBuffer) ;
     WinMessageBox(HWND_DESKTOP, hWndParent, MsgBuffer,
                   0, 0, MB_OK|MB_ICONEXCLAMATION) ;
     return ((HWND)0) ;
   }

  /*
  **  Set up size options
  */
   SizeStyle = SWP_ACTIVATE | SWP_ZORDER | uSizeStyle ;

  /*
  **  If the height, width, intial x or initial y values are non-zero,
  **  then we will need to set up the modifiers for size and location
  */
   if((cx > 0) || (cy > 0) || (x != 0)  || (y != 0))
   {
     hPS = WinGetPS(HWND_DESKTOP) ;
     GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm) ;
     xmod = (INT)fm.lAveCharWidth ;
     ymod = (INT)fm.lMaxBaselineExt ;
     WinReleasePS(hPS) ;
   }

  /*
  **  If either the width or the height are non-zero, then the size of the
  **  created window will be changed, set SizeStyle accordingly
  */
   if((cx > 0) || (cy > 0) || (x != 0) || (y != 0))
   {
     SizeStyle |= SWP_SIZE ;
     SizeStyle |= SWP_MOVE ;
   }

  /*
  **  Set the size and position of the window and activate it
  */
   rc = WinSetWindowPos(hWndFrame, HWND_TOP,
                        ((x * xmod)/DLGXMOD),
                        ((y * ymod)/DLGYMOD),
                        ((cx * xmod)/DLGXMOD),
                        ((cy * ymod)/DLGYMOD), SizeStyle) ;

  /*
  **  If rc is not set to TRUE then WinSetWindowPos failed, notify the user
  **  and exit this function
  */
   if(!rc)
   {
     WinLoadString(hAB, 0, IDS_ERR_WINDOW_POS, 80, MsgBuffer) ;
     WinMessageBox(HWND_DESKTOP, hWndParent, MsgBuffer,
                   0, 0, MB_OK|MB_ICONEXCLAMATION) ;
     return((HWND)0) ;
   }

  /*
  **  Return the handle to the frame window
  */
   return(hWndFrame) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  cwCenter Function
**
**  Centers a dialog box on the client area of the caller
**
**  hWnd       - handle of the window to be centered
**  hWndParent - handle of the window on which to center
**
*/
 INT cwCenter
 (
   HWND hWnd       ,
   HWND hWndParent
 )
 {
   LONG   SrcX, SrcY ;                // Center of parent
   LONG   x, y ;                      // Destination points
   SWP    DlgSwp, ParentSwp ;         // Set window position structures
   LONG   ScreenWidth, ScreenHeight ; // Dimensions of the DESKTOP
   POINTL pt ;                        // Point

  /*
  **  Determine the width and height of the DESKTOP so the dialog box
  **  will not be positioned to a point off of the screen.
  */
   ScreenWidth  = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) ;
   ScreenHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) ;

  /*
  **  Query width and depth of dialog box
  */
   WinQueryWindowPos(hWnd, (PSWP)&DlgSwp) ;

  /*
  **  Query width and depth of caller
  */
   WinQueryWindowPos(hWndParent, (PSWP)&ParentSwp) ;

  /*
  **  Map the point parent points to the Desktop
  */
   pt.x = ParentSwp.x ;
   pt.y = ParentSwp.y ;

  /*
  **  Convert the point from having our window as the origin to having
  **  the DESKTOP as the origin
  */
   WinMapWindowPoints(hWndParent, HWND_DESKTOP, &pt, 1) ;

   SrcX = pt.x + (ParentSwp.cx / 2) ;
   SrcY = pt.y + (ParentSwp.cy / 2) ;

  /*
  **  Determine the point to move the dialog box to
  */
   x = (SrcX - (DlgSwp.cx / 2)) ;
   y = (SrcY - (DlgSwp.cy / 2)) ;

  /*
  **  If either point is less than zero, then set that point to zero
  **  so the dialog box will not be positoned off of the window
  */
   x = (x < 0L) ? 0L : x ;
   y = (y < 0L) ? 0L : y ;

  /*
  **  If either point plus the height or width of the dialog box is
  **  greater than the height or width of the screen adjust point
  */
   if ((x + DlgSwp.cx) > ScreenWidth)  x = ScreenWidth - DlgSwp.cx ;
   if ((y + DlgSwp.cy) > ScreenHeight) y = ScreenHeight - DlgSwp.cy ;

  /*
  **  Move the dialog box
  */
   return(WinSetWindowPos(hWnd, HWND_TOP, x, y, 0, 0, SWP_MOVE)) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  This function allocates memory for dialog box variables and initializes
**  the state of any initially selected radio buttons and check boxes.
*/
 INT cwSetInitDlgStatus(HWND hWnd)
 {
   PCHDATStruct *Pchdat ;
   PCHTMEStruct *Pchtme ;
   PCHSHRStruct *Pchshr ;
   PCHLNGStruct *Pchlng ;
   PCHSPFStruct *Pchspf ;
   PCHDPFStruct *Pchdpf ;
   HPCDATStruct *Hpcdat ;
   HPCTMEStruct *Hpctme ;
   HPCSHRStruct *Hpcshr ;
   HPCLNGStruct *Hpclng ;
   HPCSPFStruct *Hpcspf ;
   HPCDPFStruct *Hpcdpf ;

   OFFSETOF(Pchdat) = 0 ;
   DosAllocMem(((PPVOID)&Pchdat), sizeof(PCHDATStruct), fALLOC) ;
   memset(Pchdat, 0x00, sizeof(PCHDATStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_PCHDAT, (ULONG)Pchdat) ;

   OFFSETOF(Pchtme) = 0 ;
   DosAllocMem(((PPVOID)&Pchtme), sizeof(PCHTMEStruct), fALLOC) ;
   memset(Pchtme, 0x00, sizeof(PCHTMEStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_PCHTME, (ULONG)Pchtme) ;

   OFFSETOF(Pchshr) = 0 ;
   DosAllocMem(((PPVOID)&Pchshr), sizeof(PCHSHRStruct), fALLOC) ;
   memset(Pchshr, 0x00, sizeof(PCHSHRStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_PCHSHR, (ULONG)Pchshr) ;

   OFFSETOF(Pchlng) = 0 ;
   DosAllocMem(((PPVOID)&Pchlng), sizeof(PCHLNGStruct), fALLOC) ;
   memset(Pchlng, 0x00, sizeof(PCHLNGStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_PCHLNG, (ULONG)Pchlng) ;

   OFFSETOF(Pchspf) = 0 ;
   DosAllocMem(((PPVOID)&Pchspf), sizeof(PCHSPFStruct), fALLOC) ;
   memset(Pchspf, 0x00, sizeof(PCHSPFStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_PCHSPF, (ULONG)Pchspf) ;

   OFFSETOF(Pchdpf) = 0 ;
   DosAllocMem(((PPVOID)&Pchdpf), sizeof(PCHDPFStruct), fALLOC) ;
   memset(Pchdpf, 0x00, sizeof(PCHDPFStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_PCHDPF, (ULONG)Pchdpf) ;

   OFFSETOF(Hpcdat) = 0 ;
   DosAllocMem(((PPVOID)&Hpcdat), sizeof(HPCDATStruct), fALLOC) ;
   memset(Hpcdat, 0x00, sizeof(HPCDATStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_HPCDAT, (ULONG)Hpcdat) ;

   OFFSETOF(Hpctme) = 0 ;
   DosAllocMem(((PPVOID)&Hpctme), sizeof(HPCTMEStruct), fALLOC) ;
   memset(Hpctme, 0x00, sizeof(HPCTMEStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_HPCTME, (ULONG)Hpctme) ;

   OFFSETOF(Hpcshr) = 0 ;
   DosAllocMem(((PPVOID)&Hpcshr), sizeof(HPCSHRStruct), fALLOC) ;
   memset(Hpcshr, 0x00, sizeof(HPCSHRStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_HPCSHR, (ULONG)Hpcshr) ;

   OFFSETOF(Hpclng) = 0 ;
   DosAllocMem(((PPVOID)&Hpclng), sizeof(HPCLNGStruct), fALLOC) ;
   memset(Hpclng, 0x00, sizeof(HPCLNGStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_HPCLNG, (ULONG)Hpclng) ;

   OFFSETOF(Hpcspf) = 0 ;
   DosAllocMem(((PPVOID)&Hpcspf), sizeof(HPCSPFStruct), fALLOC) ;
   memset(Hpcspf, 0x00, sizeof(HPCSPFStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_HPCSPF, (ULONG)Hpcspf) ;

   OFFSETOF(Hpcdpf) = 0 ;
   DosAllocMem(((PPVOID)&Hpcdpf), sizeof(HPCDPFStruct), fALLOC) ;
   memset(Hpcdpf, 0x00, sizeof(HPCDPFStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_HPCDPF, (ULONG)Hpcdpf) ;

   return(0) ;
 }

/* ------------------------------------------------------------------------ */

 INT cwFreeDlgMemory
 (
   HWND hWnd
 )
 {
   PCHDATStruct *Pchdat ;
   PCHTMEStruct *Pchtme ;
   PCHSHRStruct *Pchshr ;
   PCHLNGStruct *Pchlng ;
   PCHSPFStruct *Pchspf ;
   PCHDPFStruct *Pchdpf ;
   HPCDATStruct *Hpcdat ;
   HPCTMEStruct *Hpctme ;
   HPCSHRStruct *Hpcshr ;
   HPCLNGStruct *Hpclng ;
   HPCSPFStruct *Hpcspf ;
   HPCDPFStruct *Hpcdpf ;

   Pchdat = (PCHDATStruct *)WinQueryWindowULong(hWnd, OFFSET_PCHDAT) ;
   DosFreeMem((PVOID)(Pchdat)) ;
   Pchtme = (PCHTMEStruct *)WinQueryWindowULong(hWnd, OFFSET_PCHTME) ;
   DosFreeMem((PVOID)(Pchtme)) ;
   Pchshr = (PCHSHRStruct *)WinQueryWindowULong(hWnd, OFFSET_PCHSHR) ;
   DosFreeMem((PVOID)(Pchshr)) ;
   Pchlng = (PCHLNGStruct *)WinQueryWindowULong(hWnd, OFFSET_PCHLNG) ;
   DosFreeMem((PVOID)(Pchlng)) ;
   Pchspf = (PCHSPFStruct *)WinQueryWindowULong(hWnd, OFFSET_PCHSPF) ;
   DosFreeMem((PVOID)(Pchspf)) ;
   Pchdpf = (PCHDPFStruct *)WinQueryWindowULong(hWnd, OFFSET_PCHDPF) ;
   DosFreeMem((PVOID)(Pchdpf)) ;
   Hpcdat = (HPCDATStruct *)WinQueryWindowULong(hWnd, OFFSET_HPCDAT) ;
   DosFreeMem((PVOID)(Hpcdat)) ;
   Hpctme = (HPCTMEStruct *)WinQueryWindowULong(hWnd, OFFSET_HPCTME) ;
   DosFreeMem((PVOID)(Hpctme)) ;
   Hpcshr = (HPCSHRStruct *)WinQueryWindowULong(hWnd, OFFSET_HPCSHR) ;
   DosFreeMem((PVOID)(Hpcshr)) ;
   Hpclng = (HPCLNGStruct *)WinQueryWindowULong(hWnd, OFFSET_HPCLNG) ;
   DosFreeMem((PVOID)(Hpclng)) ;
   Hpcspf = (HPCSPFStruct *)WinQueryWindowULong(hWnd, OFFSET_HPCSPF) ;
   DosFreeMem((PVOID)(Hpcspf)) ;
   Hpcdpf = (HPCDPFStruct *)WinQueryWindowULong(hWnd, OFFSET_HPCDPF) ;
   DosFreeMem((PVOID)(Hpcdpf)) ;

   return(0) ;
 }

/* ------------------------------------------------------------------------ */

 void lmemset (void FAR *memptr, CHAR value, INT size)
 {
   char FAR *chrptr = memptr ;

   while (size--) *chrptr++ = value ;
 }

/* ------------------------------------------------------------------------ */
