/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** \----------------------------------------------------------------------/
**
**  Header   : ZDTPROTO.H
**  Author   : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 17 Jul 1992
**  Updated  : 16 Nov 1993
**  Version  : 4.20
**  Content  : Date & Time Services prototypes
**
*/
 #ifndef zdtPROTOTYPES
 #define zdtPROTOTYPES 0

 #ifdef __cplusplus
 extern "C" {
 #endif

 VOID    EXPENTRY zdtLibraryVersion ( zPLIBVERS ) ;
 VOID    EXPENTRY zdtSetLibraryName ( PSZ ) ;
 zSIGNAL EXPENTRY zdtRegisterSignal ( zSIGHAND ) ;

 PSZ         EXPENTRY zdtSetLanguage ( zdtLANGUAGE ) ;
 PSZ         EXPENTRY zdtGetLangId   ( zdtLANGUAGE ) ;
 PSZ         EXPENTRY zdtCurLangId   ( VOID ) ;
 PSZ         EXPENTRY zdtDefLangId   ( VOID ) ;
 zdtLANGUAGE EXPENTRY zdtLanguage    ( PSZ ) ;

 zdtDATE EXPENTRY zdtNewDate      ( zdtYEAR, zdtMONTH, zdtDAY ) ;
 zdtDATE EXPENTRY zdtToday        ( VOID ) ;
 zdtDATE EXPENTRY zdtUtcToday     ( VOID ) ;
 zdtDATE EXPENTRY zdtStringAsDate ( PSZ ) ;
 zdtDATE EXPENTRY zdtAddDays      ( zdtDATE, zdtDAYS ) ;
 zdtDATE EXPENTRY zdtAddToDate    ( zdtDATE, ULONG, ULONG, ULONG ) ;

 zdtDAYS EXPENTRY zdtDaysBetween ( zdtDATE, zdtDATE ) ;

 zdtYEAR    EXPENTRY zdtYear    ( zdtDATE ) ;
 zdtMONTH   EXPENTRY zdtMonth   ( zdtDATE ) ;
 zdtDAY     EXPENTRY zdtDay     ( zdtDATE ) ;
 zdtWEEKDAY EXPENTRY zdtWeekday ( zdtDATE ) ;

 zdtWEEK EXPENTRY zdtWeekOfYear ( zdtDATE ) ;

 zdtDAYS    EXPENTRY zdtAsJulian    ( zdtDATE ) ;
 zdtDAYS    EXPENTRY zdtDayOfYear   ( zdtDATE ) ;
 zdtDAYS    EXPENTRY zdtDaysInYear  ( zdtYEAR ) ;
 zdtDAYS    EXPENTRY zdtDaysInMonth ( zdtYEAR, zdtMONTH ) ;

 BOOL EXPENTRY zdtIsLeapYear   ( zdtYEAR ) ;
 BOOL EXPENTRY zdtStringIsDate ( PSZ ) ;
 BOOL EXPENTRY zdtIsValidDate  ( zdtYEAR, zdtMONTH, zdtDAY ) ;

 VOID  EXPENTRY zdtDiscardDate ( zdtDATE ) ;

 PSZ EXPENTRY zdtWeekdayName     ( zdtDATE, PSZ ) ;
 PSZ EXPENTRY zdtWeekdayAsString ( zdtWEEKDAY, PSZ ) ;
 PSZ EXPENTRY zdtMonthName       ( zdtDATE, PSZ ) ;
 PSZ EXPENTRY zdtMonthAsString   ( zdtMONTH, PSZ ) ;
 PSZ EXPENTRY zdtDateAsString    ( zdtDATE, PSZ ) ;
 PSZ EXPENTRY zdtFormatDate      ( zdtDATE, PSZ, CHAR, PSZ, ... ) ;

 zdtTIME EXPENTRY zdtNewTime      ( zdtHOURS, zdtMINUTES, zdtSECONDS ) ;
 zdtTIME EXPENTRY zdtNow          ( VOID ) ;
 zdtTIME EXPENTRY zdtUtcNow       ( VOID ) ;
 zdtTIME EXPENTRY zdtStringAsTime ( PSZ ) ;
 zdtTIME EXPENTRY zdtAddHours     ( zdtTIME, zdtHOURS, zdtDAYS * ) ;
 zdtTIME EXPENTRY zdtAddMinutes   ( zdtTIME, zdtMINUTES, zdtDAYS * ) ;
 zdtTIME EXPENTRY zdtAddSeconds   ( zdtTIME, zdtSECONDS, zdtDAYS * ) ;

 zdtSECONDS EXPENTRY zdtSecondsBetween ( zdtTIME, zdtTIME ) ;

 zdtHOURS   EXPENTRY zdtHours   ( zdtTIME ) ;
 zdtMINUTES EXPENTRY zdtMinutes ( zdtTIME ) ;
 zdtSECONDS EXPENTRY zdtSeconds ( zdtTIME ) ;

 zdtMINUTES EXPENTRY zdtMinutesInTime ( zdtTIME ) ;
 zdtSECONDS EXPENTRY zdtSecondsInTime ( zdtTIME ) ;

 BOOL EXPENTRY zdtStringIsTime ( PSZ ) ;
 BOOL EXPENTRY zdtIsValidTime  ( zdtHOURS, zdtMINUTES, zdtSECONDS ) ;

 VOID  EXPENTRY zdtDiscardTime ( zdtTIME ) ;

 PSZ EXPENTRY zdtTimeAsString ( zdtTIME, PSZ ) ;
 PSZ EXPENTRY zdtFormatTime   ( zdtTIME, PSZ, CHAR, PSZ, ... ) ;

 BOOL EXPENTRY zdtIsValidZone      ( zdtZONE ) ;
 BOOL EXPENTRY zdtComputeLocalTime ( zdtLOCALDT *, zdtLOCALDT * ) ;

 zdtZONE EXPENTRY zdtLocalZone ( VOID ) ;

 #ifdef __cplusplus
 } /* extern "C" */
 #endif

 #endif
