/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** \----------------------------------------------------------------------/
**
**  Header   : ZDTDEFS.H
**  Author   : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 03 Jul 1992
**  Updated  : 01 Sep 1993
**  Version  : 4.12
**  Content  : Date & Time Services definitions
**
*/
 #ifndef zdtDEFINITIONS
 #define zdtDEFINITIONS 0

 #include <zdtrsrcs.rch>

/*
**  Global Values
*/
 #define  zdtZPREFIX  "ZDT"
 #define  zdtDLLNAME  "FMZDTFUN" // The name of THIS library

 #define  zdtRESFSIZE         8  // Size of Resource File name
 #define  zdtINVALID         -1  // Invalid value

 #define  zdtNOTAVAILABLE  ((PSZ)0)      //  Null string pointer
 #define  zdtNOTFORMATTED  ((PSZ)0)      //  Null string pointer

/*
**  Date and Time Values
*/
 #define  zdtBASEYEAR       1860  // Base for year values
 #define  zdtLASTYEAR       2100  // Higher value for years

 #define  zdtDAYSINYEAR      365  // Days in a year
 #define  zdtDAYSINLEAP      366  // Days in a leap year
 #define  zdtMONTHSINYEAR     12  // Months in a year

 #define  zdtSECONDSINDAY    86400  // Seconds in one day
 #define  zdtSECONDSINHOUR    3600  // Seconds in one hour
 #define  zdtSECONDSINMINUTE    60  // Seconds in one minute
 #define  zdtMINUTESINHOUR      60  // Minutes in one hour
 #define  zdtHOURSINDAY         24  // Hours in one day

 #define  zdtVALIDPERIOD   (zdtLASTYEAR - zdtBASEYEAR)

 #define  zdtEASTLIMIT        +720  // East limit for timezones (in minutes)
 #define  zdtWESTLIMIT        -720  // West limit for timezones (in minutes)

/*
**  Months and weekdays
*/
 #define JANUARY     1
 #define FEBRUARY    2
 #define MARCH       3
 #define APRIL       4
 #define MAY         5
 #define JUNE        6
 #define JULY        7
 #define AUGUST      8
 #define SEPTEMBER   9
 #define OCTOBER    10
 #define NOVEMBER   11
 #define DECEMBER   12

 #define MONDAY      1
 #define TUESDAY     2
 #define WEDNESDAY   3
 #define THURSDAY    4
 #define FRIDAY      5
 #define SATURDAY    6
 #define SUNDAY      7

/*
**  Supported languages
*/
 #define zdtDEFLANG      0   // Default value. Always first in set.
 #define zdtITALANG      1   // Italian
 #define zdtENGLANG      2   // English
 #define zdtBPOLANG      3   // Brazilian Portuguese
 #define zdtDEULANG      4   // German
 #define zdtSVELANG      5   // Svedish
 #define zdtESPLANG      6   // Spanish
 #define zdtFRALANG      7   // French
 #define zdtDUTLANG      8   // Dutch
 #define zdtDANLANG      9   // Danish
 #define zdtLSTLANG     10   // Special value. Always last in set.

/*
**  NLS Values
*/
 #define  zdtFSTLANG  (zdtDEFLANG + 1) // First supported language
 #define  zdtSTRSIZE        256        // Buffer size for loading NLS strings
 #define  zdtNOSEPARATOR   '\0'        // No date or time separator
 #define  zdtESCAPE         '%'        // Escape character
 #define  zdtNOID        ((PSZ)0)      // No language id available

 #endif
