/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Include : TSTOFFST.INC
**  Authors : Alessandro Cavallini (CAVALLI at ROMEPPC)
**            Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created : 18 Sep 1992
**  Updated : 01 Sep 1993
**  Version : 4.12
**  Content : Called in WM_COMMAND (case TMEZONOFFBUT)
**
*/
{
   ULONG n ;
   BOOL done ;
   zdtLOCALDT in, out ;
   CHAR szTempBuf[80] ; // Local scratch memory

   Tmezon = (TMEZONStruct *)WinQueryWindowULong(hWndClient, OFFSET_TMEZON) ;

  /*
  ** Query the string value in the entry field control and
  ** move the string value to the dialog structure variable
  */
   n = WinQueryDlgItemText(hWndDlg, TMEZONHRSFLD, 80, szTempBuf) ;
   if (n != 0)
     Tmezon->TmeZonUCTHours = atol(szTempBuf) ;
   else
     Tmezon->TmeZonUCTHours = 0 ;

   n = WinQueryDlgItemText(hWndDlg, TMEZONMINFLD, 80, szTempBuf) ;
   if (n != 0)
     Tmezon->TmeZonUCTMinutes = atol(szTempBuf) ;
   else
     Tmezon->TmeZonUCTMinutes = 0 ;

   n = WinQueryDlgItemText(hWndDlg, TMEZONSECFLD, 80, szTempBuf) ;
   if (n != 0)
     Tmezon->TmeZonUCTSeconds = atol(szTempBuf) ;
   else
     Tmezon->TmeZonUCTSeconds = 0 ;

   n = WinQueryDlgItemText(hWndDlg, TMEZONOFFFLD, 80, szTempBuf) ;
   if (n != 0)
     Tmezon->TmeZonOffset = atol(szTempBuf) ;
   else
     Tmezon->TmeZonOffset = 0 ;

  /*
  **  Create time from input data and compute time corresponding
  **  to the new offset. Use today's date.
  */
   in.date = zdtToday() ;
   in.time = zdtNewTime( Tmezon->TmeZonUCTHours,
                        Tmezon->TmeZonUCTMinutes,
                        Tmezon->TmeZonUCTSeconds ) ;

   in.zone = 0 ;
   out.zone = Tmezon->TmeZonOffset * zdtMINUTESINHOUR ;

  /*
  ** If wrong input data, clear output data
  */
   done = TRUE ;
   if (in.time == zdtINVALID)
   {
     WinLoadString(hAB, 0, tstERR_INVALIDTIME, 80, szTempBuf) ;
     done = FALSE ;
   }
   if (!zdtIsValidZone(out.zone))
   {
     WinLoadString(hAB, 0, tstERR_INVALIDZONE, 80, szTempBuf) ;
     done = FALSE ;
   }
   if (done)
   {
     done = zdtComputeLocalTime(&in,&out) ;

     if (done)
     {
       Tmezon->TmeZonLocalHours   = zdtHours(out.time) ;
       Tmezon->TmeZonLocalMinutes = zdtMinutes(out.time) ;
       Tmezon->TmeZonLocalSeconds = zdtSeconds(out.time) ;

       sprintf(szTempBuf,"%02ld",Tmezon->TmeZonLocalHours) ;
       WinSetDlgItemText(hWndDlg, TMEZONHR2FLD, szTempBuf) ;

       sprintf(szTempBuf,"%02ld",Tmezon->TmeZonLocalMinutes) ;
       WinSetDlgItemText(hWndDlg, TMEZONMI2FLD, szTempBuf) ;

       sprintf(szTempBuf,"%02ld",Tmezon->TmeZonLocalSeconds) ;
       WinSetDlgItemText(hWndDlg, TMEZONSE2FLD, szTempBuf) ;
     }
   }
   else
   {
     WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, szTempBuf,
                   0, 0, MB_OK|MB_ICONEXCLAMATION);

     Tmezon->TmeZonLocalHours   = 0 ;
     Tmezon->TmeZonLocalMinutes = 0 ;
     Tmezon->TmeZonLocalSeconds = 0 ;

     szTempBuf[0] = '\0' ;
     WinSetDlgItemText(hWndDlg, TMEZONHR2FLD, szTempBuf) ;
     WinSetDlgItemText(hWndDlg, TMEZONMI2FLD, szTempBuf) ;
     WinSetDlgItemText(hWndDlg, TMEZONSE2FLD, szTempBuf) ;
   }
}
