/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Module  : DTEINF.C
**  Author  : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created : 15 Jul 1992
**  Updated : 02 Sep 1993
**  Version : 4.12
**  Content : Sample program for FMZDTFUN.DLL functions
**
*/
 #define EXTERN

 #include <dteinf.h>
 #include <zzzlogo.h>

/* ------------------------------------------------------------------------ */

/*
**  Presentation Manager Program Main Body
**
**  The following routine is the Presentation Manager program Main Body.
**  The Main Body of a PM program is concerned with associating the
**  application with the Presentation Manager system, creating its
**  message queue, registering and displaying its main window, servicing
**  its message queue during the time that the application is active,
**  and disassociating the application from PM when the user is finished
**  with the application. The remaining parts of this source module that
**  are concerned with the Presentation Manager are the application's
**  window procedures (main window procedure, child window procedures,
**  and dialog window procedures) that process the messages associated
**  with the application's various windows.
**
*/
 int main(int argc, char *argv[])
 {
   QMSG qmsg ; // MSG structure to store your messages
   PID  pid  ; // Process identifier for adding name to switch list
   TID  tid  ; // Thread identifier

   static CHAR szTitle[17] ;

   argc = argc ; // Suppress compiler warning - can remove if argc and argv
   argv = argv ; // are referenced by user-supplied code.

  /*
  **  The WinInitialize routine initializes the Presentation Manager
  **  facilities for use by this application and returns a handle to the
  **  anchor block assigned to the application by PM.
  */
   if ((hAB = WinInitialize(0)) == 0) return(FALSE) ;

  /*
  **  The WinCreateMsgQueue call creates a message queue for this application
  */
   if ((hMQ = WinCreateMsgQueue(hAB, 0)) == 0) return(FALSE) ;

  /*
  **  The following function registers the classes of all application windows
  */
   if (!cwRegisterClass()) return(FALSE) ;

  /*
  **  The CreateWindow function creates a frame window for this application's
  **  top window, and set the window's size and location as appropriate.
  */
   WinLoadString(hAB, 0, IDS_TITLE, 17, szTitle) ;
   hWndFrame = cwCreateWindow((HWND)HWND_DESKTOP,
                              FCF_TITLEBAR     |
                              FCF_SYSMENU      |
                              FCF_DLGBORDER    |
                              FCF_MENU         |
                              FCF_ACCELTABLE   ,
                              szAppName,
                              szTitle,
                              ID_DTEINF,
                              112, 93,
                              136, 23,
                              &hWndClient,
                              0L, SWP_SHOW) ;

   if (hWndFrame == 0) return(FALSE) ;

   cwCenter(hWndFrame, HWND_DESKTOP) ;  // Center window on desktop

  /*
  **  The following inline routine fills out the application's switch control
  **  structure with the appropriate information to add the application's
  **  name to the OS/2 Task Manager List, a list of the jobs currently
  **  running on the computer.
  */
   WinQueryWindowProcess(hWndFrame, &pid, &tid) ;

   Swctl.hwnd = hWndFrame ;                         // Frame window handle
   Swctl.idProcess = pid ;                          // Process identifier
   Swctl.uchVisibility = SWL_VISIBLE ;              // visibility
   Swctl.fbJump = SWL_JUMPABLE ;                    // Jump indicator
   strcpy(Swctl.szSwtitle, szTitle) ;               // Frame window title
   hSwitch = WinAddSwitchEntry(&Swctl) ;

  /*
  **  The following is the message loop for the application.
  */
   while (WinGetMsg(hAB, (PQMSG)&qmsg, 0, 0, 0))
   {
     WinDispatchMsg(hAB,(PQMSG)&qmsg) ;
   }

  /*
  **  Perform clean up before exiting application.
  **  The following routine destroys the application's frame window (which
  **  also destroys its child windows), destroys its message queue, and
  **  disassociates the application from the Presentation Manager system.
  */
   WinDestroyWindow(hWndFrame) ; // Destroy the frame window
   WinDestroyMsgQueue(hMQ) ;     // Destroy this application's message queue
   WinTerminate(hAB) ;           // Terminate this application's use of the
                                 // Presentation Manager resources
   return (0) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Main Window Procedure
**
**  This procedure provides service routines for the general PM events
**  (messages) that PM sends to the window, as well as the user
**  initiated events (messages) that are generated when the user selects
**  the action bar and pulldown menu controls or the corresponding
**  keyboard accelerators.
**
**  The SWITCH statement shown below distributes the window messages to
**  the respective message service routines, which are set apart by the
**  CASE statements. The window procedures must provide an appropriate
**  service routine for its end user initiated messages, as well as the
**  general PM messages (like the WM_CLOSE message). If a message is
**  sent to this procedure for which there is no programmed CASE clause
**  (i.e., no service routine), the message is defaulted to the
**  WinDefWindowProc function, where it is disposed of by PM.
**
*/
 MRESULT EXPENTRY WndProc
 (
   HWND   hWnd    ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   HPS   hPS     ;   // Handle for the Presentation Space
   RECTL rClient ;   // Handle to rectangle formed by client area

   switch(message)
   {
     case WM_INITMENU :
          break ;

     case WM_MENUEND :
          break ;

    /*
    **  The PM messages for action bar and pulldown menu items are
    **  processed in this routine.
    */
     case WM_COMMAND :
     {
       switch(SHORT1FROMMP(mp1))
       {
         case IDM_D_CHECK:
         {
          /*
          **  The code below makes a call to the dialog box named
          **  "CHKDTE". Variable rc will receive the
          **  return code sent when the dialog box is closed.
          */
           APIRET rc ;

           rc = WinDlgBox(HWND_DESKTOP, hWnd, (PFNWP)CHKDTEMsgProc,
                          0, IDLG_CHKDTE, (PVOID)&hWnd) ;
         }
         break ;

         case IDM_D_TIMEZONES:
         {
          /*
          **  The code below makes a call to the dialog box named
          **  "TMEZON". Variable rc will receive the
          **  return code sent when the dialog box is closed.
          */
           APIRET rc ;

           rc = WinDlgBox(HWND_DESKTOP, hWnd, (PFNWP)TMEZONMsgProc,
                          0, IDLG_TMEZON, (PVOID)&hWnd) ;
         }
         break ;

         case IDM_D_ABOUT:
              #include "TSTABOUT.INC"
              break ;

         case IDM_D_EXIT:
              #include "TSTEXITW.INC"
              break ;

         default:
              break ; // End of default case for switch(mp1)
       }
     }
     break ; // End of WM_COMMAND

     case WM_CREATE :
     {
      /*
      ** The WM_CREATE message is sent to a window when an application
      ** requests that the window be created.  The window procedure
      ** for the new window receives this message after the window is
      ** created, but before the window becomes visible.
      **
      */
       cwSetInitDlgStatus(hWnd) ;
     }
     break ;

     case WM_MOUSEMOVE :
     {
       return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
     }
     break ;

     case WM_SIZE :
     {
     }
     break ;

     case WM_PAINT:    // Code for the window's client area
     {
      /*
      **  Obtain a handle to a cache presentation space
      */
       hPS = WinBeginPaint(hWnd, 0, 0) ;

      /*
      **  Determine the size of the client area
      */
       WinQueryWindowRect(hWnd, &rClient) ;

      /*
      **  Fill the background with the default background color
      */
       WinFillRect(hPS, &rClient, CLR_BACKGROUND) ;

      /*
      **  Return presentation space to state before WinBeginPaint
      */
       WinEndPaint(hPS) ;
     }
     break ;

     case WM_CLOSE :
     {
       #include "TSTCLOSE.INC"

       if (hWnd != hWndClient) break ;
       cwFreeDlgMemory(hWnd) ;
       return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
     }
     break ;

     case WM_TRANSLATEACCEL:
     {
       return(WinDefWindowProc(hWndClient, message, mp1, mp2)) ;
     }
     break ;

     default :
     {
      /*
      **  For any message for which you don't specifically provide a
      **  service routine, you should return the message to PM using
      **  the WinDefWindowProc function.
      */
       return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
     }
     break ;
   }
   return(0L) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY CHKDTEMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND   hWndParent ;
   CHKDTEStruct *Chkdte ;

   switch(message)
   {
     case WM_INITDLG:
     {
       CHAR szWorkBuf[50] ; // Local scratch memory

       Chkdte = (CHKDTEStruct *)WinQueryWindowULong(hWndClient, OFFSET_CHKDTE) ;

       hWndParent = *((HWND *)mp2) ;
       cwCenter(hWndDlg, (HWND)hWndParent) ;

      /*
      **  Initialize entry field control: ChkDteDay
      */
       Chkdte->ChkDteDay = 0 ;

      /*
      **  Initialize entry field control: ChkDteMonth
      */
       Chkdte->ChkDteMonth = 0 ;

      /*
      **  Initialize entry field control: ChkDteYear
      */
       Chkdte->ChkDteYear = 0 ;

      /*
      **  Initialize entry field control: ChkDteWeekday
      */
       WinSendDlgItemMsg(hWndDlg, CHKDTEWKDFLD, EM_SETTEXTLIMIT, MPFROMSHORT(32), 0L) ;
       if (Chkdte->ChkDteWeekday[0])
         WinSetDlgItemText(hWndDlg, CHKDTEWKDFLD, Chkdte->ChkDteWeekday) ;

      /*
      **  Initialize entry field control: ChkDteMonthName
      */
       WinSendDlgItemMsg(hWndDlg, CHKDTEMTNFLD, EM_SETTEXTLIMIT, MPFROMSHORT(32), 0L) ;
       if (Chkdte->ChkDteMonthName[0])
         WinSetDlgItemText(hWndDlg, CHKDTEMTNFLD, Chkdte->ChkDteMonthName) ;

      /*
      **  Initialize check box control: ChkDteLeapYear
      */
       WinSendDlgItemMsg(hWndDlg, CHKDTELPYCHK, BM_SETCHECK,
                         MPFROMSHORT(Chkdte->ChkDteLeapYear), 0L) ;

      /*
      **  Initialize entry field control: ChkDteDayInYear
      */
       if (Chkdte->ChkDteDayInYear != 0)
       {
         _ltoa(Chkdte->ChkDteDayInYear, szWorkBuf, 10) ;
         WinSetDlgItemText(hWndDlg, CHKDTEDIYFLD, szWorkBuf) ;
       }

      /*
      **  Initialize entry field control: ChkDteJulianDate
      */
       if (Chkdte->ChkDteJulianDate != 0)
       {
         _ltoa(Chkdte->ChkDteJulianDate, szWorkBuf, 10) ;
         WinSetDlgItemText(hWndDlg, CHKDTEJULFLD, szWorkBuf) ;
       }

      /*
      **  Initialize entry field control: ChkDteWeekOfYear
      */
       if (Chkdte->ChkDteWeekOfYear != 0)
       {
         _ltoa(Chkdte->ChkDteWeekOfYear, szWorkBuf, 10) ;
         WinSetDlgItemText(hWndDlg, CHKDTEWEKFLD, szWorkBuf) ;
       }

      /*
      **  Initialize entry field control: ChkDteLangId
      */
       WinSendDlgItemMsg(hWndDlg, CHKDTECLNDDL, EM_SETTEXTLIMIT, MPFROMSHORT(4), 0L) ;
       if (Chkdte->ChkDteLangId[0])
         WinSetDlgItemText(hWndDlg, CHKDTECLNDDL, Chkdte->ChkDteLangId) ;

      /*
      **  Initialize List with Table
      */
       {
         int i ; // loop counter

         for (i=0 ; i < 32 ; i++)
           if (Chkdte->ChkDteLangTbl[i][0])
             WinSendDlgItemMsg(hWndDlg, CHKDTECLNDDL, LM_INSERTITEM,
                               MPFROM2SHORT(LIT_SORTASCENDING, 0),
                               MPFROMP(Chkdte->ChkDteLangTbl[i])) ;
       }

      /*
      **  User Defined Code for Pre Dialog execution
      */
       #include "TSTINITC.INC"
     }
     break ; // End of WM_INITDLG

     case WM_CONTROL:
     {
       Chkdte = (CHKDTEStruct *)WinQueryWindowULong(hWndClient, OFFSET_CHKDTE) ;

       switch(SHORT1FROMMP(mp1))
       {
         case CHKDTELPYCHK: // Checkbox text: "Leap year"
         {
           // READ ONLY
         }
         break ;

         case CHKDTEDAYFLD: // Entry field variable: "ChkDteDay"
         {
              switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
              {
                case EN_SETFOCUS:  // Entry field is receiving the focus
                     #include "TSTCLEAR.INC"
                     break ;

                case EN_KILLFOCUS: // Entry field is losing the focus
                     break ;

                default: // Default other messages
                     return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                     break ;
              }
         }
         break ;

         case CHKDTEMTHFLD: // Entry field variable: "ChkDteMonth"
         {
              switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
              {
                case EN_SETFOCUS:  // Entry field is receiving the focus
                     #include "TSTCLEAR.INC"
                     break ;

                case EN_KILLFOCUS: // Entry field is losing the focus
                     break ;

                default: // Default other messages
                     return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                     break ;
              }
         }
         break ;

         case CHKDTEYEAFLD: // Entry field variable: "ChkDteYear"
         {
              switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
              {
                case EN_SETFOCUS:  // Entry field is receiving the focus
                     #include "TSTCLEAR.INC"
                     break ;

                case EN_KILLFOCUS: // Entry field is losing the focus
                     break ;

                default: // Default other messages
                     return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                     break ;
              }
         }
         break ;

         case CHKDTEWKDFLD: // Entry field variable: "ChkDteWeekday"
         {
              switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
              {
                case EN_SETFOCUS:  // Entry field is receiving the focus
                     break ;

                case EN_KILLFOCUS: // Entry field is losing the focus
                     break ;

                default: // Default other messages
                     return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                     break ;
              }
         }
         break ;

         case CHKDTEMTNFLD: // Entry field variable: "ChkDteMonthName"
         {
              switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
              {
                case EN_SETFOCUS:  // Entry field is receiving the focus
                     break ;

                case EN_KILLFOCUS: // Entry field is losing the focus
                     break ;

                default: // Default other messages
                     return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                     break ;
              }
         }
         break ;

         case CHKDTEDIYFLD: // Entry field variable: "ChkDteDayInYear"
         {
              switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
              {
                case EN_SETFOCUS:  // Entry field is receiving the focus
                     break ;

                case EN_KILLFOCUS: // Entry field is losing the focus
                     break ;

                default: // Default other messages
                     return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                     break ;
              }
         }
         break ;

         case CHKDTEJULFLD: // Entry field variable: "ChkDteJulianDate"
         {
              switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
              {
               case EN_SETFOCUS:  // Entry field is receiving the focus
                    break ;

               case EN_KILLFOCUS: // Entry field is losing the focus
                    break ;

               default: // Default other messages
                    return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                    break ;
              }
         }
         break ;

         case CHKDTEWEKFLD: // Entry field variable: "ChkDteWeekOfYear"
         {
              switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
              {
                case EN_SETFOCUS:  // Entry field is receiving the focus
                     break ;

                case EN_KILLFOCUS: // Entry field is losing the focus
                     break ;

                default: // Default other messages
                     return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                     break ;
              }
         }
         break ;

         case CHKDTECLNDDL: // Entry field variable: "ChkDteLangId"
         {
           switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
           {
             case CBN_EFCHANGE:
                  #include "TSTLNGID.INC"
                  break ;

             default: // Default other messages
                  return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                  break ;
           }
           break ;
         }
         break ;
       }
     }
     break ; // End of WM_CONTROL

     case WM_COMMAND:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case CHKDTECHKBUT: // Button text: ""
         {
           #include "TSTCHECK.INC"
         }
         break ;

         case DID_OK: // Button text: "OK"
         {
           CHAR szWorkBuf[50] ; // Local scratch memory

           Chkdte = (CHKDTEStruct *)WinQueryWindowULong(hWndClient, OFFSET_CHKDTE) ;

          /*
          **  Query the check box control for its current state,
          **  and set the dialog structure variable
           Chkdte->ChkDteLeapYear =
             (INT)(ULONG)(WinSendDlgItemMsg(hWndDlg, CHKDTELPYCHK,
                                            BM_QUERYCHECK, 0L, 0L)) ;

          /*
          **  Query the string values in the entry field controls and
          **  move the string values to the dialog structure variables
          */
           WinQueryDlgItemText(hWndDlg, CHKDTEDAYFLD, 50, szWorkBuf) ;
           Chkdte->ChkDteDay = atol(szWorkBuf) ;

           WinQueryDlgItemText(hWndDlg, CHKDTEMTHFLD, 50, szWorkBuf) ;
           Chkdte->ChkDteMonth = atol(szWorkBuf) ;

           WinQueryDlgItemText(hWndDlg, CHKDTEYEAFLD, 50, szWorkBuf) ;
           Chkdte->ChkDteYear = atol(szWorkBuf) ;

           WinDismissDlg(hWndDlg, TRUE) ;
         }
         break ;
       }
     }
     break ; // End of WM_COMMAND

     case WM_CLOSE:
          WinDismissDlg(hWndDlg, FALSE) ;
          break ;

     case WM_FAILEDVALIDATE:
          return((MRESULT)TRUE) ;
          break ;

     default:
          return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
          break ;
   }

   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY TMEZONMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND     hWndParent ;
   TMEZONStruct   *Tmezon ;

   switch(message)
   {
     case WM_INITDLG:
     {
       CHAR szWorkBuf[50] ; // Local scratch memory

       Tmezon = (TMEZONStruct *)WinQueryWindowULong(hWndClient, OFFSET_TMEZON) ;

       hWndParent = *((HWND *)mp2) ;

       cwCenter(hWndDlg, (HWND)hWndParent) ;

      /*
      **  Initialize entry field control: TmeZonUCTHours
      */
       Tmezon->TmeZonUCTHours = 0 ;
       sprintf(szWorkBuf,"%02ld",Tmezon->TmeZonUCTHours) ;
       WinSetDlgItemText(hWndDlg, TMEZONHRSFLD, szWorkBuf) ;

      /*
      **  Initialize entry field control: TmeZonUCTMinutes
      */
       Tmezon->TmeZonUCTMinutes = 0 ;
       sprintf(szWorkBuf,"%02ld",Tmezon->TmeZonUCTMinutes) ;
       WinSetDlgItemText(hWndDlg, TMEZONMINFLD, szWorkBuf) ;

      /*
      **  Initialize entry field control: TmeZonUCTSeconds
      */
       Tmezon->TmeZonUCTSeconds = 0 ;
       sprintf(szWorkBuf,"%02ld",Tmezon->TmeZonUCTSeconds) ;
       WinSetDlgItemText(hWndDlg, TMEZONSECFLD, szWorkBuf) ;

      /*
      **  Initialize entry field control: TmeZonLocalHours
      */
       if (Tmezon->TmeZonLocalHours != 0)
       {
         sprintf(szWorkBuf,"%02ld",Tmezon->TmeZonLocalHours) ;
         WinSetDlgItemText(hWndDlg, TMEZONHR2FLD, szWorkBuf) ;
       }

      /*
      **  Initialize entry field control: TmeZonLocalMinutes
      */
       if (Tmezon->TmeZonLocalMinutes != 0)
       {
         sprintf(szWorkBuf,"%02ld",Tmezon->TmeZonLocalMinutes) ;
         WinSetDlgItemText(hWndDlg, TMEZONMI2FLD, szWorkBuf) ;
       }

      /*
      **  Initialize entry field control: TmeZonLocalSeconds
      */
       if (Tmezon->TmeZonLocalSeconds != 0)
       {
         sprintf(szWorkBuf,"%02ld",Tmezon->TmeZonLocalSeconds) ;
         WinSetDlgItemText(hWndDlg, TMEZONSE2FLD, szWorkBuf) ;
       }

      /*
      **  Initialize the flags to avoid looping between OFFSET slider and field
      */
       Tmezon->fromSlider = FALSE ;
       Tmezon->fromField  = FALSE ;

      /*
      **  Initialize entry field control: TmeZonOffset
      */
       _ltoa(Tmezon->TmeZonOffset, szWorkBuf, 10) ;
       WinSetDlgItemText(hWndDlg, TMEZONOFFFLD, szWorkBuf) ;

      /*
      **  Initialize slider
      */
       WinSendDlgItemMsg(hWndDlg, TMEZONOFFSLD,
                         SLM_SETSLIDERINFO,
                         MPFROM2SHORT(SMA_SLIDERARMPOSITION,
                         SMA_INCREMENTVALUE),
                         MPFROMSHORT(Tmezon->TmeZonOffset+12)) ;

      /*
      **  Initialize bitmap
      */
       Tmezon->hps = WinGetPS(hWndDlg) ;
       Tmezon->hbmp = GpiLoadBitmap(Tmezon->hps, NULLHANDLE, TMEZONMAPBMP, 0L, 0L) ;
     }
     break ; // End of WM_INITDLG

     case WM_CONTROL:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case TMEZONHRSFLD: // Entry field variable: "TmeZonUCTHours"
         case TMEZONMINFLD: // Entry field variable: "TmeZonUCTMinutes"
         case TMEZONSECFLD: // Entry field variable: "TmeZonUCTSeconds"
         case TMEZONHR2FLD: // Entry field variable: "TmeZonLocalHours"
         case TMEZONMI2FLD: // Entry field variable: "TmeZonLocalMinutes"
         case TMEZONSE2FLD: // Entry field variable: "TmeZonLocalSeconds"
         {
           switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
           {
             case EN_SETFOCUS:  // Entry field is receiving the focus
                  break ;

             case EN_KILLFOCUS: // Entry field is losing the focus
                  break ;

             default: // Default other messages
                  return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                  break ;
           }
         }
         break ;

         case TMEZONOFFFLD: // Entry field variable: "TmeZonOffset"
         {
           #include "TSTFIELD.INC"
         }
         break ;

         case TMEZONOFFSLD: // Slider for offsets
         {
           #include "TSTSLIDR.INC"
         }
         break ;

         case TMEZONMAPBUT:
         {
           #include "TSTBTMAP.INC"
         }
       }
     }
     break ; // End of WM_CONTROL

     case WM_COMMAND:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case DID_OK: // Button text: "OK"
         {
           CHAR szWorkBuf[50] ; // Local scratch memory

           Tmezon = (TMEZONStruct *)WinQueryWindowULong(hWndClient, OFFSET_TMEZON) ;

          /*
          **  Query the string values in the entry field controls and
          **  move the string values to the dialog structure variables
          */
           WinQueryDlgItemText(hWndDlg, TMEZONHRSFLD, 50, szWorkBuf) ;
           Tmezon->TmeZonUCTHours = atol(szWorkBuf) ;

           WinQueryDlgItemText(hWndDlg, TMEZONMINFLD, 50, szWorkBuf) ;
           Tmezon->TmeZonUCTMinutes = atol(szWorkBuf) ;

           WinQueryDlgItemText(hWndDlg, TMEZONSECFLD, 50, szWorkBuf) ;
           Tmezon->TmeZonUCTSeconds = atol(szWorkBuf) ;

           WinQueryDlgItemText(hWndDlg, TMEZONOFFFLD, 50, szWorkBuf) ;
           Tmezon->TmeZonOffset = atol(szWorkBuf) ;

           WinDismissDlg(hWndDlg, TRUE) ;
         }
         break ;

         case TMEZONOFFBUT: // Button text: ""
         {
           #include "TSTOFFST.INC"
         }
         break ;
       }
     }
     break ; // End of WM_COMMAND

     case WM_CLOSE:
          WinDismissDlg(hWndDlg, FALSE) ;
          break ;

     case WM_DESTROY:
     {
       Tmezon = (TMEZONStruct *)WinQueryWindowULong(hWndClient, OFFSET_TMEZON) ;

      /*
      **  Release bitmap and presentation space
      */
       if (Tmezon != NULL)
       {
         GpiDeleteBitmap(Tmezon->hbmp) ;
         WinReleasePS(Tmezon->hps) ;
       }

       return (WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
     }
     break ;

     case WM_FAILEDVALIDATE:
          return((MRESULT)TRUE) ;
          break ;

     default:
          return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
          break ;
   }

   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  cwRegisterClass Function
**
**  The following function registers all the classes of all the windows
**  associated with this application. The function returns TRUE if it is
**  successful, otherwise it returns FALSE.
**
*/
 INT cwRegisterClass(VOID)
 {
   APIRET rc ;

   WinLoadString(hAB, 0, IDS_APP_NAME, 80, szAppName) ; // Program name

   rc = WinRegisterClass (hAB,              // Anchor block handle
                          (PCH)szAppName,   // Name of class being registered
                          (PFNWP)WndProc,   // Window procedure for class
                          CS_SIZEREDRAW ,
                          2*sizeof(char*)) ;
   if (rc == FALSE) return(FALSE) ;

   return(TRUE) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  cwCreateWindow Function
**
**  The following function is used to create a window (the main window,
**  a child window, an icon window, etc.) and set it's initial size and
**  position. It returns the handle to the frame window.
**
*/
 HWND cwCreateWindow
 (
   HWND   hWndParent,  // Handle to the parent of the window to be created
   ULONG  ctldata,     // Frame control flags for the window
   PCH    appname,     // Class name of the window
   PCH    title,       // Title of the window
   ULONG  ResID,       // Resource id value
   INT    x,           // Initial horizontal and vertical location
   INT    y,           //
   INT    cx,          // Initial width and height of the window
   INT    cy,          //
   PHWND  hWndClient,  // Handle to the client area of the window
   ULONG  lfStyle,     // Frame window style
   USHORT uSizeStyle   // User defined size and location flags
 )
 {
   ULONG  rc ;            // Accepts return codes from function calls
   HWND   hWndFrame ;     // Local handle to created window frame
   ULONG  SizeStyle ;     // Local window positioning options
   CHAR   MsgBuffer[80] ; // Buffer for error messages
   HPS    hPS ;           // Handle to a presentation space
   int    xmod, ymod ;    // Modifiers for sizing
   #define DLGXMOD  4     // Dialog units X modulo
   #define DLGYMOD  8     // Dialog units Y modulo
   FONTMETRICS fm ;       // Structure for determing modifiers

  /*
  **  Create the frame window
  */
   hWndFrame = WinCreateStdWindow(hWndParent,  // Parent of window
                                  lfStyle,     // Frame window style
                                  &ctldata,    // Frame flags
                                  appname,     // Class name
                                  title,       // Window title
                                  0L,          // Client window style
                                  0,           // Module for resources
                                  ResID,       // Resource id
                                  (HWND *)hWndClient) ; // Client handle

  /*
  **  If hWndFrame is NULL, an error occured when opening the window,
  **  notify the user and exit this function
  */
   if(hWndFrame == 0)
   {
     WinLoadString(hAB, 0, IDS_ERR_WINDOW_CREATE, 80, MsgBuffer) ;
     WinMessageBox(HWND_DESKTOP, hWndParent, MsgBuffer,
                   0, 0, MB_OK|MB_ICONEXCLAMATION) ;
     return ((HWND)0) ;
   }

  /*
  **  Set up size options
  */
   SizeStyle = SWP_ACTIVATE | SWP_ZORDER | uSizeStyle ;

  /*
  **  If the height, width, intial x or initial y values are non-zero,
  **  then we will need to set up the modifiers for size and location
  */
   if((cx > 0) || (cy > 0) || (x != 0)  || (y != 0))
   {
     hPS = WinGetPS(HWND_DESKTOP) ;
     GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm) ;
     xmod = (INT)fm.lAveCharWidth ;
     ymod = (INT)fm.lMaxBaselineExt ;
     WinReleasePS(hPS) ;
   }

  /*
  **  If either the width or the height are non-zero, then the size of the
  **  created window will be changed, set SizeStyle accordingly
  */
   if((cx > 0) || (cy > 0) || (x != 0) || (y != 0))
   {
     SizeStyle |= SWP_SIZE ;
     SizeStyle |= SWP_MOVE ;
   }

  /*
  **  Set the size and position of the window and activate it
  */
   rc = WinSetWindowPos(hWndFrame, HWND_TOP,
                        ((x * xmod)/DLGXMOD),
                        ((y * ymod)/DLGYMOD),
                        ((cx * xmod)/DLGXMOD),
                        ((cy * ymod)/DLGYMOD), SizeStyle) ;

  /*
  **  If rc is not set to TRUE then WinSetWindowPos failed, notify the user
  **  and exit this function
  */
   if(!rc)
   {
     WinLoadString(hAB, 0, IDS_ERR_WINDOW_POS, 80, MsgBuffer) ;
     WinMessageBox(HWND_DESKTOP, hWndParent, MsgBuffer,
                   0, 0, MB_OK|MB_ICONEXCLAMATION) ;
     return((HWND)0) ;
   }

  /*
  **  Return the handle to the frame window
  */
   return(hWndFrame) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  cwCenter Function
**
**  Centers a dialog box on the client area of the caller
**
**  hWnd       - handle of the window to be centered
**  hWndParent - handle of the window on which to center
**
*/
 INT cwCenter
 (
   HWND hWnd       ,
   HWND hWndParent
 )
 {
   LONG   SrcX, SrcY ;                // Center of parent
   LONG   x, y ;                      // Destination points
   SWP    DlgSwp, ParentSwp ;         // Set window position structures
   LONG   ScreenWidth, ScreenHeight ; // Dimensions of the DESKTOP
   POINTL pt ;                        // Point

  /*
  **  Determine the width and height of the DESKTOP so the dialog box
  **  will not be positioned to a point off of the screen.
  */
   ScreenWidth  = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) ;
   ScreenHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) ;

  /*
  **  Query width and depth of dialog box
  */
   WinQueryWindowPos(hWnd, (PSWP)&DlgSwp) ;

  /*
  **  Query width and depth of caller
  */
   WinQueryWindowPos(hWndParent, (PSWP)&ParentSwp) ;

  /*
  **  Map the point parent points to the Desktop
  */
   pt.x = ParentSwp.x ;
   pt.y = ParentSwp.y ;

  /*
  **  Convert the point from having our window as the origin to having
  **  the DESKTOP as the origin
  */
   WinMapWindowPoints(hWndParent, HWND_DESKTOP, &pt, 1) ;

   SrcX = pt.x + (ParentSwp.cx / 2) ;
   SrcY = pt.y + (ParentSwp.cy / 2) ;

  /*
  **  Determine the point to move the dialog box to
  */
   x = (SrcX - (DlgSwp.cx / 2)) ;
   y = (SrcY - (DlgSwp.cy / 2)) ;

  /*
  **  If either point is less than zero, then set that point to zero
  **  so the dialog box will not be positoned off of the window
  */
   x = (x < 0L) ? 0L : x ;
   y = (y < 0L) ? 0L : y ;

  /*
  **  If either point plus the height or width of the dialog box is
  **  greater than the height or width of the screen adjust point
  */
   if ((x + DlgSwp.cx) > ScreenWidth)  x = ScreenWidth - DlgSwp.cx ;
   if ((y + DlgSwp.cy) > ScreenHeight) y = ScreenHeight - DlgSwp.cy ;

  /*
  **  Move the dialog box
  */
   return(WinSetWindowPos(hWnd, HWND_TOP, x, y, 0, 0, SWP_MOVE)) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  This function allocates memory for dialog box variables and initializes
**  the state of any initially selected radio buttons and check boxes.
*/
 INT cwSetInitDlgStatus(HWND hWnd)
 {
   CHKDTEStruct *Chkdte ;
   TMEZONStruct *Tmezon ;

   OFFSETOF(Chkdte) = 0 ;
   DosAllocMem(((PPVOID)&Chkdte), sizeof(CHKDTEStruct), fALLOC) ;
   memset(Chkdte, 0x00, sizeof(CHKDTEStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_CHKDTE, (ULONG)Chkdte) ;
   Chkdte->ChkDteLeapYear = FALSE ;

   OFFSETOF(Tmezon) = 0 ;
   DosAllocMem(((PPVOID)&Tmezon), sizeof(TMEZONStruct), fALLOC) ;
   memset(Tmezon, 0x00, sizeof(TMEZONStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_TMEZON, (ULONG)Tmezon) ;

   return(0) ;
 }

/* ------------------------------------------------------------------------ */

 INT cwFreeDlgMemory(HWND hWnd)
 {
   CHKDTEStruct *Chkdte ;
   TMEZONStruct *Tmezon ;

   Chkdte = (CHKDTEStruct *)WinQueryWindowULong(hWnd, OFFSET_CHKDTE) ;
   DosFreeMem((PVOID)(Chkdte)) ;

   Tmezon = (TMEZONStruct *)WinQueryWindowULong(hWnd, OFFSET_TMEZON) ;
   DosFreeMem((PVOID)(Tmezon)) ;

   return(0) ;
 }

/* ------------------------------------------------------------------------ */

 void lmemset(void FAR *memptr, CHAR value, INT size)
 {
   char FAR *chrptr = memptr ;

   while (size--) *chrptr++ = value ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Function : tstCheckNumber
**  Author   : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 03 Sep 1993
**  Updated  : 03 Sep 1993
**  Version  : 1.00
**  Content  : Check a number
**
*/
 USHORT tstCheckNumber
 (
   PSZ    pszStr  , // Input string
   LONG  *plValue , // Resulting value
   LONG   lMin    , // Minimum value
   LONG   lMax      // Maximum value
 )
 {
   CHAR   *cursor   ;

   cursor = pszStr ;

   while (isspace(*cursor)) cursor++ ; // Skip leading spaces

  /*
  **  An empty string is a partial number. The user should complete it.
  */
   if (*cursor == '\0')
   {
     *plValue = 0 ;
     return (tstPARTIAL) ;
   }

  /*
  **  The first character MUST be a digit or a sign
  */
   if (*cursor != '+' && *cursor != '-' && !isdigit(*cursor))
   {
     *plValue = 0 ;
     return (tstNOTANUMBER) ;
   }

  /*
  **  Only a sign? It's partial!
  */
   if ((*cursor == '+' || *cursor == '-') && *(cursor+1) == '\0')
   {
     *plValue = 0 ;
     return (tstPARTIAL) ;
   }

  /*
  **  All the other characters MUST be digits, with trailing spaces, if any
  */
   cursor++ ;
   while (isdigit(*cursor)) cursor++ ; // Skip digits
   while (isspace(*cursor)) cursor++ ; // Skip trailing spaces

  /*
  **  The last character MUST be a NULL terminator
  */
   if (*cursor != '\0')
   {
     *plValue = 0 ;
     return (tstNOTANUMBER) ;
   }

  /*
  **  OK, the number looks good
  */
   *plValue = atol(pszStr) ;

   if (*plValue < lMin || *plValue > lMax) return (tstOUTOFRANGE) ;

   return (tstVALID) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Function : zzzDrawButtonBitmap
**  Author   : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 23 Aug 1993
**  Updated  : 23 Aug 1993
**  Version  : 1.00
**  Content  : Draw a bitmap in a user button
**
*/
 VOID zzzDrawButtonBitmap
 (
   HPS          hPS        , // Presentation space
   HWND         hWnd       , // Window handle
   HBITMAP      hBMP       , // Bitmap handle
   ULONG        butId        // Button identity
 )
 {
   SWP   swp ;
   RECTL rec ;

  /*
  **  Get size of owner-draw button and draw bitmap into it
  */
   WinQueryWindowPos(WinWindowFromID(hWnd, butId), &swp ) ;

   rec.xLeft   = 0 ;
   rec.yBottom = 0 ;
   rec.xRight  = swp.cx ;
   rec.yTop    = swp.cy ;

   WinDrawBitmap(hPS, hBMP, NULL, (PPOINTL)&rec, 0L, 0L,
                 DBM_STRETCH | DBM_IMAGEATTRS) ;
 }

/* ------------------------------------------------------------------------ */

