/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** \----------------------------------------------------------------------/
**
**  Module  : ZGENERAL.H
**  Author  : Dario de Judicibus (DEJUDICI at ROMEPPC)
**            Alessandro Cavallini (CAVALLI at ROMEPPC)
**            Giacomo Lenoci
**  Created : 10 Jan 1992
**  Updated : 11 Nov 1993
**  Version : 2.33
**  Content : General includes for all Z Family/2 DLLs
**
*/
 #ifndef zGENERAL
 #define zGENERAL 0

/*
**  Copyright and other strings for Z Family/2 libraries
*/
 #define zPRODPREF   "FMZ"
 #define zPRODNUMB   "5641-504"
 #define zPRODNAME   "IBM Z Family Reusable Libraries/2"
 #define zCOPYRIGHT  "(C) Copyright IBM Corporation 1993,1994"

/*
**  String lengths
*/
 #define zNAMESIZE   9
 #define zLEVELSIZE  8
 #define zSTAMPSIZE 26

/*
**  The following values specify the minimum and maximum values for DLL and
**  EXE error identifiers. This is a standard to be respected by all Z Family/2
**  DLLs and EXEs.
*/
 #define zNULLERRORID      0x0000
 #define zEXEMINERRID      0x0001
 #define zEXEMAXERRID      0x7FFF
 #define zDLLMINERRID      0x8000
 #define zDLLMAXERRID      0xFFFF

/*
**  Exception handling types
*/
 typedef  int         zSIGNAL          ; // Signal
 typedef  void        (*zSIGHAND)(int) ; // Signal Handler Function

 #define  zREGISTERED (zSIGNAL)0L        // Signal was registered

 #define  zSignal(s,h) { if (signal((s),(h)) == SIG_ERR) return (s) ; }

/*
**  Simple types and macros
*/
 typedef unsigned zBIT ;             // Bit to be used  as flags

 #define  zIsOn(b)      ((b) != 0)   // Check if zBIT is ON (1)
 #define  zIsOff(b)     ((b) == 0)   // Check if zBIT is OFF (0)

/*
**  The following structure is used by all Z Family/2 DLLs to keep the library
**  version information.
*/
 typedef struct zLibVersion   // Library Version Structure definition
 {
   USHORT Version            ; // DLL Version (Major Functional Changes)
   USHORT Release            ; // DLL Release (Minor Functional Changes)
   USHORT Modification       ; // DLL Modification (Fixes)
   CHAR   String[zLEVELSIZE] ; // DLL Level String
   CHAR   Stamp[zSTAMPSIZE]  ; // DLL Compile-time Stamp
   CHAR   Name[zNAMESIZE]    ; // DLL Name
 }
 zLIBVERS, *zPLIBVERS ;

 typedef struct zLibVersion LIBVERS, *PLIBVERS ; // Obsolete, for compatibility

 #endif
