

#include "appwin.h"

#include "ui/composit.h"
#include "ui/applic.h"
#include "ui/stddlg.h"
#include "ui/label.h"
#include "ui/menu.h"


#define ID_ADD    101
#define ID_REMOVE 102


UI_MenuItemDescriptor PopupMenuDesc [] = {
    {"&Add",    ID_ADD,    NULL}
  , {"&Remove", ID_REMOVE, NULL}
  , {NULL,      0,         NULL}
};


typedef CL_Binding<AppWindow> AppBind;

#if defined(__GNUC__)
template class CL_Binding<AppWindow>;
#endif

AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (100, 100, 350, 200))
{
    Title() = "YACL Popup Menu Demo";
    _popupMenu = new UI_PopupMenu (this, PopupMenuDesc);
    AppBind bind (this, &AppWindow::Selected);
    (*_popupMenu)[ID_ADD]->AddEventDependent (Event_Select, bind, ID_ADD);
    (*_popupMenu)[ID_REMOVE]->AddEventDependent (Event_Select, bind,
                                                 ID_REMOVE);
    UI_Label* lbl = new UI_Label (this, UI_Rectangle (5, 35, 290, 30));
    lbl->Title() = "Right mouse btn gives popup menu";
}


bool AppWindow::Selected (CL_Object&, long id)
{
    UI_SimpleDialog (CL_String ("Selected: ") + CL_String (id));
    return TRUE;
}


bool AppWindow::ButtonDown (const UI_Point& curPos, UI_MouseButton btn,
                            bool, bool)
{
    if (btn == UIM_Right || btn == UIM_Middle)
        _popupMenu->ShowAt (curPos);
    return FALSE;
}

