

#include "base/memory.h"

#include "ui/ui.h"
#include "box.h"
#include "ids.h"




static char* cities[] = {
    "Chicago",
    "New York",
    "Atlanta",
    "Bangalore",
    "Beijing",
    "Bombay",
    "Columbia",
    "Binghamton",
    "Los Angeles",
    "Copenhagen",
    "Amsterdam",
    "Berlin",
    "London",
    0
};


Box::Box (UI_CompositeVObject* parent, const UI_Rectangle& shape)
: UI_CompositeVObject (parent, NULL, TRUE,
                       UI_Rectangle (100, 100, 480, 400), -1)
{
    ShowBorder ();
    _strseq = new UI_StringSequence;
    for (short i = 0; cities[i] != 0; i++)
        _strseq->Add (cities[i]);

    _singl = new UI_StringViewSingleSel
        (this, _strseq, UI_Rectangle (40,  50, 130, 160), ID_SINGLE_VIEW);
    _multi = new UI_StringViewMultiSel
        (this, _strseq, UI_Rectangle (200, 50, 130, 160), ID_MULT_VIEW);
    UI_Label* msg = new UI_Label (this, UI_Rectangle (10, 10, 350, 20));
    UI_Label* sl1 = new UI_Label (this, UI_Rectangle (40, 230, 150, 20),
                                  ID_SSEL_LBL);
    UI_Label* slm = new UI_Label (this, UI_Rectangle (200, 230, 150, 20),
                                  ID_MSEL_LBL);
    sl1->SetTextStyle (UIText_Left);
    slm->SetTextStyle (UIText_Left);
    msg->Model() = CL_String ("Two StringView objects with the same model:");
//    msg->Font().PointSize (9);
// #if defined(__MS_WINDOWS__)
//     char* font_name = "MS Sans Serif";
// #elif defined(__X_MOTIF__)
//     char* font_name = "courier";
// #endif
//     msg->Font().TypeFace (font_name);
    
//     UI_Font& font1 = _singl->Font();
//     font1.TypeFace (font_name);
//     font1.BoldFace (TRUE);
//     font1.PointSize (9);
// 
//     UI_Font& font2 = _multi->Font();
//     font2.TypeFace ("Courier");
//     font2.BoldFace (TRUE);
//     font2.PointSize (10);
}


Box::~Box()
{
    UI_SimpleDialog (CL_String ("Max mem used: ") +
                     CL_String (CL_MemoryLeakChecker::MaxMemoryUsed()) +
                     CL_String (" Current usage: ") +
                     CL_String (CL_MemoryLeakChecker::CurrentMemoryUsage()));
    delete _strseq;
}


bool Box::HandleChildEvent (const UI_Event& e)
{
    if (e.Type() != Event_Select)
        return FALSE;
    if(e.Origin()->ViewID() == ID_SINGLE_VIEW) {
        UI_StringViewSingleSel* v = _singl;
        const CL_Integer& indx = v->Selection();
        if (indx == 2)
           _strseq->Remove (2);
        else if (indx >= 0) {
            long l = indx;
            if ((*_strseq)[l] == "Copenhagen")
                _strseq->Insert ("Click here", l);
            else if ((*_strseq)[l] == "Click here")
                (*_strseq)[l] = "Don't click";
            else if ((*_strseq)[l] == "Don't click")
                (*_strseq)[l] = "Click here";
        }
    }
    CL_String s = _singl->Selection().AsString();
    (*this)[ID_SSEL_LBL]->Title() = "Selection: " + s;
    s = _multi->Selection().AsString();
    (*this)[ID_MSEL_LBL]->Title() = "Selection: " + s;
    return TRUE;
}

