

#include "menudrv.h"
#include "ids.h"

#include "ui/menu.h"
#include "ui/applic.h"
#include "ui/stddlg.h"

#if defined(__GNUC__)
template class CL_Binding<MenuDriver>; // Instantiate the binding
#endif

extern UI_Application* _TheApplication;
typedef CL_Binding<MenuDriver> MenuBinding;

UI_MenuItemDescriptor ActSubmenu [] = { // Cascaded submenu
  {"&Month"           , ID_SUBMONTH}
, {"&Days"            , ID_SUBDAY}
, {NULL               , 0}
};

UI_MenuItemDescriptor ActMenu [] = {    // Actions pull-down menu
    {"&Add month"     , ID_ADD ,     NULL      }
  , {"&Enable/Disable", ID_DIS ,     ActSubmenu}
  , {"&Remove month"  , ID_REM ,     NULL      }
  , {UIMenu_Separator , NULL   ,     NULL      }
  , {"&Quit"          , ID_QUIT,     NULL      }
  , {NULL             , 0      ,     NULL      }
};

UI_MenuItemDescriptor MonthMnu [] = {   // Month pull-down menu
    {"&Jan"           , ID_JAN}
  , {"&Feb"           , ID_FEB}
  , {"&Mar"           , ID_MAR}
  , {"&Apr"           , ID_APR}
  , {NULL             , 0     }
};

UI_MenuItemDescriptor DaysMenu [] = {   // Days pull-down menu
    {"Monday"         , ID_MON}
  , {"Tuesday"        , ID_TUE}
  , {"Wednesday"      , ID_WED}
  , {"Thursday"       , ID_THU}
  , {"Friday"         , ID_FRI}
  , {NULL             ,      0}
};

UI_MenuItemDescriptor MainMenuDesc [] = {   // Main menu bar
    {"&Action"        , ID_ACT  ,  ActMenu }
  , {"&Month"         , ID_MONTH,  MonthMnu}
  , {"&Day"           , ID_DAYS ,  DaysMenu}
  , {NULL             ,        0,  NULL    }
};

struct DispatcherStruct {
    UI_ViewID              menu_id;
    MenuBinding::MethodPtr method;
    UI_EventType           event;
    long                   parameter;
} FAR dispatch [] = {
    {ID_JAN,      MenuDriver::Inform,         Event_Select,  ID_JAN}      
  , {ID_FEB,      MenuDriver::Inform,         Event_Select,  ID_FEB}      
  , {ID_MAR,      MenuDriver::Inform,         Event_Select,  ID_MAR}      
  , {ID_APR,      MenuDriver::Inform,         Event_Select,  ID_APR}      
                                                                          
  , {ID_ADD,      MenuDriver::Add,            Event_Select,  0}           
  , {ID_REM,      MenuDriver::Remove,         Event_Select,  0}           
  , {ID_SUBMONTH, MenuDriver::DisableMonth,   Event_Select,  0} 
  , {ID_SUBDAY,   MenuDriver::DisableDays,    Event_Select,  0}   
  , {ID_QUIT,     MenuDriver::Quit,           Event_Select,  0}
};




MenuDriver::MenuDriver (UI_CompositeVObject* root)
{
    _menu =  new UI_MenuBar (root, MainMenuDesc);
    for (short i = 0; i < sizeof dispatch/sizeof (DispatcherStruct); i++) {
        MenuBinding bind (this, dispatch[i].method);
        (*_menu)[dispatch[i].menu_id]->AddEventDependent
            (dispatch[i].event, bind, dispatch[i].parameter);
    }
    (*_menu)[ID_REM]->Disable();
    _daysEnabled = TRUE;
}




bool MenuDriver::Inform (CL_Object&, long item_id)
{
    UI_SimpleDialog ("You chose " + (*_menu)[item_id]->Title());
    return TRUE;
}


bool MenuDriver::Add (CL_Object&, long)
{
    _menu->Add (ID_MAY, "Ma&y", ID_MONTH);
    (*_menu)[ID_ADD]->Disable();
    (*_menu)[ID_REM]->Enable();
    UI_SimpleDialog ("Added an item to Month menu");
    return TRUE;
}


bool MenuDriver::Remove (CL_Object&, long)
{
    _menu->Remove (ID_MAY);
    (*_menu)[ID_REM]->Disable();
    (*_menu)[ID_ADD]->Enable();
    UI_SimpleDialog ("Removed an item from Month menu");
    return TRUE;
}



bool MenuDriver::DisableMonth (CL_Object&, long)
{
    UI_MenuItem* m = (*_menu)[ID_MONTH];
    m->ToggleEnabledState();
    if (m->IsEnabled())
        m->Title() = "&Month";
    else
        m->Title() = "No month";
    return TRUE;
}


bool MenuDriver::DisableDays  (CL_Object&, long)
{
    short n = _menu->ChildCount (ID_DAYS);
    for (short i = 0; i < n; i++)
        _menu->Child(ID_DAYS, i)->ToggleEnabledState();
    char* msg = _daysEnabled ? " disabled" : " enabled";
    UI_SimpleDialog (CL_String ("All days ") + msg);
    _daysEnabled = _daysEnabled ? FALSE : TRUE;
    return TRUE;
}


bool MenuDriver::Quit (CL_Object&, long)
{
    _TheApplication->End();
    return TRUE;
}
