
#include "appwin.h"
#include "ui/stddlg.h"
#include "ui/applic.h"

AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (40, 40, 400, 300))
{
    _count = 5;
    _btn   = new UI_PushButton (this, UI_Rectangle (75, 80, 225, 50),
                                ID_BUTTON);
    _msg   = new UI_Label (this, UI_Rectangle (55, 50, 245, 20), ID_LABEL);
    _msg->Title() = "Hello!";
    _btn->Title() = "Click here " + CL_String(_count) + " times.";
    _title = "YACL Demo";
}

bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Origin()->ViewID() == ID_BUTTON && e.Type() == Event_Select) {
        _count--;
        if (_count == 0)
            _Application->Destroy (this);
        else
            _btn->Title () (11,1) =  CL_String(_count);
        return TRUE;
    }
    return FALSE;
}

bool AppWindow::WantToQuit()
{
    return (UI_SimpleDialog ("Do you really want to quit?", "Confirm", NULL,
                             UIS_YesNo, UIS_Question) == UI_IDYES);
}
