




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#if defined(__GNUC__)
#pragma implementation
#endif


#include "base/binding.h"
#include "base/clntset.h"

#include "ui/vobjcoll.h"
#include "ui/applic.h"
#include "ui/cntroler.h"


#if defined (__MS_WINDOWS__)
#include <windows.h>

#elif defined (__X_MOTIF__)
#include <Xm/Xm.h>
#include <Xm/BulletinB.h>

#endif



UI_VObjCollection::UI_VObjCollection (UI_VObjCollection* parent,
                                      const UI_Rectangle& shape,
                                      UI_ViewID id)
: UI_VisualObject(parent, shape, id)
{
#if defined(__MS_WINDOWS__)
    _style = WS_CHILD | WS_CLIPCHILDREN;
#elif defined(__OS2__)
    _style = WS_VISIBLE;
#endif
}


bool UI_VObjCollection::Enable ()
{
    if (!UI_VisualObject::Enable())
        return FALSE;
    UI_VObjCollIterator itr (*this);
    while (itr.More())
        itr.Next()->Enable();
    return TRUE; // ??
}



bool UI_VObjCollection::Disable ()
{
    UI_VisualObject::Disable();
    UI_VObjCollIterator itr (*this);
    while (itr.More())
        itr.Next()->Disable();
    return TRUE; // ??
}



void UI_VObjCollection::MakeInvisible ()
{
    UI_VObjCollIterator itr (*this);
    while (itr.More())
        itr.Next()->MakeInvisible();
    UI_VisualObject::MakeInvisible ();
}



void UI_VObjCollection::MakeVisible ()
{
    UI_VObjCollIterator itr (*this);
    while (itr.More())
        itr.Next()->MakeVisible();
    UI_VisualObject::MakeVisible ();
}



UI_VisualObject* UI_VObjCollection::operator [] (UI_ViewID id)
{
    return (UI_VisualObject*) _objMap[id];
}



long UI_VObjCollection::ChildCount ()
{
    return _objMap.Size();
}




bool UI_VObjCollection::Contains (UI_ViewID id)
{
    return _objMap.IncludesKey (id);
}






UI_VObjCollection::~UI_VObjCollection ()
{
}

    

UI_WindowClass UI_VObjCollection::WindowClass () const
{
#if defined(__MS_WINDOWS__)
    return _YACLWindowClassName;
#elif defined(__OS2__)
    return _YACLWindowClassName;
#elif defined(__X_MOTIF__)
    return xmBulletinBoardWidgetClass;
#endif
}


bool UI_VObjCollection::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__) 
    return UI_VisualObject::MakeVisualElement ();

#elif defined(__OS2__) 
    return UI_VisualObject::MakeVisualElement ();

#elif defined(__X_MOTIF__)

    // GNU C seems to have a strange bug, so we work around it. Instead of
    // saying
    //    Widget pw = (Widget) (_parent->ViewHandle());
    // we say
    UI_VisualObject* p = _parent;
    Widget pw = (Widget) p->ViewHandle();

    CL_String instance_name = InstanceName();
    const char* inst_name = instance_name.AsPtr();
    struct _WidgetClassRec *class_name = WindowClass ();

    Arg arg [20];
    short argn = 0;
    _SetupStyle (arg, argn); // Set up the X resources

    XmString title = XmStringCreate
        ((char *) _title.AsPtr (), XmSTRING_DEFAULT_CHARSET);    
    XtSetArg (arg [argn], XmNlabelString,  title); argn++;
    XtSetArg (arg [argn], XmNmarginWidth,  0);     argn++;
    XtSetArg (arg [argn], XmNmarginHeight, 0);     argn++;
    _xwidget = XtCreateWidget (inst_name, class_name, pw, arg, argn);
    // XtManageChild (_xwidget);
    // XtSetValues (_xwidget, arg, argn);

    XmStringFree (title);
    return TRUE;
#endif
}



bool UI_VObjCollection::_PrivateHandleChildEvent (UI_Event& e)
{
    bool b = HandleChildEvent (e);
    bool p = TRUE;
    if (_eventDependents) {
        CL_ClientSet* set = (CL_ClientSet*) (*_eventDependents)[e.Type()];
        if (set)
            p = set->Permits (e);
    }
    return b || !p;
}




bool UI_VObjCollection::DestroyVisualElement ()
{
#if defined(__MS_WINDOWS__)
    if (_handle > 0 && !CreatedViaResource()) {
        DestroyWindow (_handle);
        return TRUE;
    }
#elif defined(__X_MOTIF__)
    if ( _xwidget ) {
        XtUnmanageChild (_xwidget);
        XtDestroyWidget (_xwidget);
        return TRUE;
    }
#endif
    return FALSE;
}


typedef CL_Binding<UI_VObjCollection> VObjCollBind;


#if defined(__GNUC__)
template class CL_Binding<UI_VObjCollection>;
#endif


void UI_VObjCollection::_PrivateInitialize()
{
    UI_VisualObject::_PrivateInitialize();
    if (_model) {
        VObjCollBind b (this, &(UI_VObjCollection::_ModelChanged));
        _model->AddDependent (b, 1);
    }
}



bool UI_VObjCollection::_ModelChanged (CL_Object &o, long val)
{
    return UI_VisualObject::_ModelChanged (o, val);
}



void UI_VObjCollection::AddChild (UI_VisualObject* child)
{
    if (child && child->ViewID() > 0)
        _objMap.Add (child->ViewID(), child);
}


UI_VisualObject* UI_VObjCollection::RemoveChild (UI_VisualObject* view)
{
    if (!view)
        return NULL;
    UI_ViewID childID = view->ViewID();
    if (childID > 0) {
        CL_IntPtrAssoc assoc = _objMap.Remove (childID);
        return (UI_VisualObject*) assoc.value;
    }
    return NULL;
}

bool UI_VObjCollection::SetFont (UI_Font* font)
{
    if (!UI_VisualObject::SetFont (font))
        return FALSE;
    CL_IntPtrMapIterator itr (_objMap);
    while (itr.More()) {
        CL_IntPtrAssoc assoc = itr.Next();
        ((UI_VisualObject*) assoc.value)->SetFont(font);
    }
    return TRUE;
}




UI_VObjCollIterator::UI_VObjCollIterator (UI_VObjCollection& v)
: _itr (v._objMap)
{
    _itr.Reset();
}




void UI_VObjCollIterator::Reset ()
{
    _itr.Reset();
}



bool UI_VObjCollIterator::More ()
{
    return _itr.More();
}


UI_VisualObject* UI_VObjCollIterator::Next ()
{
    return (UI_VisualObject*) _itr.Next().value;
}

