

#ifndef _timer_h_ /* Thu Oct 13 16:22:48 1994 */
#define _timer_h_



#if defined(__GNUC__)
#pragma interface
#endif


#include "base/binding.h"
#include "base/map.h"

// This is a  class that provides a simple timer service.  The Start method
// (for {\it any\/} Timer instance) can only be
// called {\it after\/} the main window has been displayed.

class CL_EXPORT UI_Timer: public CL_Object {

public:
    UI_Timer (const CL_AbstractBinding& bnd);
    // Construct a Timer object which will execute the given binding
    // whenever the timer expires.

    ~UI_Timer ();
    // Destructor: stop the timer.
    
    bool Start (long msecs);
    // Start the timer. After this method is called, the timer repeatedly
    // executes its binding every {\tt msecs} milliseconds.
    //
    // This method returns TRUE if successful, FALSE if the system's timer
    // resource is not available.  This method can only be
    // called {\it after\/} the main window has been displayed.
    
    bool Stop ();
    // Stop the timer, and do not execute the binding any more.

    bool IsRunning () const { return _running;};

protected:
    CL_AbstractBinding* _bind;
    ulong               _id;
    long                _msecs;
    bool                _running;
    
public:

#if defined(__MS_WINDOWS__)
    void DoAlarm ();
    // MS-Windows-specific. For YACL internal use only.

#elif defined(__X_MOTIF__)
    static void DoAlarm (void*, ulong*);
    // X-windows specific. For YACL internal use only.
    
#elif defined (__OS2__)
    static void DoAlarm (ulong timerId);

protected:
    static CL_IntPtrMap _TimerMap;
#endif
};


#endif /* _timer_h_ */
