



/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif

#if defined(__MS_WINDOWS__)
#include <windows.h>
#elif defined(__X_MOTIF__)
#include <Xm/Text.h>
#endif


#include "ui/textedit.h"

#if defined(__GNUC__)
template class CL_Binding<UI_TextEditor>;
#endif



UI_TextEditor::UI_TextEditor
    (UI_CompositeVObject* parent, const UI_Rectangle& shape, UI_ViewID id)
: UI_StringEditor (parent, shape, id, -1)
{
#if defined(__MS_WINDOWS__)
    _style |= ES_MULTILINE | WS_VSCROLL;
#elif defined(__OS2__)
    _style = WS_VISIBLE | MLS_HSCROLL | MLS_VSCROLL | MLS_BORDER |
        MLS_WORDWRAP;
#endif
}


#if defined(__MS_WINDOWS__)
UI_TextEditor::UI_TextEditor (UI_CompositeVObject* parent, UI_ViewID id,
               UI_ViewHandle h)
: UI_StringEditor (parent, id, h)
{
}
#endif


#if defined(__X_MOTIF__)
void UI_TextEditor::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;
    UI_SimpleVObject::_SetupStyle (arg, argn);
    XtSetArg (arg[argn], XmNeditMode, XmMULTI_LINE_EDIT); argn++;
}
    
#endif
    


UI_WindowClass UI_TextEditor::WindowClass () const
{
#if defined(__MS_WINDOWS__)
    return "edit";
#elif defined(__OS2__)
    return WC_MLE;
#elif defined(__X_MOTIF__)
    return  xmTextWidgetClass;
#endif
}


bool UI_TextEditor::SetLengthLimit (long n)
{
#if defined (__MS_WINDOWS__) || defined(__X_MOTIF__)
    return UI_StringEditor::SetLengthLimit (n);
#elif defined (__OS2__)
    _limit = n;
    if (_handle)
        WinSendMsg (_handle, MLM_SETTEXTLIMIT, (MPARAM) n, 0);
    return TRUE;
#endif
}


#if defined(__OS2__)
bool UI_TextEditor::_SelectionChanged (CL_Object&, long)
{
    if (_handle) {
        WinSendMsg (_handle, MLM_SETSEL, (MPARAM)_selection.Low(),
                    (MPARAM) (_selection.High()+1));
    }
    return TRUE;
}
#endif


CL_Interval& UI_TextEditor::Selection ()
{
#if defined(__MS_WINDOWS__) || defined(__X_MOTIF__)
    return UI_StringEditor::Selection ();
#elif defined(__OS2__)
    CL_Binding<UI_TextEditor> bind (this, &UI_TextEditor::_SelectionChanged);
    _selection.RemoveDependent (bind);
    MPARAM pos = WinSendMsg  (_handle, MLM_QUERYSEL, MLFQS_MINMAXSEL, 0);
    _selection = CL_Interval (SHORT1FROMMP(pos), SHORT2FROMMP(pos)-1);
    _selection.AddDependent (bind, 1);
    return _selection;
#endif
}
