
#ifndef _strview_h_
#define _strview_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__GNUC__)
#pragma interface
#endif


#include "base/intset.h"
#include "base/integer.h"

#include "ui/simple.h"
#include "ui/strseq.h"


//  This class provides a pictorial representation of a string sequence. One
//  or more strings in the sequence may be selected by either an explicit
//  call to the method Select() or by the {\small\tt Event_LButtonPress}.
//  A mouse click 
//  on an unselected string selects it while that on a selected string
//  unselects it.




class CL_EXPORT UI_StringView: public UI_SimpleVObject {


public:
    virtual long  TopIndex () const;
    // Return the index of the topmost visible string in the view.

    virtual short VisibleCount () const;
    // Return the number of visible strings. [Not yet implemented under
    // OS/2.]
    
    virtual void  ScrollTo (long index);
    // Scroll the view so that the String at the given index is at the top.
    

    virtual void MakeInvisible ();
    // Override inherited method.
    
    virtual void MakeVisible ();
    // Override inherited method.
    



    // ---------------- Overridden SimpleVObject methods -------------

    virtual UI_WindowClass WindowClass () const;

    // ---------------- Overridden basic methods ---------------------
    
    const char* ClassName () const { return "UI_StringView";};

protected:

    UI_StringView (UI_VObjCollection* parent, UI_StringSequence* model,
                   const UI_Rectangle& shape,
                   bool multiple_select = FALSE,
                   UI_ViewID id = -1, long style = -1);
    // Model not owned

    UI_StringView (UI_VObjCollection* parent,  
                   const UI_Rectangle& shape, bool multiple_select = FALSE,
                   UI_ViewID id = -1, long style = -1);
    // Model owned


#if defined(__MS_WINDOWS__)
    UI_StringView (UI_CompositeVObject* parent, UI_ViewID id,
                   UI_ViewHandle h);
    // [MS-Windows-specific] Resource-based construction.

#endif
    

    virtual void _UpdateSelection () = 0;
    // Called by {\tt ItemInserted} and {\tt ItemRemoved} to tell us
    // to update our selection.

    // ---------------- Overridden VisualObject methods --------------

    ~UI_StringView ();

    bool MakeVisualElement ();
    
    void _PrivateInitialize ();




#if defined (__X_MOTIF__)

    static void Callback (struct _WidgetRec*, void *, void *);

    virtual void _SetupStyle (void* arg, short& argn);
    // [YACL internal use only] X-windows-specific.

    UI_ViewHandle  _frame;
    
#endif

    bool           _multiple;


public:
    virtual void ItemInserted (long pos);
    //  [YACL internal use only] Called by the model to notify this view
    //  that the model just added a new item immediately  after the given
    //  position.

    virtual void ItemRemoved (long);
    // [YACL internal use only]

    virtual void ItemChanged (long);
    // [YACL internal use only]

    virtual void ModelEmptied ();
    // [YACL internal use only]
    
    virtual bool _SelectionChanged (CL_Object&, long) = 0;
    // [YACL internal use only] Called by the selection when it is modified
    // by the application.
    
};




class CL_EXPORT UI_StringViewSingleSel: public UI_StringView {

public:
    UI_StringViewSingleSel (UI_VObjCollection* parent,  
                            const UI_Rectangle& shape,
                            UI_ViewID id = -1);
    // Model owned

    UI_StringViewSingleSel
        (UI_VObjCollection* parent, UI_StringSequence* model,
         const UI_Rectangle& shape, UI_ViewID id = -1);
    // Model not owned

#if defined(__MS_WINDOWS__)
    UI_StringViewSingleSel (UI_CompositeVObject* parent, UI_ViewID id,
                            UI_ViewHandle h);
    // [MS-Windows-specific] Resource-based construction.
    
#endif

    CL_Integer& Selection () {return _selection;};
    // Return the index of the currently selected string. This index is -1
    // if no string is currently selected. The return value may be assigned
    // to, thus modifying the selection.
    
protected:
    bool Select ();

    bool _SelectionChanged (CL_Object&, long);

    void _UpdateSelection ();
    
    CL_Integer _selection;
};



class CL_EXPORT UI_StringViewMultiSel: public UI_StringView {

public:
    UI_StringViewMultiSel (UI_VObjCollection* parent,  
                           const UI_Rectangle& shape,
                           UI_ViewID id = -1);
    // Model owned

    UI_StringViewMultiSel (UI_VObjCollection* parent,
                           UI_StringSequence* model,
                           const UI_Rectangle& shape, UI_ViewID id = -1);
    // Model not owned

#if defined(__MS_WINDOWS__)
    UI_StringViewMultiSel (UI_CompositeVObject* parent, UI_ViewID id,
                           UI_ViewHandle h);
    // [MS-Windows-specific] Resource-based construction

#endif

    CL_IntegerSet& Selection () {return _selection;};
    // Return the set of indices of strings that are currently selected. The
    // return value may be assigned to, thus modifying the selection.
    
protected:
    bool Select ();

    bool _SelectionChanged (CL_Object&, long);
    
    void _UpdateSelection ();
    
    CL_IntegerSet _selection;
};


#endif
