



#ifndef _stencil_h_ /* Sun Apr  2 13:02:04 1995 */
#define _stencil_h_



#if defined(__GNUC__)
#pragma interface
#endif


// A Stencil is a binary matrix used for masking when drawing on a
// DisplaySurface. 

class UI_Stencil {

public:
    UI_Stencil (short w = 1, short h = 1);
    // Constructor.
    
    UI_Stencil (const char data[], short w, short h);
    // Constructor: Build a Stencil from the given array of character
    // data. The data is interpreted as an array of bytes, containing $w$
    // rows and $h$ columns, with each cell being a single byte. The array
    // is interpreted in row-major order.

    UI_Stencil (const UI_Stencil&);
    // Copy constructor.
    
    ~UI_Stencil ();

    short Width () const {return _width;};
    // Return the width of this Stencil in bytes.
    
    short Height () const {return _height;};
    // Return the number of rows in the Stencil.
    
    char& Byte (short i, short j);
    // Return a reference to the byte at the given position.

    short Bit  (short i, short j) const;
    // Interpret the Stencil as an $m \times n$ array of bits, where $m$ is
    // the number of rows and $n$ is eight times the number of
    // columns. Return the bit in the $i$-th row and $j$-th column.
    

private:
    char* _data;
    short _width;
    short _height;

public:
    char* AsPtr() const {return _data;};
    // For internal use only.
    
};

#endif /* _stencil_h_ */
