

#if defined(__GNUC__)
#pragma implementation
#endif


#if defined(__MS_WINDOWS__)
#include <windows.h>
#elif defined(__OS2__)
#include <string.h>
#endif


#include "base/strgseq.h"
#include "ui/printjob.h"
#include "ui/applic.h"
#include "ui/cntroler.h"

UI_PrintJob::UI_PrintJob (const char* jobName)
{
#if defined(__MS_WINDOWS__)
    char printer[80];
    GetProfileString("windows", "device", "", printer, sizeof(printer) - 1);
    CL_String printerString (printer);
    CL_String device = printerString.Field (1, ",");
    CL_String driver = printerString.Field (2, ",");
    CL_String port   = printerString.Field (3, ",");
    _handle  = CreateDC (driver.AsPtr(), device.AsPtr(), port.AsPtr(), NULL);
    if (!_handle) {
        CL_Error::Warning ("UI_PrintJob constructor: printer init failed");
        return;
    }
    _horzPPM = ((float) GetDeviceCaps (_handle, LOGPIXELSX)) / 25.4;
    _vertPPM = ((float) GetDeviceCaps (_handle, LOGPIXELSY)) / 25.4;
    _horzPixels = GetDeviceCaps (_handle, HORZRES);
    _vertPixels = GetDeviceCaps (_handle, VERTRES);
    DOCINFO docInfo;
    docInfo.cbSize = sizeof (DOCINFO);
    docInfo.lpszDocName = jobName;
    docInfo.lpszOutput  = NULL;
    StartDoc (_handle, &docInfo);
    StartPage (_handle);
    _brush  = new UI_Brush (this, UI_Color (UIColor_White), UIBrush_Solid);
    _pen    = new UI_Pen   (this);
#elif defined(__OS2__)
    _handle = 0;
    char     printerData[256];
    static DRIVDATA driv = { sizeof (DRIVDATA) } ;
    char     printerName[34];
    DEVOPENSTRUC    dop ;

    // Get printer name
    PrfQueryProfileString (HINI_PROFILE, "PM_SPOOLER",
                           "PRINTER", ";",
                           printerName, sizeof printerName) ;
    CL_String printer (printerName);
    printer.Replace (";", "");

    // Get printer data
    PrfQueryProfileString (HINI_PROFILE, "PM_SPOOLER_PRINTER",
                           printer.AsPtr(), ";;;;",
                           printerData, sizeof printerData) ;

    CL_StringSequence seq = CL_String (printerData).Split (';');
    if (seq.Size() <= 0)
          return;
    dop.pszLogAddress = (char*) seq[2].AsPtr();
    CL_String driver  = seq[1];

    short n = driver.CharIndex ('.');
    if (n >= 0) {
        // (pchDelimiter = strchr (dop.pszDriverName, '.')) != NULL) {
        driver = seq[1] (0, n);
        CL_String suffix = seq[1].Suffix (n + 1);
        strncpy (driv.szDeviceName, suffix.AsPtr(),
                 sizeof (driv.szDeviceName)) ;
        dop.pdriv = &driv ;
    }
    else
        dop.pdriv = NULL ;

    dop.pszDriverName         = (char*) driver.AsPtr();
    dop.pszDataType           = "PM_Q_STD" ;
    HAB hab  = _TheApplication->Controller().AnchorBlockHandle();
    _printDC = DevOpenDC (hab, OD_QUEUED, "*", 4L, (PDEVOPENDATA) &dop, 0L);
    if (_printDC) {
        SIZEL pageSize = {0, 0};
        _handle = GpiCreatePS (hab, _printDC, &pageSize,
                               PU_ARBITRARY | GPIF_DEFAULT | GPIT_MICRO |
                               GPIA_ASSOC);
        GpiQueryPS (_handle, &_drawingArea);
    };
        
    
    long result = DevEscape (_printDC, DEVESC_STARTDOC, strlen (jobName),
                             (char*) jobName, NULL, NULL);
    if (!result)
        return;
    _brush  = new UI_Brush (this, UIColor_White, UIBrush_Solid);
    _pen    = new UI_Pen   (this);
#endif
    _font = new UI_Font (this);
}

UI_PrintJob::~UI_PrintJob ()
{
#if defined(__MS_WINDOWS__)
    EndPage    (_handle);
    EndDoc     (_handle);
    DeleteDC   (_handle);
#elif defined(__OS2__)
    DevEscape (_printDC, DEVESC_NEWFRAME, 0L, NULL, NULL, NULL);
    DevEscape (_printDC, DEVESC_ENDDOC,   0L, NULL, NULL, NULL);
    GpiDestroyPS (_handle);
    DevCloseDC   (_printDC);
#endif
}

bool UI_PrintJob::StartNewPage ()
{
#if defined(__MS_WINDOWS__)
    EndPage   (_handle);
    StartPage (_handle);
    return TRUE;
#elif defined(__OS2__)
    return DevEscape (_printDC, DEVESC_NEWFRAME, 0L, NULL, NULL, NULL);
#endif
}



// 
// Query:
//     

double UI_PrintJob::HorzPixelsPerMM () const
{
    return _horzPPM;
}


double UI_PrintJob::VertPixelsPerMM () const
{
    return _vertPPM;
}



UI_Rectangle UI_PrintJob::DrawingArea() const
{
#if defined(__MS_WINDOWS__)
    return UI_DrawingSurface::DrawingArea ();
#elif defined(__OS2__)
    return UI_Rectangle (0, 0, _drawingArea.cx, _drawingArea.cy);
#endif
}



UI_Rectangle UI_PrintJob::DrawingAreaInMM () const
{
    return UI_DrawingSurface::DrawingAreaInMM ();
}


bool UI_PrintJob::DrawBitmap (const UI_Bitmap& b, const UI_Point& p)
{
#if defined (__MS_WINDOWS__) || defined(__OS2__)
    return UI_DrawingSurface::DrawBitmap (b, p);
#endif
}


bool UI_PrintJob::SupportsColor () const
{
#if defined(__OS2__)
    // Seems like if I use GpiSetColor on a printer context, then a black
    // color is shown as white, and everything else is shown as black.
    // (Happens on my PostScript printer.) So for now, PM  printing does not
    // include color support.
    return FALSE;
#else
    return TRUE;
#endif
}
