

#ifndef _piewedge_h_ /* Thu Jan  5 09:34:33 1995 */
#define _piewedge_h_



/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// This is a GraphicObject representing a pie wedge of an ellipse. This is a
// closed figure.

#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/arc.h"


class CL_EXPORT UI_Arc;
class CL_EXPORT UI_Ellipse;

class CL_EXPORT UI_PieWedge: public UI_GraphicObject {

public:
    UI_PieWedge (const UI_Rectangle& boundingRect, long startAngleDeg64, long
                 subtendedDeg64);
    // Construct a pie wedge of an ellipse. The PieWedge is part of the
    // ellipse whose
    // bounding rectangle is {\tt boundingRect}. Its starting point is at an
    // angle {$d$} degrees from the 3-o'clock position of {\tt boundingRect}
    // where $d = {\tt startAngleDeg64} * 64$, and it subtends an angle $s$
    // at the center of the ellipse, where $s = {\tt subtendedDeg64} * 64$,

    UI_PieWedge (const UI_Point &p1, const UI_Point &p2,
                 const UI_Point& origin);
    // Construct an arc of an ellipse with the points p1, p2 being the
    // start point and the end point and the origin being the center of
    // the ellipse.
    
    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point (0,0)) const;
    // Draw the ellipse on the surface {\tt sfc} (overrides inherited
    // method).

    bool Fill (UI_DrawingSurface& sfc) const;
    
    bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);
    // Override method inherited from GraphicObject. The implementation
    // reshapes the ellipse so that its bounding rectangle is the rectangle
    // whose diagonally opposite points are p1 and p2.

    UI_Rectangle BoundingRectangle() const;
    // Returns the bounding rectangle of the ellipse of which this pie wedge
    // is part.

    UI_PointPair EndPoints() const;

    UI_HitTest HitTest (const UI_Point& p) const;
    // Hit testing: overrides method inherited from Graphic.
    
    bool IntersectsBoundary (const UI_Rectangle& r) const;

    long StartAngle() const;

    long SubtendedAngle() const;

    UI_Ellipse Ellipse() const;

    void StartAngle (long startAngle64);

    void SubtendedAngle (long subtAngle64);

    void Origin (const UI_Point &origin);
    
    const char* ClassName() const {return "UI_PieWedge";};

protected:

    UI_Rectangle _boundingEllipse;
    UI_Rectangle _boundingRect;
    long         _startAngle  ;
    long         _subtAngle   ;
    UI_Arc       _arc         ;

};




inline long UI_PieWedge::StartAngle() const
{
    return _startAngle;
}


inline long UI_PieWedge::SubtendedAngle() const
{
    return _subtAngle;
}


#endif /* _piewedge_h_ */
