



#ifndef _lineseg_h_ /* Sat Oct 29 09:53:51 1994 */
#define _lineseg_h_




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/graphic.h"

class CL_EXPORT UI_LineSegment: public  UI_GraphicObject {

public:
    UI_LineSegment (const UI_Point& p1, const UI_Point& p2);

    UI_LineSegment (const UI_Point& start, double slope, long length);

    UI_LineSegment ();

    UI_LineSegment& operator= (const UI_LineSegment& o);

    bool Intersects (const UI_LineSegment& l) const;
    // Tell whether the given line segment intersects this one.

    void operator= (const CL_Object& o);
    
    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point(0,0)) const;
    // Draw the line segment on the surface {\tt sfc}, translated so that
    // {\tt p} is treated as the origin of the co-ordinate system.

    bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);

    bool OnBoundary (const UI_Point& p) const;

    UI_HitTest HitTest (const UI_Point& p) const;
    // Hit testing: overrides method inherited from Graphic. This method
    // always returns either Outside or Boundary, never Inside, because
    // there is no ``inside'' of a line segment.
    
    UI_PointPair EndPoints () const;

    UI_PointPair PointsAtDistance (const UI_Point &, long);

    UI_Point Center () const;

    double Slope () const;
    
    bool Includes (const UI_Point& p) const {return OnBoundary (p);}
    // Includes is the same as OnBoundary, because this is a line.

    bool IntersectsBoundary (const UI_Rectangle& r) const;
    
    bool IsContainedIn (const UI_Rectangle& r) const;

    UI_Rectangle BoundingRectangle() const;


    const char* ClassName () const {return "UI_LineSegment";};

    
protected:
    UI_Point _p1, _p2;

};



#endif /* _lineseg_h_ */
