



#ifndef _ellipse_h_ /* Sat Oct 29 09:47:06 1994 */
#define _ellipse_h_



/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma interface
#endif

#include "ui/graphic.h"

class CL_EXPORT UI_Ellipse: public UI_GraphicObject {

public:
    UI_Ellipse (long major_axis, long minor_axis, UI_Point origin =
                UI_Point (0, 0));
    // Create an ellipse with given origin and given major and minor axes.
    // If the two axes are equal, the result is a circle with given
    // diameter.

    UI_Ellipse (const UI_Rectangle&);
    // Construct an ellipse whose bounding box is the given rectangle.
    
    UI_Ellipse ();
    // Create an ellipse at position (0, 0) of size 0.

    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point (0,0)) const;
    // Draw the ellipse on the surface {\tt sfc} (overrides inherited
    // method).

    bool Fill   (UI_DrawingSurface& s) const;
        
    
    bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);
    // Override method inherited from GraphicObject. The implementation
    // reshapes the ellipse so that its bounding rectangle is the rectangle
    // whose diagonally opposite points are p1 and p2.

    UI_HitTest HitTest (const UI_Point& p) const;
    // Hit testing: overrides method inherited from Graphic.
    
    UI_Rectangle BoundingRectangle() const;
    // Return the bounding rectangle of the ellipse.

    bool Includes (const UI_Point& p) const;
    
    bool IntersectsBoundary (const UI_Rectangle& r) const;
    // Return TRUE if the rectangle {\tt r} intersects the ellipse's
    // periphery. Return FALSE if the rectangle is either entirely inside or
    // entirely outside the ellipse.

    UI_Point PointAtAngle (double angleInDegrees) const;
    // Return the point on the ellipse's periphery at the given angle. This
    // point is obtained by drawing a vector from the ellipse's origin that
    // subtends the given angle with respect to the horizontal, and
    // determining where this vector intersects the ellipse's periphery.
    //
    // The angle is reckoned counterclockwise from the horizontal. So 90
    // degrees is vertical upwards.
    
    const char* ClassName() const {return "UI_Ellipse";};


protected:
    UI_Point _origin;
    long     _majorAxis;
    long     _minorAxis;

};

#endif /* _ellipse_h_ */
