
#ifndef _colormap_h_ /* Tue Oct 25 16:34:51 1994 */
#define _colormap_h_






/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// A ColorMap is a collection of distinct colors, each identified by a
// ColorMapHandle. A color may be added to the ColorMap via the Add
// method, and this returns the map-specific handle associated with that
// color. (If the map is full, a zero handle is returned.) A color
// currently in the ColorMap may be removed via the Remove method.


#if defined(__GNUC__)
#pragma interface
#endif

#include "base/defs.h"
#include "ui/uidefs.h"

class CL_EXPORT UI_DisplaySurface;
class CL_EXPORT UI_Color;

#if defined (__OS2__)
typedef HPAL    UI_ColorMapType;        // Temporary
struct UI_ColorMapEntry;                 // Temporary
// typedef PALETTEENTRY UI_ColorMapEntry;

#elif defined (__MS_WINDOWS__)
#include <windows.h>
typedef HPALETTE    UI_ColorMapType;
typedef PALETTEENTRY UI_ColorMapEntry;

#elif defined (__X_MOTIF__)
typedef ulong UI_ColorMapType;
typedef ulong UI_ColorMapEntry;

#endif

typedef ulong UI_ColorMapHandle;

typedef struct {
    short red;
    short green;
    short blue;
} UI_ColorMapValues;


class UI_ColorMap {

public:
    UI_ColorMap  (UI_DisplaySurface& sfc);

    ~UI_ColorMap();

    bool Load (const UI_ColorMapValues v []);
    // Load entries into the colormap from a 'C' style structure.
    
    UI_ColorMapHandle Add (const UI_Color& c);
    // Add color c to the ColorMap (if it's not already there), and return
    // the handle for the added color. Return 0 if no room in the ColorMap.

    bool Remove (UI_ColorMapHandle h);
    // Remove the color indicated by the handle. That slot remains empty

    UI_ColorMapHandle Match (const UI_Color& c);
    // Return the handle of the color in the map that matches c as closely
    // as possible.

    UI_ColorMapHandle ExactMatch  (const UI_Color& c);
    // Return the handle of the color c if it is in the ColorMap. Return 0
    // if not.

    UI_Color operator[] (UI_ColorMapHandle &h) const;
    // Return the color corresponding to the handle.

    bool Install();
    // Install the virtual colormap as the physical colormap.

    bool UseDefault();
    // Use the default colormap as the colormap.

    bool Clear();
    // Clear all the entries of the colormap.

    bool Replace (const UI_ColorMapHandle h, UI_Color &c);
    // Replace the entry indicated by the handle, with the specified color.
    
    bool operator==  (const UI_ColorMap& cmap) const;

    void operator= (const UI_ColorMap& cmap);

    const char* ClassName () const { return "UI_ColorMap";};
    
protected:

    ushort                 _numcolors;
    UI_DisplaySurface&     _dsurface;
    static UI_ColorMapType _defaultcmap;
    UI_ColorMapType        _cmap;
    UI_ColorMapEntry*      _colors;
};


#endif /* _colormap_h_ */











