

#ifndef _chord_h_ /* Thu Jan  5 09:36:32 1995 */
#define _chord_h_



/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// This is a GraphicObject representing a chord of an ellipse. This is a
// closed figure.


#if defined(__GNUC__)
#pragma interface
#endif

#include "ui/graphic.h"

class CL_EXPORT UI_Arc;
class CL_EXPORT UI_Ellipse;
class CL_EXPORT UI_LineSegment;

class CL_EXPORT UI_Chord: public UI_GraphicObject {

public:
    UI_Chord (const UI_Rectangle& boundingRect, long startAngleDeg64,
              long subtendedDeg64);
    // Construct a chord of an ellipse. The Chord is part of the
    // ellipse whose
    // bounding rectangle is {\tt boundingRect}. Its starting point is at an
    // angle {$d$} degrees from the 3-o'clock position of {\tt boundingRect}
    // where $d = {\tt startAngleDeg64} * 64$, and it subtends an angle $s$
    // at the center of the ellipse, where $s = {\tt subtendedDeg64} * 64$.
    // Angles are reckoned counter-clockwise.

    UI_Chord (const UI_Point &p1, const UI_Point &p2, const UI_Point& origin);
    // Construct a chord of an ellipse with the points p1, p2 being the
    // start point and the end point and the origin being the center of
    // the ellipse.    

    UI_Chord ();
    // Construct a chord with zero radii at the origin.
    
    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point (0,0)) const;
    // Draw the chord on the surface {\tt sfc} (overrides inherited
    // method).

    bool Fill (UI_DrawingSurface& sfc) const;
    
    bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);
    // Override method inherited from GraphicObject. The implementation
    // reshapes the ellipse so that its bounding rectangle is the rectangle
    // whose diagonally opposite points are p1 and p2.


    UI_Point Center () const {return UI_Point (_xOrigin, _yOrigin);};
    // Return the center of the ellipse of this chord.
    
    UI_Rectangle BoundingRectangle() const;
    // Returns the bounding rectangle of the ellipse of which this chord is
    // part.

    UI_PointPair EndPoints () const;

    UI_HitTest HitTest (const UI_Point& p) const;
    // Hit testing: overrides method inherited from Graphic.
    
    bool IntersectsBoundary (const UI_Rectangle& r) const;

    long StartAngle() const;

    long SubtendedAngle() const;

    UI_Ellipse Ellipse() const;
    // Return the ellipse of which this chord is part.

    UI_LineSegment Line () const;
    // Return the line segment joining the two end points.

    UI_Arc Arc () const;
    // Return the arc of this chord.
    
    void StartAngle (long startAngle64);

    void SubtendedAngle (long subtAngle64);

    void Origin (const UI_Point &origin);


    UI_Chord& operator= (const UI_Chord&);

    void operator= (const CL_Object& o)
        {if (o.IsA (*this)) *this = (const UI_Chord&) o;};
    
    const char* ClassName() const {return "UI_Chord";};

protected:
    long   _startAngle; 
    long   _subtAngle;  
    long   _xOrigin;    
    long   _yOrigin;    
    long   _major;      
    long   _minor;
};                            
                              
                              
                              
                              
inline long UI_Chord::StartAngle() const
{
    return _startAngle;
}


inline long UI_Chord::SubtendedAngle() const
{
    return _subtAngle;
}


#endif /* _chord_h_ */
