

/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif


#include "ui/canvas.h"
#include "ui/color.h"
#include "ui/dsplsurf.h"

#if defined(__X_MOTIF__)
#include <Xm/DrawingA.h>
#endif


UI_Canvas::UI_Canvas (UI_VObjCollection* parent, const UI_Rectangle& shape,
                      UI_ViewID id)
: UI_VisualObject (parent, shape, id)
{
#if defined(__MS_WINDOWS__)
    _style = WS_VISIBLE | WS_BORDER | WS_CHILD;
#elif defined(__OS2__)
    _style = WS_VISIBLE;
#endif
   _fgColor = UI_Color (UIColor_Black);
   _bgColor = UI_Color (UIColor_White);
}



UI_WindowClass UI_Canvas::WindowClass () const
{
#if defined(__MS_WINDOWS__) || defined(__OS2__)
    return _YACLWindowClassName;
#elif defined(__X_MOTIF__)
    return xmDrawingAreaWidgetClass;
#endif
}



void UI_Canvas::_PrivateInitialize ()
{
    UI_VisualObject::_PrivateInitialize ();
    CreateDisplaySurface ();
}


void UI_Canvas::Finalize ()
{
    DestroyDisplaySurface ();
    UI_VisualObject::Finalize ();
}


