



#ifndef _btngroup_h_ /* Wed Mar 30 08:49:46 1994 */
#define _btngroup_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


// Author: M. A. Sridhar





// A ButtonGroup is a CompositeVObject representing a group of toggle
// buttons.  This is an abstract class.

#if defined(__GNUC__)
#pragma interface
#endif


#include "base/intset.h"
#include "ui/vobjcoll.h"


class CL_EXPORT UI_ButtonGroup: public UI_VObjCollection {

public:

    virtual UI_WindowClass WindowClass () const;
    // Override method inherited from {\small\tt UI_VisualObject}.

    const char* ClassName () const {return "UI_ButtonGroup";};
    // Override method inherited from {\small\tt CL_Object}.
    
protected:

    UI_ButtonGroup (UI_VObjCollection* parent, const UI_Rectangle& shape,
                    UI_ViewID id = -1);
    // Constructor: creates an empty ButtonGroup as a child of {\tt
    // parent}, with the given shape and view ID.

#if defined(__MS_WINDOWS__)
    UI_ButtonGroup (UI_VObjCollection* parent,  UI_ViewID id,
                    UI_ViewHandle h);
    // Resource-based construction (only under MS-Windows). This assumes
    // that (1) all (and only) the buttons in the group are geometrically
    // contained within the button group box's rectangle,  (2) the
    // contained buttons occur immediately after the group box in the
    // resource file ordering, and (3) the group box has a valid id.
    // Therefore, this does not allow (in particular) for groups within groups.

#endif
    
    ~UI_ButtonGroup ();
    // Protected, to discourage direct destruction. (All YACL
    // VisualObjects are destroyed by the Controller, and must not be
    // deleted by a user program.)

    bool MakeVisualElement ();

    void MakeInvisible ();
    // Override the inherited virtual method.
    
    void MakeVisible ();
    // Override the inherited virtual method.

    void _PrivateInitialize ();

    bool _TitleChanged (CL_Object&, long);
    
    bool _FontChanged  (CL_Object&, long);
    

#if defined(__X_MOTIF__)
private:
    UI_ViewHandle  _frameWidget; // The frame (parent of the button group)
    UI_ViewHandle  _frameLabel;  // Label of the frame

#endif
#if defined(__MS_WINDOWS__) || defined(__OS2__)

private:
    bool _GetFocus (CL_Object&, long);
    // [MS-Windows=specific]
    
#endif

#if defined(__OS2__)

private:
    void _Subclass ();
    // [OS/2-specific]

    PFNWP _oldProc;

    static MRESULT EXPENTRY ButtonGroupProc (HWND hWnd, ULONG msg,
                                             MPARAM p1, MPARAM p2);
    // [OS/2-specific]
    
#endif


#if defined(__MS_WINDOWS__) || defined(__OS2__)
public:
    void TakeFocus ();
    // [Specific to OS/2 and Windows. YACL internal use only.]

#endif
    
};

                     

#endif /* _btngroup_h_ */
