
/*
 *@@ xdebug.c:
 *      This file contains the following major XWorkplace components:
 *      --  DbgFolder SOM stuff
 *
 *      The classes in this file are "hidden" in the XDEBUG.DLL
 *      file and not required for XWorkplace's operation. They
 *      may be used however to debug WPS classes.
 *
 *      These classes override all methods which IBM has documented
 *      for them. In order to use these classes, do the following:
 *
 *      a)  Register the classes with the WPS class list.
 *      b)  Create an object of this class manually.
 *
 *      After the next Desktop restart, you'll see an additional
 *      "Debug" menu item in all object context menus, where
 *      you can enable debugging for this one object only.
 *      This requires that PMPRINTF be properly installed.
 *
 */

/*
 *      Copyright (C) 1999-2002 Ulrich Mller.
 *      This file is part of the XWorkplace source package.
 *      XWorkplace is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XWorkplace main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitctm: 2.41
 */

#ifndef SOM_Module_xdebug_folder_Source
#define SOM_Module_xdebug_folder_Source
#endif
#define DbgFolder_Class_Source
#define M_DbgFolder_Class_Source

#define INCL_DOS
#define INCL_WIN
#include <os2.h>

#include <string.h>
#include <stdio.h>

// generic headers
#include "setup.h"                      // code generation and debugging options

#include "helpers\ras.h"
#include "helpers\winh.h"

#include "xdebug_folder.ih"

#include "shared\common.h"
#include "shared\wpsh.h"

#pragma hdrstop

static BOOL    G_fDebugFolderInit = FALSE;

/*
 * InstanceMethodDebug:
 * EndInstanceMethodDebug:
 *      two monster macros for printing method information
 *      using PMPRINTF.
 *      These print object and method information if _fDebugThis
 *      is TRUE (which can be set from the new context menu item
 *      inserted by DbgFolder::wpModifyPopupMenu).
 *      This can only be used in instance methods, not class methods,
 *      but is not limited to DbgFolder methods.
 *
 *      Note: these macros can only be used together. Using
 *      only one of them will have the compiler complain.
 *      Also, do _not_ modify _fDebugThis in between these
 *      two macros, or the WPS will crash.
 */

//         DosSysTrace(254, strlen(method), __LINE__, method);         \
//         PSZ     __pszObjectTitle = NULL;                            \
//             __pszObjectTitle = _wpQueryTitle(somSelf);              \
/*             SOMClass *pClass = _somGetClass(somSelf);               \
            PSZ __pszClassName = "?";                               \
            if (pClass) __pszClassName = _somGetName(pClass);       \
            */

#define InstanceMethodDebug(class, method)                 \
    {                                                               \
        DbgFolderData *pDbgFolderData = DbgFolderGetData(somSelf);  \
        PSZ __pszClass = class;                                     \
        PSZ __pszMethod = method;                                   \
        CHAR    __szIndent[400];                                    \
        if (pDbgFolderData->fDebugThis)                           \
        {                                                           \
            ULONG __ulOfs = sprintf(__szIndent, "0x%lX ++ ", somSelf);    \
            memset(__szIndent + __ulOfs, ' ', pDbgFolderData->ulIndent);      \
            strcpy(&(__szIndent[__ulOfs + pDbgFolderData->ulIndent]), "%s::%s"); \
            _Pmpf((__szIndent,                                      \
                        class,                                      \
                        method));                                   \
            pDbgFolderData->ulIndent += 4;                        \
        }

#define EndInstanceMethodDebug()                                    \
        if (pDbgFolderData->fDebugThis)                           \
        {                                                           \
            ULONG __ulOfs = sprintf(__szIndent, "0x%lX -- ", somSelf);    \
            pDbgFolderData->ulIndent -= 4;                        \
            memset(__szIndent + __ulOfs, ' ', pDbgFolderData->ulIndent);      \
            strcpy(&(__szIndent[__ulOfs + pDbgFolderData->ulIndent]), "End of %s::%s"); \
            _Pmpf((__szIndent,                                      \
                        __pszClass,                                 \
                        __pszMethod));                              \
        }                                                           \
    }

/*
 * DbgFolderMethodDebug:
 *      replace the default SOM method debug macro
 *      for DbgFolder, using the macros above.
 */

#undef DbgFolderMethodDebug
#define DbgFolderMethodDebug(class, method) InstanceMethodDebug(class, method)

// menu item ID used for "Debug" menu item
#define ID_DOMI_DEBUGTHIS   WPMENUID_USER+2000
#define ID_DOMI_DEBUGALL    WPMENUID_USER+2001

/* ******************************************************************
 *
 *   here come the DbgFolder instance methods
 *
 ********************************************************************/

SOM_Scope void SOMLINK dfdr_somDefaultInit(DbgFolder *somSelf,
                                           somInitCtrl* ctrl)
{
    DbgFolderData *somThis; /* set in BeginInitializer */
    somInitCtrl globalCtrl;
    somBooleanVector myMask;
    // DbgFolderMethodDebug("DbgFolder","somDefaultInit");
    DbgFolder_BeginInitializer_somDefaultInit;

    /*
     * local DbgFolder initialization code added by programmer
     */
    DbgFolderMethodDebug("DbgFolder","somDefaultInit");

    _fDebugThis = G_fDebugFolderInit;  // set this to the global for instantiation;
                            // this will be reset by wpObjectReady
    _ulIndent = 0;

    DbgFolder_Init_WPFolder_somDefaultInit(somSelf, ctrl);

    EndInstanceMethodDebug();
}


SOM_Scope DbgFolder * SOMLINK dfdr_somDefaultAssign(DbgFolder *somSelf,
                                                    somAssignCtrl* ctrl,
                                                    SOMObject* fromObj)
{
    DbgFolderData *somThis; /* set in BeginAssignmentOp */
    somAssignCtrl globalCtrl;
    somBooleanVector myMask;
    DbgFolderMethodDebug("DbgFolder","somDefaultAssign");
    DbgFolder_BeginAssignmentOp;

    DbgFolder_Assign_WPFolder_somDefaultAssign(somSelf, ctrl, fromObj);

    /*
     * local DbgFolder assignmentOp code added by programmer
     */

    EndInstanceMethodDebug();

    return somSelf;
}


SOM_Scope DbgFolder * SOMLINK dfdr_somDefaultConstAssign(DbgFolder *somSelf,
                                                         somAssignCtrl* ctrl,
                                                         SOMObject* fromObj)
{
    DbgFolderData *somThis; /* set in BeginAssignmentOp */
    somAssignCtrl globalCtrl;
    somBooleanVector myMask;
    DbgFolderMethodDebug("DbgFolder","somDefaultConstAssign");
    DbgFolder_BeginAssignmentOp;

    DbgFolder_Assign_WPFolder_somDefaultConstAssign(somSelf, ctrl, fromObj);

    /*
     * local DbgFolder assignmentOp code added by programmer
     */

    EndInstanceMethodDebug();

    return somSelf;
}


SOM_Scope void  SOMLINK dfdr_somDefaultConstCopyInit(DbgFolder *somSelf,
                                                     somInitCtrl* ctrl,
                                                     SOMObject* fromObj)
{
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_somDefaultConstCopyInit");

    /* DbgFolder_parent_WPFolder_somDefaultConstCopyInit(somSelf,
                                                      ctrl, fromObj); */
        // doesn't exist
    EndInstanceMethodDebug();
}

SOM_Scope void  SOMLINK dfdr_somDefaultCopyInit(DbgFolder *somSelf,
                                                somInitCtrl* ctrl,
                                                SOMObject* fromObj)
{
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_somDefaultCopyInit");

    /* DbgFolder_parent_WPFolder_somDefaultCopyInit(somSelf, ctrl,
                                                 fromObj); */
        // doesn't exist
    EndInstanceMethodDebug();
}

SOM_Scope void  SOMLINK dfdr_somUninit(DbgFolder *somSelf)
{
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_somUninit");

    dfdr_somDestruct(somSelf, FALSE, (somDestructCtrl *) NULL);
    EndInstanceMethodDebug();
}

SOM_Scope void SOMLINK dfdr_somDestruct(DbgFolder *somSelf, octet doFree,
                                        somDestructCtrl* ctrl)
{
    DbgFolderData *somThis; /* set in BeginDestructor */
    somDestructCtrl globalCtrl;
    somBooleanVector myMask;
    DbgFolderMethodDebug("DbgFolder","dfdr_somDestruct");
    DbgFolder_BeginDestructor;

    /*
     * local DbgFolder deinitialization code added by programmer
     */

    DbgFolder_EndDestructor;
    EndInstanceMethodDebug();
}


SOM_Scope void  SOMLINK dfdr_wpInitData(DbgFolder *somSelf)
{
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpInitData");

    DbgFolder_parent_WPFolder_wpInitData(somSelf);
    EndInstanceMethodDebug();
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetup(DbgFolder *somSelf, PSZ pszSetupString)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetup");

    if (_fDebugThis)
        _Pmpf(("        setup string: %s", (pszSetupString) ? pszSetupString : "NULL"));

    rc = (DbgFolder_parent_WPFolder_wpSetup(somSelf, pszSetupString));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetupOnce(DbgFolder *somSelf,
                                         PSZ pszSetupString)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetupOnce");

    if (_fDebugThis)
        _Pmpf(("        setup string: %s", (pszSetupString) ? pszSetupString : "NULL"));

    rc = (DbgFolder_parent_WPFolder_wpSetupOnce(somSelf, pszSetupString));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope void  SOMLINK dfdr_wpObjectReady(DbgFolder *somSelf,
                                           ULONG ulCode, WPObject* refObject)
{
    DbgFolderData *somThis = DbgFolderGetData(somSelf);

    if ((ulCode & OR_REFERENCE) && (refObject))
    {
        DbgFolderData *somThat = DbgFolderGetData(refObject);
        _fDebugThis = somThat->fDebugThis;
    }
    else
        // newly instantiated:
        _fDebugThis = FALSE;

    DbgFolderMethodDebug("DbgFolder","dfdr_wpObjectReady");

    if ((ulCode & OR_REFERENCE) && (refObject))
        _Pmpf(("           OR_REFERENCE set"));

    DbgFolder_parent_WPFolder_wpObjectReady(somSelf, ulCode,
                                            refObject);
    EndInstanceMethodDebug();
}

SOM_Scope BOOL  SOMLINK dfdr_wpIsObjectInitialized(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpIsObjectInitialized");

    rc = (DbgFolder_parent_WPFolder_wpIsObjectInitialized(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpIsDeleteable(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpIsDeleteable");

    rc = (DbgFolder_parent_WPFolder_wpIsDeleteable(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpDelete(DbgFolder *somSelf, ULONG fConfirmations)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpDelete");

    rc = (DbgFolder_parent_WPFolder_wpDelete(somSelf, fConfirmations));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpConfirmDelete(DbgFolder *somSelf,
                                              ULONG fConfirmations)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpConfirmDelete");

    rc = (DbgFolder_parent_WPFolder_wpConfirmDelete(somSelf,
                                                      fConfirmations));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpFree(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpFree");

    rc = (DbgFolder_parent_WPFolder_wpFree(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope void  SOMLINK dfdr_wpUnInitData(DbgFolder *somSelf)
{
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpUnInitData");

    DbgFolder_parent_WPFolder_wpUnInitData(somSelf);
    EndInstanceMethodDebug();
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetError(DbgFolder *somSelf, ULONG ulErrorId)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetError");

    rc = (DbgFolder_parent_WPFolder_wpSetError(somSelf, ulErrorId));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryError(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryError");

    rc = (DbgFolder_parent_WPFolder_wpQueryError(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope void  SOMLINK dfdr_wpLockObject(DbgFolder *somSelf)
{
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpLockObject");

    DbgFolder_parent_WPFolder_wpLockObject(somSelf);
    EndInstanceMethodDebug();
}

SOM_Scope BOOL  SOMLINK dfdr_wpUnlockObject(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpUnlockObject");

    rc = (DbgFolder_parent_WPFolder_wpUnlockObject(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpAssertObjectMutexSem(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpAssertObjectMutexSem");

    rc = (DbgFolder_parent_WPFolder_wpAssertObjectMutexSem(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpReleaseObjectMutexSem(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpReleaseObjectMutexSem");

    rc = (DbgFolder_parent_WPFolder_wpReleaseObjectMutexSem(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpRequestObjectMutexSem(DbgFolder *somSelf,
                                                      ULONG ulTimeout)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpRequestObjectMutexSem");

    rc = (DbgFolder_parent_WPFolder_wpRequestObjectMutexSem(somSelf,
                                                              ulTimeout));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSaveImmediate(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSaveImmediate");

    rc = (DbgFolder_parent_WPFolder_wpSaveImmediate(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSaveDeferred(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSaveDeferred");

    rc = (DbgFolder_parent_WPFolder_wpSaveDeferred(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSaveState(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSaveState");

    rc = (DbgFolder_parent_WPFolder_wpSaveState(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpRestoreState(DbgFolder *somSelf,
                                            ULONG ulReserved)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpRestoreState");

    rc = (DbgFolder_parent_WPFolder_wpRestoreState(somSelf,
                                                     ulReserved));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PMINIRECORDCORE  SOMLINK dfdr_wpCnrInsertObject(DbgFolder *somSelf,
                                                          HWND hwndCnr,
                                                          PPOINTL pptlIcon,
                                                          PMINIRECORDCORE preccParent,
                                                          PRECORDINSERT pRecInsert)
{
    PMINIRECORDCORE rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpCnrInsertObject");

    if (_fDebugThis)
    {
        _Pmpf(("        hwndCnr: 0x%lX", hwndCnr));
        _Pmpf(("        pptlIcon: 0x%lX", pptlIcon));
        if (pptlIcon)
        {
            _Pmpf(("            x: %d", pptlIcon->x));
            _Pmpf(("            y: %d", pptlIcon->y));
        }
        _Pmpf(("        preccParent: 0x%lX", preccParent));
        _Pmpf(("        preccInsert: 0x%lX", pRecInsert));
    }

    rc = (DbgFolder_parent_WPFolder_wpCnrInsertObject(somSelf,
                                                        hwndCnr,
                                                        pptlIcon,
                                                        preccParent,
                                                        pRecInsert));

    if (_fDebugThis)
    {
        _Pmpf(("        wpCnrInsertObject: returning precc: 0x%lX", rc));
    }
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpCnrRemoveObject(DbgFolder *somSelf,
                                               HWND hwndCnr)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpCnrRemoveObject");

    rc = (DbgFolder_parent_WPFolder_wpCnrRemoveObject(somSelf,
                                                        hwndCnr));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpCnrSetEmphasis(DbgFolder *somSelf,
                                              ULONG ulEmphasisAttr,
                                              BOOL fTurnOn)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpCnrSetEmphasis");

    rc = (DbgFolder_parent_WPFolder_wpCnrSetEmphasis(somSelf,
                                                       ulEmphasisAttr,
                                                       fTurnOn));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope void  SOMLINK dfdr_wpCnrRefreshDetails(DbgFolder *somSelf)
{
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpCnrRefreshDetails");

    DbgFolder_parent_WPFolder_wpCnrRefreshDetails(somSelf);
    EndInstanceMethodDebug();
}

SOM_Scope PULONG  SOMLINK dfdr_wpQueryContainerFlagPtr(DbgFolder *somSelf)
{
    PULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryContainerFlagPtr");

    rc = (DbgFolder_parent_WPFolder_wpQueryContainerFlagPtr(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpConfirmObjectTitle(DbgFolder *somSelf,
                                                   WPFolder* Folder,
                                                   WPObject** ppDuplicate,
                                                   PSZ pszTitle,
                                                   ULONG cbTitle,
                                                   ULONG menuID)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpConfirmObjectTitle");

    rc = (DbgFolder_parent_WPFolder_wpConfirmObjectTitle(somSelf,
                                                           Folder,
                                                           ppDuplicate,
                                                           pszTitle,
                                                           cbTitle,
                                                           menuID));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope WPObject*  SOMLINK dfdr_wpCreateFromTemplate(DbgFolder *somSelf,
                                                       WPFolder* folder,
                                                       BOOL fLock)
{
    WPObject *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpCreateFromTemplate");

    rc = (DbgFolder_parent_WPFolder_wpCreateFromTemplate(somSelf,
                                                           folder,
                                                           fLock));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope void  SOMLINK dfdr_wpCopiedFromTemplate(DbgFolder *somSelf)
{
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpCopiedFromTemplate");

    DbgFolder_parent_WPFolder_wpCopiedFromTemplate(somSelf);
    EndInstanceMethodDebug();
}

SOM_Scope WPObject*  SOMLINK dfdr_wpCreateAnother(DbgFolder *somSelf,
                                                  PSZ pszTitle,
                                                  PSZ pszSetupEnv,
                                                  WPFolder* Folder)
{
    WPObject *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpCreateAnother");

    rc = (DbgFolder_parent_WPFolder_wpCreateAnother(somSelf,
                                                      pszTitle,
                                                      pszSetupEnv,
                                                      Folder));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope WPObject*  SOMLINK dfdr_wpCreateShadowObject(DbgFolder *somSelf,
                                                       WPFolder* Folder,
                                                       BOOL fLock)
{
    WPObject *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpCreateShadowObject");

    rc = (DbgFolder_parent_WPFolder_wpCreateShadowObject(somSelf,
                                                           Folder,
                                                           fLock));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope WPObject*  SOMLINK dfdr_wpCreateShadowObjectExt(DbgFolder *somSelf,
                                                          WPFolder* Folder,
                                                          BOOL fLock,
                                                          PSZ pszSetup,
                                                          M_WPObject* shadowClass)
{
    WPObject *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpCreateShadowObjectExt");

    rc = (DbgFolder_parent_WPFolder_wpCreateShadowObjectExt(somSelf,
                                                              Folder,
                                                              fLock,
                                                              pszSetup,
                                                              shadowClass));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope WPObject*  SOMLINK dfdr_wpCopyObject(DbgFolder *somSelf,
                                               WPFolder* Folder,
                                               BOOL fLock)
{
    WPObject *rc;
    DbgFolderMethodDebug("DbgFolder","dfdr_wpCopyObject");

    rc = (DbgFolder_parent_WPFolder_wpCopyObject(somSelf, Folder,
                                                   fLock));

    if (rc)
    {
        DbgFolderData *somThis = DbgFolderGetData(somSelf);
        DbgFolderData *somThat = DbgFolderGetData(rc);
        _Pmpf(("0x%lX --                wpCopyObject returned 0x%lX", somSelf, rc));

        somThat->fDebugThis = _fDebugThis;
    }

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpMoveObject(DbgFolder *somSelf,
                                          WPFolder* Folder)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpMoveObject");

    rc = (DbgFolder_parent_WPFolder_wpMoveObject(somSelf, Folder));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL32  SOMLINK dfdr_wpReplaceObject(DbgFolder *somSelf,
                                               WPObject* targetObject,
                                               BOOL32 fMove)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpReplaceObject");

    rc = (DbgFolder_parent_WPFolder_wpReplaceObject(somSelf,
                                                      targetObject,
                                                      fMove));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL32  SOMLINK dfdr_wpSetTaskRec(DbgFolder *somSelf,
                                            PTASKREC pNew, PTASKREC pOld)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetTaskRec");

    if (_fDebugThis)
    {
        _Pmpf(("        pTaskRecNew pre:"));
        wpshDumpTaskRec(somSelf, "ddf_wpSetTaskRec", pNew);
        _Pmpf(("        pTaskRecOld pre:"));
        wpshDumpTaskRec(somSelf, "ddf_wpSetTaskRec", pOld);
        _Pmpf(("        ++ Now calling parent"));
    }

    rc = (DbgFolder_parent_WPFolder_wpSetTaskRec(somSelf, pNew,
                                                   pOld));

    if (_fDebugThis)
    {
        _Pmpf(("        -- parent is done;"));

        _Pmpf(("        pTaskRecNew post:"));
        wpshDumpTaskRec(somSelf, "ddf_wpSetTaskRec", pNew);
        _Pmpf(("        pTaskRecOld post:"));
        wpshDumpTaskRec(somSelf, "ddf_wpSetTaskRec", pOld);
    }

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PTASKREC  SOMLINK dfdr_wpFindTaskRec(DbgFolder *somSelf)
{
    PTASKREC rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpFindTaskRec");

    rc = (DbgFolder_parent_WPFolder_wpFindTaskRec(somSelf));

    if (_fDebugThis)
    {
        _Pmpf(("        -- wpFindTaskRec parent is done;"));
        wpshDumpTaskRec(somSelf, "found pTaskRec", rc);
    }

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetTitle(DbgFolder *somSelf, PSZ pszNewTitle)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetTitle");

    if (_fDebugThis)
    {
        _Pmpf(("            new title: %s", pszNewTitle));
    }

    rc = (DbgFolder_parent_WPFolder_wpSetTitle(somSelf, pszNewTitle));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PSZ  SOMLINK dfdr_wpQueryTitle(DbgFolder *somSelf)
{
    PSZ rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryTitle");

    rc = (DbgFolder_parent_WPFolder_wpQueryTitle(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetStyle(DbgFolder *somSelf, ULONG ulNewStyle)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetStyle");

    rc = (DbgFolder_parent_WPFolder_wpSetStyle(somSelf, ulNewStyle));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryStyle(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryStyle");

    rc = (DbgFolder_parent_WPFolder_wpQueryStyle(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpModifyStyle(DbgFolder *somSelf,
                                           ULONG ulStyleFlags,
                                           ULONG ulStyleMask)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpModifyStyle");

    rc = (DbgFolder_parent_WPFolder_wpModifyStyle(somSelf,
                                                    ulStyleFlags,
                                                    ulStyleMask));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetFolder(DbgFolder *somSelf,
                                         WPObject* container)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetFolder");

    if (_fDebugThis)
        _Pmpf(("            new folder: 0x%lX (%s)",
                    container,
                    (container) ? _wpQueryTitle(container) : "NULL"));

    rc = (DbgFolder_parent_WPFolder_wpSetFolder(somSelf, container));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope WPObject*  SOMLINK dfdr_wpQueryFolder(DbgFolder *somSelf)
{
    WPObject *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryFolder");

    rc = (DbgFolder_parent_WPFolder_wpQueryFolder(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetDefaultView(DbgFolder *somSelf,
                                              ULONG ulView)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetDefaultView");

    rc = (DbgFolder_parent_WPFolder_wpSetDefaultView(somSelf,
                                                       ulView));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryDefaultView(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryDefaultView");

    rc = (DbgFolder_parent_WPFolder_wpQueryDefaultView(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryConfirmations(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryConfirmations");

    rc = (DbgFolder_parent_WPFolder_wpQueryConfirmations(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryNameClashOptions(DbgFolder *somSelf,
                                                      ULONG menuID)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryNameClashOptions");

    rc = (DbgFolder_parent_WPFolder_wpQueryNameClashOptions(somSelf,
                                                              menuID));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope HWND  SOMLINK dfdr_wpDisplayMenu(DbgFolder *somSelf,
                                           HWND hwndOwner, HWND hwndClient,
                                           POINTL* ptlPopupPt,
                                           ULONG ulMenuType,
                                           ULONG ulReserved)
{
    HWND rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpDisplayMenu");

    rc = (DbgFolder_parent_WPFolder_wpDisplayMenu(somSelf,
                                                    hwndOwner,
                                                    hwndClient,
                                                    ptlPopupPt,
                                                    ulMenuType,
                                                    ulReserved));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpFilterPopupMenu(DbgFolder *somSelf,
                                                ULONG ulFlags,
                                                HWND hwndCnr,
                                                BOOL fMultiSelect)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpFilterPopupMenu");

    rc = (DbgFolder_parent_WPFolder_wpFilterPopupMenu(somSelf,
                                                        ulFlags,
                                                        hwndCnr,
                                                        fMultiSelect));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpModifyPopupMenu(DbgFolder *somSelf,
                                               HWND hwndMenu,
                                               HWND hwndCnr,
                                               ULONG iPosition)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpModifyPopupMenu");

    rc = (DbgFolder_parent_WPFolder_wpModifyPopupMenu(somSelf,
                                                        hwndMenu,
                                                        hwndCnr,
                                                        iPosition));

    if (rc)
    {
        winhInsertMenuItem(hwndMenu, MIT_END,
                           ID_DOMI_DEBUGTHIS,
                           "~Trace this object's method calls",
                           MIS_TEXT,
                           (_fDebugThis)
                                ? MIA_CHECKED
                                : 0);
        winhInsertMenuItem(hwndMenu, MIT_END,
                           ID_DOMI_DEBUGALL,
                           "~Trace all initialization method calls",
                           MIS_TEXT,
                           (G_fDebugFolderInit)
                                ? MIA_CHECKED
                                : 0);
    }

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpInsertPopupMenuItems(DbgFolder *somSelf,
                                                    HWND hwndMenu,
                                                    ULONG iPosition,
                                                    HMODULE hmod,
                                                    ULONG MenuID,
                                                    ULONG SubMenuID)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpInsertPopupMenuItems");

    rc = (DbgFolder_parent_WPFolder_wpInsertPopupMenuItems(somSelf,
                                                             hwndMenu,
                                                             iPosition,
                                                             hmod,
                                                             MenuID,
                                                             SubMenuID));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpMenuItemSelected(DbgFolder *somSelf,
                                                HWND hwndFrame,
                                                ULONG ulMenuId)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    BOOL    fNewDebug = _fDebugThis,
            fNewDebugAll = G_fDebugFolderInit;
    DbgFolderMethodDebug("DbgFolder","dfdr_wpMenuItemSelected");

    if (ulMenuId == ID_DOMI_DEBUGTHIS)
    {
        fNewDebug = !fNewDebug;
        rc = TRUE;
    }
    else if (ulMenuId == ID_DOMI_DEBUGALL)
    {
        fNewDebugAll = !fNewDebugAll;
        rc = TRUE;
    }
    else
    {
        _Pmpf(("            wpMenuItemSelected ulmenuID: 0x%lX", ulMenuId));

        rc = (DbgFolder_parent_WPFolder_wpMenuItemSelected(somSelf,
                                                         hwndFrame,
                                                         ulMenuId));
    }

    EndInstanceMethodDebug();
    _fDebugThis = fNewDebug;
    G_fDebugFolderInit = fNewDebugAll;
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpMenuItemHelpSelected(DbgFolder *somSelf,
                                                    ULONG MenuId)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpMenuItemHelpSelected");

    rc = (DbgFolder_parent_WPFolder_wpMenuItemHelpSelected(somSelf,
                                                             MenuId));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope HWND  SOMLINK dfdr_wpViewObject(DbgFolder *somSelf,
                                          HWND hwndCnr, ULONG ulView,
                                          ULONG param)
{
    HWND rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpViewObject");

    rc = (DbgFolder_parent_WPFolder_wpViewObject(somSelf, hwndCnr,
                                                   ulView, param));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope HWND  SOMLINK dfdr_wpOpen(DbgFolder *somSelf, HWND hwndCnr,
                                    ULONG ulView, ULONG param)
{
    HWND rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpOpen");

    rc = (DbgFolder_parent_WPFolder_wpOpen(somSelf, hwndCnr,
                                             ulView, param));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpRegisterView(DbgFolder *somSelf,
                                            HWND hwndFrame, PSZ pszViewTitle)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpRegisterView");

    rc = (DbgFolder_parent_WPFolder_wpRegisterView(somSelf,
                                                     hwndFrame,
                                                     pszViewTitle));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpClose(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpClose");

    rc = (DbgFolder_parent_WPFolder_wpClose(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpHide(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpHide");

    rc = (DbgFolder_parent_WPFolder_wpHide(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpRestore(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpRestore");

    rc = (DbgFolder_parent_WPFolder_wpRestore(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpAddToObjUseList(DbgFolder *somSelf,
                                               PUSEITEM pUseItem)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpAddToObjUseList");

    rc = (DbgFolder_parent_WPFolder_wpAddToObjUseList(somSelf,
                                                        pUseItem));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpDeleteFromObjUseList(DbgFolder *somSelf,
                                                    PUSEITEM pUseItem)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpDeleteFromObjUseList");

    rc = (DbgFolder_parent_WPFolder_wpDeleteFromObjUseList(somSelf,
                                                             pUseItem));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpCnrDeleteUseItem(DbgFolder *somSelf,
                                                HWND hwndCnr)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpCnrDeleteUseItem");

    rc = (DbgFolder_parent_WPFolder_wpCnrDeleteUseItem(somSelf,
                                                         hwndCnr));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PUSEITEM  SOMLINK dfdr_wpFindUseItem(DbgFolder *somSelf,
                                               ULONG type, PUSEITEM pCurrentItem)
{
    PUSEITEM rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpFindUseItem");

    rc = (DbgFolder_parent_WPFolder_wpFindUseItem(somSelf,
                                                    type, pCurrentItem));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PVIEWITEM  SOMLINK dfdr_wpFindViewItem(DbgFolder *somSelf,
                                                 ULONG flViews,
                                                 PVIEWITEM pCurrentItem)
{
    PVIEWITEM rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpFindViewItem");

    rc = (DbgFolder_parent_WPFolder_wpFindViewItem(somSelf,
                                                     flViews,
                                                     pCurrentItem));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSwitchTo(DbgFolder *somSelf, ULONG View)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSwitchTo");

    rc = (DbgFolder_parent_WPFolder_wpSwitchTo(somSelf, View));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpDoesObjectMatch(DbgFolder *somSelf,
                                               PVOID pvoidExtendedCriteria)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpDoesObjectMatch");

    rc = (DbgFolder_parent_WPFolder_wpDoesObjectMatch(somSelf,
                                                        pvoidExtendedCriteria));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetIcon(DbgFolder *somSelf, HPOINTER hptrNewIcon)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetIcon");

    rc = (DbgFolder_parent_WPFolder_wpSetIcon(somSelf, hptrNewIcon));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope HPOINTER  SOMLINK dfdr_wpQueryIcon(DbgFolder *somSelf)
{
    HPOINTER rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryIcon");

    rc = (DbgFolder_parent_WPFolder_wpQueryIcon(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetIconData(DbgFolder *somSelf,
                                           PICONINFO pIconInfo)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetIconData");

    rc = (DbgFolder_parent_WPFolder_wpSetIconData(somSelf,
                                                    pIconInfo));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryIconData(DbgFolder *somSelf,
                                              PICONINFO pIconInfo)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryIconData");

    rc = (DbgFolder_parent_WPFolder_wpQueryIconData(somSelf,
                                                      pIconInfo));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetDefaultIconPos(DbgFolder *somSelf,
                                                 PPOINTL pPointl)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetDefaultIconPos");

    if (pPointl)
    {
        _Pmpf(("            x: %d", pPointl->x));
        _Pmpf(("            y: %d", pPointl->y));
    }
    rc = (DbgFolder_parent_WPFolder_wpSetDefaultIconPos(somSelf,
                                                          pPointl));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 *
 *     * WPFileSystem methods overridden by DbgFolder:
 *
 */

SOM_Scope BOOL  SOMLINK dfdr_wpQueryDefaultIconPos(DbgFolder *somSelf,
                                                   PPOINTL pPointl)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryDefaultIconPos");

    rc = (DbgFolder_parent_WPFolder_wpQueryDefaultIconPos(somSelf,
                                                            pPointl));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetRealName(DbgFolder *somSelf,
                                           PSZ pszName)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetRealName");

    rc = (DbgFolder_parent_WPFolder_wpSetRealName(somSelf,
                                                    pszName));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetType(DbgFolder *somSelf, PSZ pszTypes,
                                       PFEA2LIST pfeal)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetType");

    rc = (DbgFolder_parent_WPFolder_wpSetType(somSelf, pszTypes,
                                                pfeal));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PSZ  SOMLINK dfdr_wpQueryType(DbgFolder *somSelf)
{
    PSZ rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryType");

    rc = (DbgFolder_parent_WPFolder_wpQueryType(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetAttr(DbgFolder *somSelf, ULONG attrFile)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetAttr");

    rc = (DbgFolder_parent_WPFolder_wpSetAttr(somSelf, attrFile));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryAttr(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryAttr");

    rc = (DbgFolder_parent_WPFolder_wpQueryAttr(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryCreation(DbgFolder *somSelf,
                                              FDATE* fdate, FTIME* ftime)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryCreation");

    rc = (DbgFolder_parent_WPFolder_wpQueryCreation(somSelf,
                                                      fdate,
                                                      ftime));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryLastAccess(DbgFolder *somSelf,
                                                FDATE* fdate,
                                                FTIME* ftime)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryLastAccess");

    rc = (DbgFolder_parent_WPFolder_wpQueryLastAccess(somSelf,
                                                        fdate,
                                                        ftime));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryLastWrite(DbgFolder *somSelf,
                                               FDATE* fdate,
                                               FTIME* ftime)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryLastWrite");

    rc = (DbgFolder_parent_WPFolder_wpQueryLastWrite(somSelf,
                                                       fdate,
                                                       ftime));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryFileSize(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryFileSize");

    rc = (DbgFolder_parent_WPFolder_wpQueryFileSize(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryEASize(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryEASize");

    rc = (DbgFolder_parent_WPFolder_wpQueryEASize(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpSetDateInfo(DbgFolder *somSelf,
                                            FILEFINDBUF4* pstFileFindBuf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetDateInfo");

    rc = (DbgFolder_parent_WPFolder_wpSetDateInfo(somSelf,
                                                    pstFileFindBuf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpSetFileSizeInfo(DbgFolder *somSelf,
                                                ULONG cbFileSize,
                                                ULONG cbEASize)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetFileSizeInfo");

    rc = (DbgFolder_parent_WPFolder_wpSetFileSizeInfo(somSelf,
                                                        cbFileSize,
                                                        cbEASize));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpRefresh(DbgFolder *somSelf, ULONG ulView,
                                       PVOID pReserved)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpRefresh");

    rc = (DbgFolder_parent_WPFolder_wpRefresh(somSelf, ulView,
                                                pReserved));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryRefreshFlags(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryRefreshFlags");

    rc = (DbgFolder_parent_WPFolder_wpQueryRefreshFlags(somSelf));

    if (_fDebugThis)
        _Pmpf(("            refresh flags: 0x%lX", rc));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetRefreshFlags(DbgFolder *somSelf,
                                               ULONG ulRefreshFlags)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetRefreshFlags");

    if (_fDebugThis)
        _Pmpf(("            new refresh flags: 0x%lX", ulRefreshFlags));

    rc = (DbgFolder_parent_WPFolder_wpSetRefreshFlags(somSelf,
                                                        ulRefreshFlags));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetTitleAndRenameFile(DbgFolder *somSelf,
                                                     PSZ pszNewTitle,
                                                     ULONG fConfirmations)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetTitleAndRenameFile");

    rc = (DbgFolder_parent_WPFolder_wpSetTitleAndRenameFile(somSelf,
                                                              pszNewTitle,
                                                              fConfirmations));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpConfirmRenameFileWithExt(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpConfirmRenameFileWithExt");

    rc = (DbgFolder_parent_WPFolder_wpConfirmRenameFileWithExt(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpVerifyUpdateAccess(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpVerifyUpdateAccess");

    rc = (DbgFolder_parent_WPFolder_wpVerifyUpdateAccess(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpAddUserItemsToPopupMenu(DbgFolder *somSelf,
                                                       HWND hwndMenu,
                                                       HWND hwndCnr,
                                                       ULONG iPosition)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpAddUserItemsToPopupMenu");

    rc = (DbgFolder_parent_WPFolder_wpAddUserItemsToPopupMenu(somSelf,
                                                                hwndMenu,
                                                                hwndCnr,
                                                                iPosition));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpIsDiskSwapped(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpIsDiskSwapped");

    rc = (DbgFolder_parent_WPFolder_wpIsDiskSwapped(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpQueryRealName(DbgFolder *somSelf,
                                             PSZ pszFilename,
                                             PULONG pcb, BOOL fQualified)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryRealName");

    rc = (DbgFolder_parent_WPFolder_wpQueryRealName(somSelf,
                                                      pszFilename,
                                                      pcb, fQualified));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PSZ  SOMLINK dfdr_wpQueryFilename(DbgFolder *somSelf,
                                            PSZ pszFilename,
                                            BOOL fQualified)
{
    PSZ rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryFilename");

    rc = (DbgFolder_parent_WPFolder_wpQueryFilename(somSelf,
                                                      pszFilename,
                                                      fQualified));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope WPFileSystem*  SOMLINK dfdr_wpQueryDisk(DbgFolder *somSelf)
{
    WPFileSystem *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryDisk");

    rc = (DbgFolder_parent_WPFolder_wpQueryDisk(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryDateInfo(DbgFolder *somSelf,
                                              FILEFINDBUF4* pstFileFindBuf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryDateInfo");

    rc = (DbgFolder_parent_WPFolder_wpQueryDateInfo(somSelf,
                                                      pstFileFindBuf));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 *
 *     * WPFolder methods overridden by DbgFolder:
 *
 */

SOM_Scope ULONG  SOMLINK dfdr_wpConfirmKeepAssoc(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpConfirmKeepAssoc");

    rc = (DbgFolder_parent_WPFolder_wpConfirmKeepAssoc(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope void  SOMLINK dfdr_wpFreeIconPosData(DbgFolder *somSelf)
{
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpFreeIconPosData");

    DbgFolder_parent_WPFolder_wpFreeIconPosData(somSelf);
    EndInstanceMethodDebug();
}

SOM_Scope BOOL  SOMLINK dfdr_wpInitIconPosData(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpInitIconPosData");

    rc = (DbgFolder_parent_WPFolder_wpInitIconPosData(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpQueryIconPosition(DbgFolder *somSelf,
                                                 PSZ pszIdentity,
                                                 PPOINTL pptl,
                                                 PULONG pIndex)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryIconPosition");

    rc = (DbgFolder_parent_WPFolder_wpQueryIconPosition(somSelf,
                                                          pszIdentity,
                                                          pptl,
                                                          pIndex));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope char*  SOMLINK dfdr_wpQueryIconViewPos(DbgFolder *somSelf)
{
    char *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryIconViewPos");

    rc = (DbgFolder_parent_WPFolder_wpQueryIconViewPos(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PPOINTL  SOMLINK dfdr_wpQueryNextIconPos(DbgFolder *somSelf)
{
    PPOINTL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryNextIconPos");

    rc = (DbgFolder_parent_WPFolder_wpQueryNextIconPos(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetNextIconPos(DbgFolder *somSelf,
                                              PPOINTL pptl)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetNextIconPos");

    rc = (DbgFolder_parent_WPFolder_wpSetNextIconPos(somSelf,
                                                       pptl));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * folder attributes methods
 */

SOM_Scope BOOL  SOMLINK dfdr_wpStoreIconPosData(DbgFolder *somSelf,
                                                PICONPOS pIconPos,
                                                ULONG cbSize)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpStoreIconPosData");

    rc = (DbgFolder_parent_WPFolder_wpStoreIconPosData(somSelf,
                                                         pIconPos,
                                                         cbSize));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpIsDetailsColumnVisible(DbgFolder *somSelf,
                                                      ULONG index)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpIsDetailsColumnVisible");

    rc = (DbgFolder_parent_WPFolder_wpIsDetailsColumnVisible(somSelf,
                                                               index));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpIsSortAttribAvailable(DbgFolder *somSelf,
                                                     ULONG index)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpIsSortAttribAvailable");

    rc = (DbgFolder_parent_WPFolder_wpIsSortAttribAvailable(somSelf,
                                                              index));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpModifyFldrFlags(DbgFolder *somSelf,
                                               ULONG ulFlags,
                                               ULONG ulFlagMask)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpModifyFldrFlags");

    rc = (DbgFolder_parent_WPFolder_wpModifyFldrFlags(somSelf,
                                                        ulFlags,
                                                        ulFlagMask));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryFldrAttr(DbgFolder *somSelf,
                                              ULONG ulView)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryFldrAttr");

    rc = (DbgFolder_parent_WPFolder_wpQueryFldrAttr(somSelf,
                                                      ulView));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope M_WPObject*  SOMLINK dfdr_wpQueryFldrDetailsClass(DbgFolder *somSelf)
{
    M_WPObject *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryFldrDetailsClass");

    rc = (DbgFolder_parent_WPFolder_wpQueryFldrDetailsClass(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpQueryFldrFlags(DbgFolder *somSelf)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryFldrFlags");

    rc = (DbgFolder_parent_WPFolder_wpQueryFldrFlags(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PSZ  SOMLINK dfdr_wpQueryFldrFont(DbgFolder *somSelf,
                                            ULONG ulView)
{
    PSZ rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryFldrFont");

    rc = (DbgFolder_parent_WPFolder_wpQueryFldrFont(somSelf,
                                                      ulView));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PVOID  SOMLINK dfdr_wpQueryFldrSort(DbgFolder *somSelf,
                                              ULONG ulView, ULONG ulType)
{
    PVOID rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryFldrSort");

    rc = (DbgFolder_parent_WPFolder_wpQueryFldrSort(somSelf,
                                                      ulView,
                                                      ulType));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope M_WPObject*  SOMLINK dfdr_wpQueryFldrSortClass(DbgFolder *somSelf)
{
    M_WPObject *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryFldrSortClass");

    rc = (DbgFolder_parent_WPFolder_wpQueryFldrSortClass(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetDetailsColumnVisibility(DbgFolder *somSelf,
                                                          ULONG index,
                                                          BOOL Visible)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetDetailsColumnVisibility");

    rc = (DbgFolder_parent_WPFolder_wpSetDetailsColumnVisibility(somSelf,
                                                                   index,
                                                                   Visible));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetFldrAttr(DbgFolder *somSelf,
                                           ULONG Attr, ULONG ulView)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetFldrAttr");

    rc = (DbgFolder_parent_WPFolder_wpSetFldrAttr(somSelf,
                                                    Attr, ulView));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetFldrDetailsClass(DbgFolder *somSelf,
                                                   M_WPObject* Class)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetFldrDetailsClass");

    rc = (DbgFolder_parent_WPFolder_wpSetFldrDetailsClass(somSelf,
                                                            Class));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetFldrFlags(DbgFolder *somSelf,
                                            ULONG ulFlags)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetFldrFlags");

    rc = (DbgFolder_parent_WPFolder_wpSetFldrFlags(somSelf,
                                                     ulFlags));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetFldrFont(DbgFolder *somSelf,
                                           PSZ pszFont, ULONG ulView)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetFldrFont");

    rc = (DbgFolder_parent_WPFolder_wpSetFldrFont(somSelf,
                                                    pszFont,
                                                    ulView));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetFldrSort(DbgFolder *somSelf,
                                           PVOID pSortRecord,
                                           ULONG ulView, ULONG ulType)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetFldrSort");

    rc = (DbgFolder_parent_WPFolder_wpSetFldrSort(somSelf,
                                                    pSortRecord,
                                                    ulView, ulType));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSetFldrSortClass(DbgFolder *somSelf,
                                                M_WPObject* Class)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetFldrSortClass");

    rc = (DbgFolder_parent_WPFolder_wpSetFldrSortClass(somSelf,
                                                         Class));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * folder state methods
 */

SOM_Scope BOOL  SOMLINK dfdr_wpSetSortAttribAvailable(DbgFolder *somSelf,
                                                      ULONG index,
                                                      BOOL Available)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSetSortAttribAvailable");

    rc = (DbgFolder_parent_WPFolder_wpSetSortAttribAvailable(somSelf,
                                                               index,
                                                               Available));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpHideFldrRunObjs(DbgFolder *somSelf,
                                               BOOL fHide)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpHideFldrRunObjs");

    rc = (DbgFolder_parent_WPFolder_wpHideFldrRunObjs(somSelf,
                                                        fHide));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope WPObject*  SOMLINK dfdr_wpQueryOpenFolders(DbgFolder *somSelf,
                                                     ULONG ulOption)
{
    WPObject *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryOpenFolders");

    rc = (DbgFolder_parent_WPFolder_wpQueryOpenFolders(somSelf,
                                                         ulOption));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpRestoreFldrRunObjs(DbgFolder *somSelf)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpRestoreFldrRunObjs");

    rc = (DbgFolder_parent_WPFolder_wpRestoreFldrRunObjs(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * folder notification methods
 * folder content methods
 */

SOM_Scope BOOL  SOMLINK dfdr_wpStoreFldrRunObjs(DbgFolder *somSelf,
                                                ULONG ulType)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpStoreFldrRunObjs");

    rc = (DbgFolder_parent_WPFolder_wpStoreFldrRunObjs(somSelf,
                                                         ulType));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope WPObject*  SOMLINK dfdr_wpAddFirstChild(DbgFolder *somSelf)
{
    WPObject *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpAddFirstChild");

    rc = (DbgFolder_parent_WPFolder_wpAddFirstChild(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpAddToContent(DbgFolder *somSelf,
                                            WPObject* Object)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpAddToContent");

    rc = (DbgFolder_parent_WPFolder_wpAddToContent(somSelf,
                                                     Object));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpContainsFolders(DbgFolder *somSelf,
                                               BOOL* pfSubFolders)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpContainsFolders");

    rc = (DbgFolder_parent_WPFolder_wpContainsFolders(somSelf,
                                                        pfSubFolders));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdr_wpDeleteContents(DbgFolder *somSelf,
                                               ULONG fConfirmations)
{
    ULONG rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpDeleteContents");

    rc = (DbgFolder_parent_WPFolder_wpDeleteContents(somSelf,
                                                       fConfirmations));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpDeleteFromContent(DbgFolder *somSelf,
                                                 WPObject* Object)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpDeleteFromContent");

    rc = (DbgFolder_parent_WPFolder_wpDeleteFromContent(somSelf,
                                                          Object));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpPopulate(DbgFolder *somSelf, ULONG ulReserved,
                                        PSZ pszPath, BOOL fFoldersOnly)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpPopulate");

    rc = (DbgFolder_parent_WPFolder_wpPopulate(somSelf, ulReserved,
                                                 pszPath, fFoldersOnly));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope WPObject*  SOMLINK dfdr_wpQueryContent(DbgFolder *somSelf,
                                                 WPObject* Object,
                                                 ULONG ulOption)
{
    WPObject *rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpQueryContent");

    rc = (DbgFolder_parent_WPFolder_wpQueryContent(somSelf,
                                                     Object,
                                                     ulOption));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK dfdr_wpSearchFolder(DbgFolder *somSelf,
                                            PSZ pszName, ULONG ulSearchType,
                                            ULONG ulLen, PSEARCH_INFO pInfo,
                                            WPFolder* ResultFolder)
{
    BOOL rc;
    DbgFolderData *somThis = DbgFolderGetData(somSelf);
    DbgFolderMethodDebug("DbgFolder","dfdr_wpSearchFolder");

    rc = (DbgFolder_parent_WPFolder_wpSearchFolder(somSelf,
                                                     pszName,
                                                     ulSearchType,
                                                     ulLen, pInfo,
                                                     ResultFolder));

    EndInstanceMethodDebug();
    return (rc);
}

/* ******************************************************************
 *
 *   here come the DbgFolder class methods
 *
 ********************************************************************/

SOM_Scope SOMObject*  SOMLINK dfdrM_somNew(M_DbgFolder *somSelf)
{
    SOMObject *rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_somNew");

    if (G_fDebugFolderInit)
    {
        _Pmpf(("++ Entering somNew"));
    }

    rc = (M_DbgFolder_parent_M_WPFolder_somNew(somSelf));

    if (G_fDebugFolderInit)
    {
        _Pmpf(("-- End of somNew; returning obj 0x%lX", rc ));
    }

    return (rc);
}

SOM_Scope SOMObject*  SOMLINK dfdrM_somNewNoInit(M_DbgFolder *somSelf)
{
    SOMObject *rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_somNewNoInit");

    if (G_fDebugFolderInit)
    {
        _Pmpf(("++ Entering somNewNoInit"));
    }

    rc = (M_DbgFolder_parent_M_WPFolder_somNewNoInit(somSelf));

    if (G_fDebugFolderInit)
    {
        _Pmpf(("-- End of somNewNoInit; returning obj 0x%lX", rc ));
    }

    return (rc);
}

SOM_Scope SOMObject*  SOMLINK dfdrM_somRenew(M_DbgFolder *somSelf,
                                             void* obj)
{
    SOMObject *rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_somRenew");

    if (G_fDebugFolderInit)
    {
        _Pmpf(("++ Entering somRenew for obj 0x%lX", obj ));
    }

    rc = (M_DbgFolder_parent_M_WPFolder_somRenew(somSelf, obj));

    if (G_fDebugFolderInit)
    {
        _Pmpf(("-- End of somRenew; returning obj 0x%lX", rc ));
    }

    return (rc);
}

SOM_Scope SOMObject*  SOMLINK dfdrM_somRenewNoInit(M_DbgFolder *somSelf,
                                                   void* obj)
{
    SOMObject *rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_somRenewNoInit");

    if (G_fDebugFolderInit)
    {
        _Pmpf(("++ Entering somRenewNoInit for obj 0x%lX", obj ));
    }

    rc = (M_DbgFolder_parent_M_WPFolder_somRenewNoInit(somSelf,
                                                         obj));

    if (G_fDebugFolderInit)
    {
        _Pmpf(("-- End of somRenewNoInit; returning obj 0x%lX", rc ));
    }

    return (rc);
}

SOM_Scope SOMObject*  SOMLINK dfdrM_somRenewNoInitNoZero(M_DbgFolder *somSelf,
                                                         void* obj)
{
    SOMObject *rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_somRenewNoInitNoZero");

    if (G_fDebugFolderInit)
    {
        _Pmpf(("++ Entering somRenewNoInitNoZero for obj 0x%lX", obj ));
    }

    rc = (M_DbgFolder_parent_M_WPFolder_somRenewNoInitNoZero(somSelf,
                                                               obj));

    if (G_fDebugFolderInit)
    {
        _Pmpf(("-- End of somRenewNoInitNoZero; returning obj 0x%lX",
                rc));
    }

    return (rc);
}

SOM_Scope SOMObject*  SOMLINK dfdrM_somRenewNoZero(M_DbgFolder *somSelf,
                                                   void* obj)
{
    SOMObject *rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_somRenewNoZero");

    if (G_fDebugFolderInit)
    {
        _Pmpf(("++ Entering somRenewNoZero"));
    }

    rc = (M_DbgFolder_parent_M_WPFolder_somRenewNoZero(somSelf,
                                                         obj));

    if (G_fDebugFolderInit)
    {
        _Pmpf(("-- End of somRenewNoZero; returning obj 0x%lX", rc ));
    }

    return (rc);
}

SOM_Scope long  SOMLINK dfdrM_somGetInstancePartSize(M_DbgFolder *somSelf)
{
    long rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_somGetInstancePartSize");

    if (G_fDebugFolderInit)
    {
        _Pmpf(("++ Entering somGetInstancePartSize"));
    }

    rc = (M_DbgFolder_parent_M_WPFolder_somGetInstancePartSize(somSelf));

    if (G_fDebugFolderInit)
    {
        _Pmpf(("-- End of somGetInstancePartSize; returning 0x%lX", rc ));
    }
    return (rc);
}

/*
 *
 *     * M_WPObject methods overridden by M_DbgFolder:
 *
 */

SOM_Scope long  SOMLINK dfdrM_somGetInstanceSize(M_DbgFolder *somSelf)
{
    long rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_somGetInstanceSize");

    if (G_fDebugFolderInit)
    {
        _Pmpf(("++ Entering somGetInstanceSize"));
    }

    rc = (M_DbgFolder_parent_M_WPFolder_somGetInstanceSize(somSelf));

    if (G_fDebugFolderInit)
    {
        _Pmpf(("-- End of somGetInstanceSize; returning 0x%lX", rc ));
    }

    return (rc);
}

SOM_Scope void  SOMLINK dfdrM_wpclsInitData(M_DbgFolder *somSelf)
{
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_wpclsInitData");

    M_DbgFolder_parent_M_WPFolder_wpclsInitData(somSelf);
}

SOM_Scope WPObject*  SOMLINK dfdrM_wpclsMakeAwake(M_DbgFolder *somSelf,
                                                  PSZ pszTitle,
                                                  ULONG ulStyle,
                                                  HPOINTER hptrIcon,
                                                  POBJDATA pObjData,
                                                  WPFolder* Folder,
                                                  ULONG ulUser)
{
    WPObject *rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_wpclsMakeAwake");

    if (G_fDebugFolderInit)
    {
        _Pmpf(("++ Entering wpclsMakeAwake"));
        _Pmpf(("        title: %s, ulStyle: 0x%lX, hptrIcon: 0x%lX, pObjData: 0x%lX, folder: 0x%lX (%s), ulUser: 0x%lX",
                    (pszTitle) ? pszTitle : "NULL",
                    ulStyle,
                    hptrIcon,
                    pObjData,
                    Folder,
                    (Folder) ? _wpQueryTitle(Folder) : "NULL",
                    ulUser));
    }

    rc = (M_DbgFolder_parent_M_WPFolder_wpclsMakeAwake(somSelf,
                                                         pszTitle,
                                                         ulStyle,
                                                         hptrIcon,
                                                         pObjData,
                                                         Folder,
                                                         ulUser));

    if (G_fDebugFolderInit)
    {
        _Pmpf(("-- End of wpclsMakeAwake; returning obj 0x%lX (%s)", rc, _wpQueryTitle(rc) ));
    }

    return (rc);
}

SOM_Scope WPObject*  SOMLINK dfdrM_wpclsNew(M_DbgFolder *somSelf,
                                            PSZ pszTitle, PSZ pszSetupEnv,
                                            WPFolder* Folder,
                                            BOOL fLock)
{
    WPObject *rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_wpclsNew");

    if (G_fDebugFolderInit)
    {
        _Pmpf(("++ Entering wpclsNew"));
        _Pmpf(("        title: %s, setup: %s, folder: 0x%lX (%s), fLock: %d",
                    (pszTitle) ? pszTitle : "NULL",
                    (pszSetupEnv) ? pszSetupEnv : "NULL",
                    Folder,
                    (Folder) ? _wpQueryTitle(Folder) : "NULL",
                    fLock));
    }

    rc = (M_DbgFolder_parent_M_WPFolder_wpclsNew(somSelf, pszTitle,
                                                   pszSetupEnv,
                                                   Folder, fLock));

    if (G_fDebugFolderInit)
    {
        _Pmpf(("-- End of wpclsNew; returned obj 0x%lX (%s)", rc, _wpQueryTitle(rc) ));
    }

    return (rc);
}

SOM_Scope WPObject*  SOMLINK dfdrM_wpclsFileSysExists(M_DbgFolder *somSelf,
                                                      WPFolder* Folder,
                                                      PSZ pszFilename,
                                                      ULONG attrFile)
{
    WPObject *rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_wpclsFileSysExists");

    rc = (M_DbgFolder_parent_M_WPFolder_wpclsFileSysExists(somSelf,
                                                             Folder,
                                                             pszFilename,
                                                             attrFile));

    return (rc);
}

/*
 *
 *     * M_WPFolder methods overridden by M_DbgFolder:
 *
 */

SOM_Scope WPObject*  SOMLINK dfdrM_wpclsQueryAwakeObject(M_DbgFolder *somSelf,
                                                         PSZ pszInputPath)
{
    WPObject *rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_wpclsQueryAwakeObject");

    rc = (M_DbgFolder_parent_M_WPFolder_wpclsQueryAwakeObject(somSelf,
                                                                pszInputPath));
    return (rc);
}

SOM_Scope ULONG  SOMLINK dfdrM_wpclsQueryIconDataN(M_DbgFolder *somSelf,
                                                   ICONINFO* pIconInfo,
                                                   ULONG ulIconIndex)
{
    ULONG rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_wpclsQueryIconDataN");

    rc = (M_DbgFolder_parent_M_WPFolder_wpclsQueryIconDataN(somSelf,
                                                              pIconInfo,
                                                              ulIconIndex));
    return (rc);
}

SOM_Scope HPOINTER  SOMLINK dfdrM_wpclsQueryIconN(M_DbgFolder *somSelf,
                                                  ULONG ulIconIndex)
{
    HPOINTER rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_wpclsQueryIconN");

    rc = (M_DbgFolder_parent_M_WPFolder_wpclsQueryIconN(somSelf,
                                                          ulIconIndex));
    return (rc);
}

SOM_Scope WPFolder*  SOMLINK dfdrM_wpclsQueryOpenFolders(M_DbgFolder *somSelf,
                                                         WPFolder* Folder,
                                                         ULONG ulOption,
                                                         BOOL fLock)
{
    WPFolder *rc;
    /* M_DbgFolderData *somThis = M_DbgFolderGetData(somSelf); */
    M_DbgFolderMethodDebug("M_DbgFolder","dfdrM_wpclsQueryOpenFolders");

    rc = (M_DbgFolder_parent_M_WPFolder_wpclsQueryOpenFolders(somSelf,
                                                                Folder,
                                                                ulOption,
                                                                fLock));
    return (rc);
}

