IMPLEMENTATION MODULE dry2;

(* IMPORT Strings; *)

(* Func2:
 *   For FST/Logitech/Stony Brook, string comparation is
 *   IF Strings.CompareStr (Str1ParRef, Str2ParRef) > 0 THEN
 * for all others,
 * IF Strings.Compare (Str1ParRef, Str2ParRef) = Strings.greater THEN
 *
 * Therefore I wrote my own version
 *)

PROCEDURE strcmp (VAR s1, s2: ARRAY OF CHAR): INTEGER;
VAR i, m: CARDINAL;
BEGIN
  i:=0;
  m := HIGH (s1); IF m>HIGH(s2) THEN m := HIGH(s2) END;
  LOOP
    IF (s1[i]#s2[i]) THEN
      IF s1[i]>s2[i] THEN RETURN 1 ELSE RETURN -1 END;
    END;
    IF s1[i]=0C THEN RETURN 0 END;
    INC (i);
    IF i > m THEN
      IF HIGH(s1)#HIGH(s2) THEN
        IF HIGH(s1)>HIGH(s2) THEN
          IF s1[i]#0C THEN RETURN 1 END;
        ELSE
          IF s2[i]#0C THEN RETURN -1 END;
        END;
      END;
      RETURN 0;
    END;
  END;
END strcmp;

PROCEDURE Proc6 (EnumValPar: Enumeration; VAR EnumRefPar: Enumeration);
    (* executed once *)
    (* EnumValPar == Ident3, EnumRefPar becomes Ident2 *)
BEGIN
  EnumRefPar := EnumValPar;
  IF ~Func3 (EnumValPar) THEN
    (* then, not executed *)
    EnumRefPar := Ident4;
  END;
  CASE EnumValPar OF
  | Ident1:
      EnumRefPar := Ident1;
  | Ident2:
      IF IntGlob > 100 THEN
        (* then *)
        EnumRefPar := Ident1;
      ELSE
        EnumRefPar := Ident4;
      END;
  | Ident3:
      (* executed *)
      EnumRefPar := Ident2;
  | Ident4: ;
  | Ident5:
      EnumRefPar := Ident3;
  END;
END Proc6;


PROCEDURE Proc7 (Int1ParVal, Int2ParVal: INTEGER; VAR IntParRef: INTEGER);
    (* executed three times                                *)
    (* first call:      Int1ParVal == 2, Int2ParVal == 3,  *)
    (*                  IntParRef becomes 7                *)
    (* second call:     Int1ParVal == 10, Int2ParVal == 5, *)
    (*                  IntParRef becomes 17               *)
    (* third call:      Int1ParVal == 6, Int2ParVal == 10, *)
    (*                  IntParRef becomes 18               *)
VAR
  IntLoc: INTEGER;
BEGIN
  IntLoc := Int1ParVal + 2;
  IntParRef := Int2ParVal + IntLoc;
END Proc7;


PROCEDURE Proc8 (VAR Arr1ParRef: Arr1Dim;
                 VAR Arr2ParRef: Arr2Dim;
                     Int1ParVal, Int2ParVal: INTEGER);
    (* executed once   *)
    (* IntParVal1 == 3 *)
    (* IntParVal2 == 7 *)
VAR
  IntIndex,
  IntLoc: INTEGER;
BEGIN
  IntLoc := Int1ParVal + 5;
  Arr1ParRef [IntLoc] := Int2ParVal;
  Arr1ParRef [IntLoc+1] := Arr1ParRef [IntLoc];
  Arr1ParRef [IntLoc+30] := IntLoc;
  FOR IntIndex := IntLoc TO IntLoc+1 DO
    Arr2ParRef [IntLoc] [IntIndex] := IntLoc;
  END;
  INC (Arr2ParRef [IntLoc] [IntLoc-1]);
  Arr2ParRef [IntLoc+20] [IntLoc] := Arr1ParRef [IntLoc];
  IntGlob := 5;
END Proc8;


PROCEDURE Func1 (Ch1ParVal, Ch2ParVal: CapitalLetter): Enumeration;
    (* executed three times                                   *)
    (* first call:      Ch1ParVal == 'H', Ch2ParVal == 'R'    *)
    (* second call:     Ch1ParVal == 'A', Ch2ParVal == 'C'    *)
    (* third call:      Ch1ParVal == 'B', Ch2ParVal == 'C'    *)
VAR
  Ch1Loc,
  Ch2Loc: CapitalLetter;
BEGIN
  Ch1Loc := Ch1ParVal;
  Ch2Loc := Ch1Loc;
  IF Ch2Loc # Ch2ParVal THEN
    (* then, executed *)
    RETURN Ident1;
  ELSE
    (* not executed *)
    Ch1Glob := Ch1Loc;
    RETURN Ident2;
  END;
END Func1;


PROCEDURE Func2 (VAR Str1ParRef, Str2ParRef: Str30): BOOLEAN;
    (* executed once *)
    (* Str1ParRef == "DHRYSTONE PROGRAM, 1'ST STRING" *)
    (* Str2ParRef == "DHRYSTONE PROGRAM, 2'ND STRING" *)
VAR
  IntLoc: OneThirty;
  ChLoc: CapitalLetter;
BEGIN
  IntLoc := 2;
  WHILE IntLoc <= 2 DO
    (* loop body executed once *)
    IF Func1 (Str1ParRef[IntLoc], Str2ParRef[IntLoc+1]) = Ident1 THEN
      (* then, executed *)
      ChLoc := 'A';
      INC (IntLoc);
    END;
  END;
  IF (ChLoc >= 'W') AND (ChLoc < 'Z') THEN
    (* then, not executed *)
    IntLoc := 7;
  END;
  IF ChLoc = 'R' THEN
    (* then, not executed *)
    RETURN TRUE;
  ELSE
    (* executed *)

    (* it should be one of *)
    (* IF Strings.CompareStr (Str1ParRef, Str2ParRef) > 0 THEN *)
    (* IF Strings.Compare (Str1ParRef, Str2ParRef) = Strings.greater THEN *)

    IF strcmp (Str1ParRef, Str2ParRef) > 0 THEN
      (* then, not executed *)
      INC (IntLoc, 7);
      IntGlob := IntLoc;
      RETURN TRUE;
    ELSE
      (* executed *)
      RETURN FALSE;
    END;
  END;
END Func2;


PROCEDURE Func3 (EnumParVal: Enumeration): BOOLEAN;
    (* executed once        *)
    (* EnumParVal == Ident3 *)
VAR
  EnumLoc: Enumeration;
BEGIN
  EnumLoc := EnumParVal;
  IF EnumLoc = Ident3 THEN
    (* then, executed *)
    RETURN TRUE;
  ELSE
    (* not executed *)
    RETURN FALSE;
  END;
END Func3;


END dry2.
