#include <os2.h>
#include <os2me.h>

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sys\types.h>

#include <inttypes.h>

#include "stream.h"
#include "demuxer.h"
#include "stheader.h"

#include "codecs.h"

// ffmpeg
#include "avcodec.h"
#include "dsputil.h"

// libmpeg2
#include "video_out.h"
#include "mpeg2.h"

unsigned char *dive_internal_buffer;
int dive_internal_bpl;

#include "vdecode.h"

#include "yuv2rgb.h"

video_header_t video_header;

AVCodecContext video_context;
AVCodec *video_codec=NULL;
AVPicture video_picture;

int video_init(sh_video_t *sh_video, int codec_type)
{
    avcodec_init();
    avcodec_register_all();

    switch(codec_type)
    {
        case VIDEO_MPEG:
            video_header.codec = CODEC_LIBMPEG2;
        break;

        case VIDEO_MP4V1:
            video_codec = (AVCodec *)avcodec_find_decoder(CODEC_ID_MSMPEG4V1);

            video_header.codec = CODEC_FFMPEG;
        break;

        case VIDEO_MP4V2:
            video_codec = (AVCodec *)avcodec_find_decoder(CODEC_ID_MSMPEG4V2);

            video_header.codec = CODEC_FFMPEG;
        break;

        case VIDEO_DIVX:
            video_codec = (AVCodec *)avcodec_find_decoder(CODEC_ID_MSMPEG4V3);

            video_header.codec = CODEC_FFMPEG;
        break;

        case VIDEO_ODIVX:
            video_codec = (AVCodec *)avcodec_find_decoder(CODEC_ID_MPEG4);

            video_header.codec = CODEC_FFMPEG;
        break;

        case VIDEO_MJPG:
            video_codec = (AVCodec *)avcodec_find_decoder(CODEC_ID_MJPEG);

            video_header.codec = CODEC_FFMPEG;
        break;

        case VIDEO_WMV1:
            video_codec = (AVCodec *)avcodec_find_decoder(CODEC_ID_WMV1);

            video_header.codec = CODEC_FFMPEG;
        break;
    }

    switch(video_header.codec)
    {
        case CODEC_FFMPEG:
        {
            if(!video_codec)
            {
                printf("Can't find video codec.\n");
                return 1;
            }

            memset(&video_context, 0, sizeof(video_context));
            video_context.width = sh_video->disp_w;
            video_context.height = sh_video->disp_h;

            if (avcodec_open(&video_context, video_codec) < 0)
            {
                printf("Can't open codec.\n");
                return 1;
            }

            printf("libavcodec: CPU flags:");
            if (mm_flags & MM_MMX)
                printf(" mmx");
            if (mm_flags & MM_MMXEXT)
                printf(" mmxext");
            if (mm_flags & MM_3DNOW)
                printf(" 3dnow");
            if (mm_flags & MM_SSE)
                printf(" sse");
            if (mm_flags & MM_SSE2)
                printf(" sse2");
            printf("\n");

            printf("libavcodec init OK!\n");
        }
        break;

        case CODEC_LIBMPEG2:
 
            init_mpeg2(sh_video->disp_h);

        break;
    }

    if (video_header.format == FMT_RGB16)
        yuv420_rgb_init(16);

    if (video_header.format == FMT_BGR24)
        yuv420_rgb_init(24);

    if (video_header.format == FMT_YUV422)
        yv12toyuy2_init();

    return 0;
}

int video_decode(sh_video_t *sh_video, unsigned char *dive_buffer, int bpl)
{
    int ret, in_size, x, y;
    float frame_time;
    unsigned char *start;
    int got_picture = 0;

    dive_internal_buffer = dive_buffer;
    dive_internal_bpl = bpl;

    in_size = video_read_frame(sh_video, &frame_time, &start,0);

    if (in_size < 0)
    {
        printf("End of video stream\n");
        fflush(stdout);

        return -1;
    }

    if (in_size == 0)
        return 1;

    switch(video_header.codec)
    {
        case CODEC_FFMPEG:
        {
//            video_context.hurry_up = 1;
            ret = avcodec_decode_video(&video_context, &video_picture,
                  &got_picture, start, in_size);

            if (got_picture == 0 || ret < 0)
            {
                return 1;
            }
        }
        break;

        case CODEC_LIBMPEG2:
        {
            decode_mpeg2(start, start + in_size);
        }
        break;
    }

    return 0;
}

int video_blit(sh_video_t *sh_video, unsigned char *Buffer, int bpl)
{

    dive_internal_buffer = Buffer;
    dive_internal_bpl = bpl;

    switch(video_header.codec)
    {
        case CODEC_FFMPEG:
        {
            dive_callback(video_picture.data[0],
                          video_picture.data[1],
                          video_picture.data[2],
                          sh_video->disp_w,
                          sh_video->disp_h,
                          video_picture.linesize[0],
                          video_picture.linesize[1]);
        }
        break;
    }

    return 0;
}

void dive_callback(uint8_t *py, uint8_t *pu, uint8_t *pv,
                   int width, int height,
                   int stride0, int stride1)
{
    int WidthRequested;

    WidthRequested = width;

    if (dive_internal_bpl / video_header.format_bpp > WidthRequested)
        WidthRequested = dive_internal_bpl / video_header.format_bpp;

    switch(video_header.format)
    {
        case FMT_RGB16:
        case FMT_BGR24:
        {
            yuv2rgb((unsigned char *)dive_internal_buffer,
                    py, pu, pv,
                    width, height,
                    WidthRequested, stride0, stride1);
        }
        break;

        case FMT_YUV422:
        {
            yv12toyuy2(py, pu, pv,
                       (unsigned char *)dive_internal_buffer,
                       width, height,
                       stride0, stride1, WidthRequested * 2);

        }
        break;
    }

    return;
}
