/* 
 * video_out_null.c
 * Copyright (C) 1999-2001 Aaron Holtzman <aholtzma@ess.engr.uvic.ca>
 *
 * This file is part of mpeg2dec, a free MPEG-2 video stream decoder.
 *
 * mpeg2dec is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * mpeg2dec is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"

#include <stdlib.h>
#include <inttypes.h>

#include "video_out.h"
#include "video_out_internal.h"

typedef struct dive_frame_s {
    vo_frame_t vo;
} dive_frame_t;

typedef struct dive_instance_s {
    vo_instance_t vo;
    int prediction_index;
    vo_frame_t * frame_ptr[3];
    dive_frame_t frame[3];
    int width;
    int height;
    int yuv_stride;
} dive_instance_t;

void dive_callback(uint8_t *, uint8_t *, uint8_t *, int, int, int, int);

static void dive_draw_frame (vo_frame_t * _frame)
{
    dive_frame_t * frame;
    dive_instance_t * instance;

    frame = (dive_frame_t *) _frame;
    instance = (dive_instance_t *) frame->vo.instance;

    dive_callback(frame->vo.base[0],
                  frame->vo.base[1],
                  frame->vo.base[2],
                  instance->width,
                  instance->height,
                  instance->yuv_stride,
                  instance->yuv_stride/2);
}

static vo_frame_t * out_dive_get_frame (vo_instance_t * _instance, int flags)
{
    dive_instance_t * instance;
    dive_frame_t * frame;

    instance = (dive_instance_t *) _instance;
    frame = (dive_frame_t *) libvo_common_get_frame ((vo_instance_t *) instance, flags);

    return (vo_frame_t *) frame;
}

static int out_dive_setup(vo_instance_t * _instance, int width, int height)
{
    dive_instance_t * instance;

    instance = (dive_instance_t *) _instance;

    instance->width = width;
    instance->yuv_stride = (width + 15) &~ 15;

    return libvo_common_alloc_frames ((vo_instance_t *) instance,
				      width, height, sizeof (dive_frame_t),
				      NULL, NULL,
                 		      dive_draw_frame);
}

vo_instance_t * vo_dive_open (int height)
{
    dive_instance_t * instance;

    instance = malloc (sizeof (dive_instance_t));
    if (instance == NULL)
	return NULL;

    instance->vo.setup = out_dive_setup;
    instance->vo.close = libvo_common_free_frames;
    instance->vo.get_frame = out_dive_get_frame;
    instance->width = 0;
    instance->height = height;

    return (vo_instance_t *) instance;
}
