/*
 * mpeg2dec.c
 * Copyright (C) 1999-2001 Aaron Holtzman <aholtzma@ess.engr.uvic.ca>
 *
 * This file is part of mpeg2dec, a free MPEG-2 video stream decoder.
 *
 * mpeg2dec is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * mpeg2dec is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <errno.h>
#include <inttypes.h>

#include "video_out.h"
#include "video_out_internal.h"
#include "mpeg2.h"
#include "mm_accel.h"

uint32_t accel;

static mpeg2dec_t mpeg2dec;
extern vo_open_t vo_dive_open;

void dive_draw(YUVpicture *picture, int width, int height)
{
/*
    ULONG bpl;
    unsigned char *dive_mem;

    dive_mem = dW->BeginPaint (&bpl, DIVE_NEXTBUFFER);

    yv12toyuy2(picture->base[0], picture->base[1], picture->base[2],
               (unsigned char *)dive_mem,
               width, height,
               width, width/2, bpl);
*/
/*
    yuv2rgb(dive_mem,
            picture->base[0],
            picture->base[1],
            picture->base[2],
            width,
            height,
	    width,
            width,
            width/2
           );
*/
/*
    dW->EndPaint();
    dW->Switch(DIVE_NEXTBUFFER);
    dW->WaitSwitch();
*/
    return;
}

void init_mpeg2(int height)
{

    mpeg2_init (&mpeg2dec, mm_accel(), vo_dive_open(height));

    return;
}

int decode_mpeg2(uint8_t * start, uint8_t * end)
{
    mpeg2_decode_data (&mpeg2dec, start, end);

    return 0;
}
