/*
 * OS/2 read-ahead cache layer
 *
 * Copyleft Alex Strelnikov.
 *
 * rcache is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * rcache is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/


#define INCL_DOS

#include <os2.h>


typedef struct CacheHeader
{
    int             Handle;            // File handle

    long            FilePos;           // Current file position
    long            ReadFilePos;       // Current read file position

    unsigned char   *CacheBuffer;      // Read-ahead buffer
    int             BufferSize;        // Read-ahead buffer size
    int             BufferPtr;         // Current buffer pointer
    int             BufferReadPtr;     // Current buffer read pointer
    int             BufferAvail;       // Buffer available data
    int             BufferEOF;         // End Of File flag
    int             ThreadStop;        // Stop thread flag
    int             CacheDisable;      // Disabled flag

    TID             BufferThread;      // Read-ahead thread id
    HMTX            BufferBusy;        // Access to buffer mutex semaphore

} CacheHeader;


int cache_open(char *patchname, int oflag);
int cache_close(int handle);
int cache_read(int handle, char *buffer, unsigned int count);
long cache_lseek(int handle, long offset, int origin);

int cache_disable(void);
int cache_enable(void);
