#ifndef DEF_H
#define DEF_H

typedef unsigned short HANDLE16;
typedef unsigned long HANDLE, *PHANDLE, *LPHANDLE;

#define DECLARE_HANDLE(a) \
	typedef HANDLE16 a##16; \
	typedef a##16 *P##a##16; \
	typedef a##16 *NP##a##16; \
	typedef a##16 *LP##a##16; \
	typedef HANDLE a; \
	typedef a *P##a; \
	typedef a *LP##a

DECLARE_HANDLE(HACMSTREAM);
DECLARE_HANDLE(HACMDRIVER);

// HIC struct (same layout as Win95 one)
typedef struct tagWINE_HIC {
	long		magic;		// 00: 'Smag'
	HANDLE	        curthread;	// 04:
	long		type;		// 08:
	long		handler;	// 0C:
	int		hdrv;		// 10:
	long		_private;	// 14:(handled by SendDriverMessage)
	int		driverproc;	// 18:(handled by SendDriverMessage)
	long		x1;		// 1c: name?
	short		x2;		// 20:
	long		x3;		// 22:
					// 26:
} HIC;

typedef struct _WAVEFORMATEX {
  WORD   wFormatTag;
  WORD   nChannels;
  DWORD  nSamplesPerSec;
  DWORD  nAvgBytesPerSec;
  WORD   nBlockAlign;
  WORD   wBitsPerSample;
  WORD   cbSize;
} WAVEFORMATEX, *PWAVEFORMATEX, *NPWAVEFORMATEX, *LPWAVEFORMATEX;

#endif
